/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJButtonBorder;
import com.intellij.ide.ui.laf.intellij.MacIntelliJIconCache;
import com.intellij.ui.Gray;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class MacIntelliJButtonUI
extends DarculaButtonUI {
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();

    public static ComponentUI createUI(JComponent c2) {
        return new MacIntelliJButtonUI();
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        if (!(c2.getBorder() instanceof MacIntelliJButtonBorder) && !MacIntelliJButtonUI.isComboButton(c2)) {
            super.paint(g2, c2);
            return;
        }
        int w2 = c2.getWidth();
        int h2 = c2.getHeight();
        if (MacIntelliJButtonUI.isHelpButton(c2)) {
            Icon icon = MacIntelliJIconCache.getIcon("helpButton", false, c2.hasFocus());
            int x2 = (w2 - icon.getIconWidth()) / 2;
            int y2 = (h2 - icon.getIconHeight()) / 2;
            icon.paintIcon(c2, g2, x2, y2);
        } else {
            AbstractButton b2 = (AbstractButton)c2;
            String text2 = this.layout(b2, SwingUtilities2.getFontMetrics((JComponent)b2, g2), b2.getWidth(), b2.getHeight());
            boolean isFocused = c2.hasFocus();
            if (MacIntelliJButtonUI.isSquare(c2)) {
                Icon icon = MacIntelliJIconCache.getIcon("browseButton");
                int x3 = (c2.getWidth() - icon.getIconWidth()) / 2;
                int y3 = (c2.getHeight() - icon.getIconHeight()) / 2;
                icon.paintIcon(c2, g2, x3, y3);
                return;
            }
            int x4 = isFocused ? 0 : 2;
            int y4 = isFocused ? 0 : (h2 - MacIntelliJButtonUI.viewRect.height) / 2;
            Icon icon = MacIntelliJButtonUI.getLeftIcon(b2);
            icon.paintIcon(b2, g2, x4, y4);
            int stop2 = w2 - (isFocused ? 0 : 2) - MacIntelliJButtonUI.getRightIcon(b2).getIconWidth();
            Graphics gg = g2.create(0, 0, w2, h2);
            gg.setClip(x4 += icon.getIconWidth(), y4, stop2 - x4, h2);
            icon = MacIntelliJButtonUI.getMiddleIcon(b2);
            while (x4 < stop2) {
                icon.paintIcon(b2, gg, x4, y4);
                x4 += icon.getIconWidth();
            }
            gg.dispose();
            icon = MacIntelliJButtonUI.getRightIcon(b2);
            icon.paintIcon(b2, g2, stop2, y4);
            this.clearTextShiftOffset();
            if (b2.getIcon() != null) {
                this.paintIcon(g2, c2, iconRect);
            }
            if (text2 != null && !text2.isEmpty()) {
                View v2 = (View)c2.getClientProperty("html");
                if (v2 != null) {
                    v2.paint(g2, textRect);
                } else {
                    UISettings.setupAntialiasing((Graphics)g2);
                    this.paintText(g2, b2, textRect, text2);
                }
            }
        }
    }

    protected static boolean isComboButton(JComponent c2) {
        return c2 instanceof AbstractButton && c2.getClientProperty("styleCombo") == Boolean.TRUE;
    }

    private static Icon getLeftIcon(AbstractButton button) {
        return MacIntelliJButtonUI.getIcon("Left", button);
    }

    private static Icon getMiddleIcon(AbstractButton button) {
        return MacIntelliJButtonUI.getIcon("Middle", button);
    }

    private static Icon getRightIcon(AbstractButton button) {
        return MacIntelliJButtonUI.getIcon("Right", button);
    }

    private static Icon getIcon(String suffix, AbstractButton button) {
        boolean isDefault = MacIntelliJButtonUI.isDefaultButton(button);
        boolean isFocused = button.hasFocus();
        boolean combo = MacIntelliJButtonUI.isComboButton(button);
        String comboPrefix = combo ? "Combo" : "";
        String iconName = "button" + comboPrefix + suffix;
        return MacIntelliJIconCache.getIcon(iconName, isDefault, isFocused && !combo);
    }

    private String layout(AbstractButton b2, FontMetrics fm, int width, int height) {
        Insets i2 = b2.getInsets();
        MacIntelliJButtonUI.viewRect.x = i2.left;
        MacIntelliJButtonUI.viewRect.y = i2.top;
        MacIntelliJButtonUI.viewRect.width = width - (i2.right + MacIntelliJButtonUI.viewRect.x);
        MacIntelliJButtonUI.viewRect.height = height - (i2.bottom + MacIntelliJButtonUI.viewRect.y);
        MacIntelliJButtonUI.textRect.height = 0;
        MacIntelliJButtonUI.textRect.width = 0;
        MacIntelliJButtonUI.textRect.y = 0;
        MacIntelliJButtonUI.textRect.x = 0;
        MacIntelliJButtonUI.iconRect.height = 0;
        MacIntelliJButtonUI.iconRect.width = 0;
        MacIntelliJButtonUI.iconRect.y = 0;
        MacIntelliJButtonUI.iconRect.x = 0;
        if (MacIntelliJButtonUI.isComboButton(b2)) {
            MacIntelliJButtonUI.viewRect.x += 6;
        }
        return SwingUtilities.layoutCompoundLabel(b2, fm, b2.getText(), b2.getIcon(), b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), viewRect, iconRect, textRect, b2.getText() == null ? 0 : b2.getIconTextGap());
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        Dimension size = super.getPreferredSize(c2);
        if (c2.getBorder() instanceof MacIntelliJButtonBorder || MacIntelliJButtonUI.isComboButton(c2)) {
            return new Dimension(size.width + (MacIntelliJButtonUI.isComboButton(c2) ? 8 : 16), 27);
        }
        return size;
    }

    @Override
    protected void paintDisabledText(Graphics g2, String text2, JComponent c2, Rectangle textRect, FontMetrics metrics) {
        int x2 = textRect.x + this.getTextShiftOffset();
        int y2 = textRect.y + metrics.getAscent() + this.getTextShiftOffset();
        if (MacIntelliJButtonUI.isDefaultButton(c2)) {
            g2.setColor((Color)Gray.xCC);
        } else {
            g2.setColor(UIManager.getColor("Button.disabledText"));
        }
        SwingUtilities2.drawStringUnderlineCharAt(c2, g2, text2, -1, x2, y2);
    }
}

