/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.ui.DarculaProgressBarUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJIconCache;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class MacIntelliJProgressBarUI
extends DarculaProgressBarUI {
    public static final int HEIGHT = 6;
    protected volatile int position = 0;

    public static ComponentUI createUI(JComponent c2) {
        return new MacIntelliJProgressBarUI();
    }

    @Override
    protected void paintDeterminate(Graphics g2, JComponent c2) {
        Insets insets = this.progressBar.getInsets();
        int w2 = c2.getWidth();
        int h2 = c2.getHeight();
        int y2 = (h2 - 6) / 2;
        int x2 = insets.left;
        Icon icon = MacIntelliJIconCache.getIcon("progressLeft");
        icon.paintIcon(c2, g2, x2, y2);
        int stop2 = w2 - MacIntelliJIconCache.getIcon("progressRight").getIconWidth();
        Graphics gg = g2.create(0, 0, w2, h2);
        gg.setClip(x2 += icon.getIconWidth(), y2, stop2 - x2, h2);
        icon = MacIntelliJIconCache.getIcon("progressMiddle");
        while (x2 < stop2) {
            icon.paintIcon(c2, gg, x2, y2);
            x2 += icon.getIconWidth();
        }
        gg.dispose();
        icon = MacIntelliJIconCache.getIcon("progressRight");
        icon.paintIcon(c2, g2, stop2, y2);
        int barRectWidth = w2 - (insets.right + insets.left);
        int barRectHeight = h2 - (insets.top + insets.bottom);
        int amountFull = this.getAmountFull(insets, barRectWidth, barRectHeight);
        boolean done2 = amountFull == barRectWidth;
        Icon left = MacIntelliJIconCache.getIcon("progressLeft", true, false);
        Icon middle = MacIntelliJIconCache.getIcon("progressMiddle", true, false);
        Icon right = MacIntelliJIconCache.getIcon("progressRight", true, false);
        gg = g2.create(0, 0, barRectWidth + insets.left - right.getIconWidth(), h2);
        gg.setClip(insets.left, y2, amountFull - right.getIconWidth(), 6);
        int cur = left.getIconWidth() + insets.left;
        if (cur <= amountFull) {
            left.paintIcon(c2, gg, insets.left, y2);
        }
        while (cur < amountFull) {
            middle.paintIcon(c2, gg, cur, y2);
            cur += middle.getIconWidth();
        }
        gg.dispose();
        if (done2) {
            right.paintIcon(c2, g2, insets.left + barRectWidth - right.getIconWidth(), y2);
        }
    }

    @Override
    protected void paintIndeterminate(Graphics g2, JComponent c2) {
        Insets insets = this.progressBar.getInsets();
        int w2 = c2.getWidth();
        int h2 = c2.getHeight();
        int y2 = (h2 - 6) / 2 + insets.top;
        int x2 = insets.left;
        Icon icon = MacIntelliJIconCache.getIcon("progressLeft", true, false);
        icon.paintIcon(c2, g2, x2, y2);
        int stop2 = w2 - MacIntelliJIconCache.getIcon("progressRight", true, false).getIconWidth() - insets.right;
        Graphics gg = g2.create(0, 0, w2, h2);
        gg.setClip(x2 += icon.getIconWidth(), y2, stop2 - x2, h2);
        icon = MacIntelliJIconCache.getIcon("progressMiddle", true, false);
        while (x2 < stop2) {
            icon.paintIcon(c2, gg, x2, y2);
            x2 += icon.getIconWidth();
        }
        gg.dispose();
        icon = MacIntelliJIconCache.getIcon("progressRight", true, false);
        icon.paintIcon(c2, g2, stop2, y2);
        Icon shadow = MacIntelliJIconCache.getIcon("progressShadow");
        int boxWidth = w2 - insets.left - insets.right;
        if (boxWidth <= 0) {
            return;
        }
        gg = g2.create(0, 0, w2, h2);
        gg.setClip(new RoundRectangle2D.Double(insets.left, y2, boxWidth, 6.0, 6.0, 6.0));
        shadow.paintIcon(c2, gg, this.position, y2);
        int xx = boxWidth - (this.position + shadow.getIconWidth());
        if (xx < 0) {
            shadow.paintIcon(c2, gg, -xx - shadow.getIconWidth(), y2);
        }
        ++this.position;
        this.position %= boxWidth;
        gg.dispose();
    }
}

