/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.IntelliJLaf;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJIconCache;
import com.intellij.ide.ui.laf.intellij.MacIntelliJTextBorder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class MacIntelliJTextFieldUI
extends TextFieldWithPopupHandlerUI {
    public MacIntelliJTextFieldUI(JTextField textField) {
        super(textField);
    }

    public static ComponentUI createUI(JComponent c2) {
        return new MacIntelliJTextFieldUI((JTextField)c2);
    }

    @Override
    public void showSearchPopup() {
        Object value2 = this.myTextField.getClientProperty("JTextField.Search.FindPopup");
        JTextComponent editor = this.getComponent();
        if (editor != null && value2 instanceof JPopupMenu) {
            JPopupMenu popup2 = (JPopupMenu)value2;
            popup2.show(editor, this.getSearchIconCoord().x, editor.getHeight());
        }
    }

    @Override
    public String getToolTipText(JTextComponent t2, Point pt) {
        AbstractAction action2;
        if (this.getActionUnder(pt) == TextFieldWithPopupHandlerUI.SearchAction.NEWLINE && (action2 = MacIntelliJTextFieldUI.getNewLineAction(t2)) != null) {
            return (String)action2.getValue("ShortDescription");
        }
        return super.getToolTipText(t2, pt);
    }

    @Override
    public TextFieldWithPopupHandlerUI.SearchAction getActionUnder(@NotNull Point p2) {
        if (p2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/ide/ui/laf/intellij/MacIntelliJTextFieldUI", "getActionUnder"));
        }
        int off = JBUI.scale((int)8);
        Point point = new Point(p2.x - off, p2.y - off);
        if (point.distance(this.getSearchIconCoord()) <= (double)off) {
            return TextFieldWithPopupHandlerUI.SearchAction.POPUP;
        }
        if (this.hasText() && point.distance(this.getClearIconCoord()) <= (double)off) {
            return TextFieldWithPopupHandlerUI.SearchAction.CLEAR;
        }
        if (MacIntelliJTextFieldUI.getNewLineAction(this.myTextField) != null && point.distance(this.getAddNewLineIconCoord()) <= (double)off) {
            return TextFieldWithPopupHandlerUI.SearchAction.NEWLINE;
        }
        return null;
    }

    protected Rectangle getDrawingRect() {
        return new Rectangle(0, (this.myTextField.getHeight() - 26) / 2, this.myTextField.getWidth(), this.myTextField.getHeight());
    }

    Icon getSearchIcon(Component c2) {
        return MacIntelliJIconCache.getIcon(MacIntelliJTextFieldUI.isSearchFieldWithHistoryPopup(c2) ? "searchFieldWithHistory" : "searchFieldLabel");
    }

    protected Point getSearchIconCoord() {
        Rectangle r2 = this.getDrawingRect();
        Icon icon = this.getSearchIcon(this.myTextField);
        return new Point(r2.x + (this.hasText() || this.myTextField.hasFocus() || MacIntelliJTextFieldUI.isSearchFieldWithHistoryPopup(this.myTextField) ? JBUI.scale((int)8) : (r2.width - icon.getIconWidth()) / 2), r2.y + (r2.height - icon.getIconHeight()) / 2 + JBUI.scale((int)1));
    }

    protected Point getClearIconCoord() {
        Rectangle r2 = this.getDrawingRect();
        return new Point(r2.x + r2.width - JBUI.scale((int)16) - JBUI.scale((int)6), r2.y + (r2.height - JBUI.scale((int)16)) / 2);
    }

    protected Point getAddNewLineIconCoord() {
        Point point = this.getClearIconCoord();
        if (!StringUtil.isEmpty((String)this.myTextField.getText())) {
            point.x -= JBUI.scale((int)16) + JBUI.scale((int)8);
        }
        return point;
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        Graphics2D g2 = (Graphics2D)graphics;
        JTextComponent c2 = this.getComponent();
        Container parent = c2.getParent();
        Rectangle r2 = this.getDrawingRect();
        if (c2.isOpaque() && parent != null) {
            g2.setColor(parent.getBackground());
            g2.fillRect(0, 0, c2.getWidth(), c2.getHeight());
        }
        if (MacIntelliJTextFieldUI.isSearchField(c2)) {
            this.paintSearchField(g2, c2, r2);
        } else if (c2.getBorder() instanceof MacIntelliJTextBorder) {
            g2.setColor(c2.getBackground());
            g2.fillRect(3, 3, c2.getWidth() - 6, c2.getHeight() - 6);
        } else {
            super.paintBackground(g2);
        }
    }

    @Override
    @NotNull
    public Dimension getPreferredSize(JComponent c2) {
        Dimension size = super.getPreferredSize(c2);
        Dimension dimension = new Dimension(size.width + this.getIconsWidth(c2), Math.max(26, size.height));
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/laf/intellij/MacIntelliJTextFieldUI", "getPreferredSize"));
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize(JComponent c2) {
        Dimension minimumSize = super.getMinimumSize(c2);
        return new Dimension(minimumSize.width + this.getIconsWidth(c2), minimumSize.height);
    }

    private int getIconsWidth(JComponent c2) {
        int width = 0;
        if (MacIntelliJTextFieldUI.isSearchField(c2)) {
            Icon label = this.getSearchIcon(c2);
            width += label.getIconWidth();
            if (this.hasText()) {
                Icon clearIcon = MacIntelliJIconCache.getIcon("searchFieldClear");
                width += clearIcon.getIconWidth() + 3;
            }
        }
        return width;
    }

    protected void paintSearchField(Graphics2D g2, JTextComponent c2, Rectangle r2) {
        Icon newLineIcon;
        AbstractAction newLineAction;
        boolean noBorder = c2.getClientProperty("JTextField.Search.noBorderRing") == Boolean.TRUE;
        boolean hasFocus = c2.hasFocus() && !noBorder;
        Icon left = MacIntelliJIconCache.getIcon("searchFieldLeft", false, hasFocus);
        Icon middle = MacIntelliJIconCache.getIcon("searchFieldMiddle", false, hasFocus);
        Icon right = MacIntelliJIconCache.getIcon("searchFieldRight", false, hasFocus);
        Graphics gg = g2.create(0, 0, c2.getWidth(), c2.getHeight());
        gg.setClip(r2.x, r2.y, r2.width - right.getIconWidth(), r2.height);
        int x2 = r2.x;
        int stop2 = r2.x + (r2.width - right.getIconWidth());
        left.paintIcon(c2, g2, r2.x, r2.y);
        x2 += left.getIconWidth();
        while (x2 < stop2) {
            middle.paintIcon(c2, gg, x2, r2.y);
            x2 += middle.getIconWidth();
        }
        gg.dispose();
        right.paintIcon(c2, g2, stop2, r2.y);
        boolean withHistoryPopup = MacIntelliJTextFieldUI.isSearchFieldWithHistoryPopup(c2);
        Icon label = this.getSearchIcon(c2);
        boolean isEmpty = !this.hasText();
        Point point = this.getSearchIconCoord();
        if (isEmpty && !c2.hasFocus() && !withHistoryPopup) {
            label.paintIcon(c2, g2, point.x, point.y);
        } else {
            gg = g2.create(0, 0, c2.getWidth(), c2.getHeight());
            gg.setClip(point.x, point.y, isEmpty ? label.getIconWidth() : 16, label.getIconHeight());
            label.paintIcon(c2, gg, point.x, point.y);
        }
        Icon clearIcon = MacIntelliJIconCache.getIcon("searchFieldClear");
        if (!isEmpty) {
            clearIcon.paintIcon(c2, g2, this.getClearIconCoord().x, r2.y);
        }
        if ((newLineAction = MacIntelliJTextFieldUI.getNewLineAction(c2)) != null && (newLineIcon = (Icon)newLineAction.getValue("SmallIcon")) != null) {
            newLineIcon.paintIcon(c2, g2, this.getAddNewLineIconCoord().x, r2.y);
        }
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        Rectangle rect = super.getVisibleEditorRect();
        if (rect != null) {
            if (MacIntelliJTextFieldUI.isSearchField(this.myTextField)) {
                int extraOffset = MacIntelliJTextFieldUI.isSearchFieldWithHistoryPopup(this.myTextField) ? 3 : 0;
                rect.width -= 36 + extraOffset;
                if (MacIntelliJTextFieldUI.getNewLineAction(this.myTextField) != null) {
                    rect.width -= 24;
                }
                rect.x += 19 + extraOffset;
                ++rect.y;
            } else {
                rect.x += 2;
                rect.width -= 4;
            }
        }
        return rect;
    }

    @Override
    protected void paintSafely(Graphics g2) {
        this.paintBackground(g2);
        super.paintSafely(g2);
    }

    public static void paintAquaSearchFocusRing(Graphics2D g2, Rectangle r2, Component c2) {
        g2 = (Graphics2D)g2.create(0, 0, r2.width, r2.height);
        GraphicsUtil.setupAAPainting((Graphics)g2);
        g2.setColor(c2.getBackground());
        RoundRectangle2D.Double border = MacIntelliJTextFieldUI.getShape(r2, 4.0, true);
        g2.fill(border);
        g2.setColor((Color)Gray._192);
        g2.setStroke(new BasicStroke(0.5f));
        g2.draw(MacIntelliJTextFieldUI.getShape(r2, 4.0, false));
        if (c2.hasFocus()) {
            Color graphiteColor = new Color(7303026);
            Color blueColor = ColorUtil.brighter((Color)new Color(28130), (int)3);
            g2.setColor(ColorUtil.withAlpha((Color)(IntelliJLaf.isGraphite() ? graphiteColor : blueColor), (double)0.35));
            Area area = new Area(MacIntelliJTextFieldUI.getShape(r2, 7.0, false));
            area.subtract(new Area(MacIntelliJTextFieldUI.getShape(r2, 3.5, true)));
            g2.fill(area);
        }
        g2.dispose();
    }

    private static RoundRectangle2D.Double getShape(Rectangle r2, double radius, boolean inner) {
        double max_radius = 6.0;
        radius = Math.min(max_radius, Math.max(0.0, radius));
        double inset = max_radius - radius;
        double indent = inner ? 0.5 : 0.0;
        return new RoundRectangle2D.Double((double)r2.x + inset + indent, (double)r2.y + inset + indent, (double)r2.width - 2.0 * inset - indent, (double)r2.height - 2.0 * inset - indent, 2.0 * radius, 2.0 * radius);
    }
}

