/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class WinIntelliJButtonPainter
implements Border,
UIResource {
    private static final int myOffset = 4;

    @Override
    public void paintBorder(Component c2, Graphics graphics, int x2, int y2, int width, int height) {
        Graphics2D g2 = (Graphics2D)graphics;
        boolean hasFocus = c2.hasFocus();
        boolean isDefault = DarculaButtonUI.isDefaultButton((JComponent)c2);
        if (hasFocus || isDefault) {
            if (!DarculaButtonUI.isHelpButton((JComponent)c2)) {
                g2.setColor(UIManager.getColor("Button.intellij.native.activeBorderColor"));
                int d2 = JBUI.scale((int)1);
                int dd = JBUI.scale((int)2);
                Area s1 = new Area(new Rectangle2D.Float(d2, d2, width - 2 * d2, height - 2 * d2));
                Area s2 = new Area(new Rectangle2D.Float(d2 + dd, d2 + dd, width - 2 * d2 - 2 * dd, height - 2 * d2 - 2 * dd));
                s1.subtract(s2);
                g2.fill(s1);
                g2.translate(x2, y2);
                if (hasFocus) {
                    g2.setColor((Color)Gray.x0F);
                    UIUtil.drawDottedRectangle((Graphics)g2, (int)(2 * dd), (int)(2 * dd), (int)(width - 2 * dd - 1), (int)(height - 2 * dd - 1));
                }
                g2.translate(-x2, -y2);
            }
        } else {
            g2.setColor(UIManager.getColor("Button.intellij.native.borderColor"));
            if (!DarculaButtonUI.isHelpButton((JComponent)c2)) {
                g2.translate(x2, y2);
                g2.drawRect(0, 0, width - 1, height - 1);
                g2.translate(-x2, -y2);
            }
        }
    }

    @Override
    public Insets getBorderInsets(Component c2) {
        if (c2.getParent() instanceof ActionToolbar) {
            return JBUI.insets((int)4, (int)16).asUIResource();
        }
        if (DarculaButtonUI.isSquare(c2)) {
            return JBUI.insets((int)2, (int)0).asUIResource();
        }
        return JBUI.insets((int)3, (int)17).asUIResource();
    }

    protected int getOffset() {
        return 4;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

