/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJIconCache;
import com.intellij.ide.ui.laf.intellij.WinIntelliJButtonPainter;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import sun.swing.SwingUtilities2;

public class WinIntelliJButtonUI
extends DarculaButtonUI {
    private PropertyChangeListener helpButtonListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object source = evt.getSource();
            if (source instanceof AbstractButton && DarculaButtonUI.isHelpButton((JComponent)source)) {
                ((AbstractButton)source).setOpaque(false);
            }
        }
    };

    public static ComponentUI createUI(JComponent c2) {
        return new WinIntelliJButtonUI();
    }

    @Override
    protected void installListeners(AbstractButton b2) {
        super.installListeners(b2);
        b2.addPropertyChangeListener("JButton.buttonType", this.helpButtonListener);
    }

    @Override
    protected void uninstallListeners(AbstractButton b2) {
        b2.removePropertyChangeListener("JButton.buttonType", this.helpButtonListener);
        super.uninstallListeners(b2);
    }

    @Override
    protected boolean paintDecorations(Graphics2D g2, JComponent c2) {
        if (WinIntelliJButtonUI.isHelpButton(c2)) {
            Icon help = MacIntelliJIconCache.getIcon("winHelp");
            help.paintIcon(c2, g2, (c2.getWidth() - help.getIconWidth()) / 2, (c2.getHeight() - help.getIconHeight()) / 2);
            return false;
        }
        Insets i2 = c2.getInsets();
        g2.setColor(c2.hasFocus() ? UIManager.getColor("Button.intellij.native.activeBackgroundColor") : c2.getBackground());
        if (c2.getBorder() instanceof WinIntelliJButtonPainter) {
            g2.fillRect(0, 0, c2.getWidth(), c2.getHeight());
        } else {
            g2.fillRect(i2.left, i2.top, c2.getWidth() - i2.left - i2.right, c2.getHeight() - i2.top - i2.bottom);
        }
        return true;
    }

    @Override
    protected void setupDefaultButton(JButton button) {
    }

    @Override
    protected void paintDisabledText(Graphics g2, String text2, JComponent c2, Rectangle textRect, FontMetrics metrics) {
        g2.setColor(UIManager.getColor("Button.disabledText"));
        SwingUtilities2.drawStringUnderlineCharAt(c2, g2, text2, -1, textRect.x + this.getTextShiftOffset(), textRect.y + metrics.getAscent() + this.getTextShiftOffset());
    }
}

