/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.ColorPanel;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class WinIntelliJTextBorder
implements Border,
UIResource {
    @Override
    public Insets getBorderInsets(Component c2) {
        int vOffset;
        int n2 = vOffset = TextFieldWithPopupHandlerUI.isSearchField(c2) ? 6 : 4;
        if (TextFieldWithPopupHandlerUI.isSearchFieldWithHistoryPopup(c2)) {
            return JBUI.insets((int)vOffset, (int)26, (int)vOffset, (int)23).asUIResource();
        }
        if (TextFieldWithPopupHandlerUI.isSearchField(c2)) {
            return JBUI.insets((int)vOffset, (int)23, (int)vOffset, (int)23).asUIResource();
        }
        if (c2 instanceof JTextField && c2.getParent() instanceof ColorPanel) {
            return JBUI.insets((int)3, (int)3, (int)2, (int)2).asUIResource();
        }
        return JBUI.insets((int)vOffset, (int)7, (int)vOffset, (int)7).asUIResource();
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        if (DarculaTextFieldUI.isSearchField(c2)) {
            return;
        }
        Graphics2D g3 = (Graphics2D)g2;
        GraphicsConfig config = new GraphicsConfig((Graphics)g3);
        g3.translate(x2, y2);
        boolean editable = !(c2 instanceof JTextComponent) || ((JTextComponent)c2).isEditable();
        int d2 = JBUI.scale((int)1);
        int dd = JBUI.scale((int)2);
        if (c2.hasFocus()) {
            g3.setColor(WinIntelliJTextBorder.getBorderColor(c2.isEnabled() && editable, true));
            Area s1 = new Area(new Rectangle2D.Float(d2, d2, width - 2 * d2, height - 2 * d2));
            Area s2 = new Area(new Rectangle2D.Float(d2 + dd, d2 + dd, width - 2 * d2 - 2 * dd, height - 2 * d2 - 2 * dd));
            s1.subtract(s2);
            g3.fill(s1);
        } else {
            g3.setColor(WinIntelliJTextBorder.getBorderColor(c2.isEnabled() && editable, false));
            g3.drawRect(d2, d2, width - 2 * d2, height - 2 * d2);
        }
        g3.translate(-x2, -y2);
        config.restore();
    }

    private static Color getBorderColor(boolean enabled, boolean focus) {
        if (focus) {
            return UIManager.getColor("TextField.activeBorderColor");
        }
        return UIManager.getColor(enabled ? "TextField.borderColor" : "disabledBorderColor");
    }
}

