/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.PatternUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GotoLineNumberDialog
extends DialogWrapper {
    private final Pattern myPattern = PatternUtil.compileSafe((String)"\\s*(\\d+)?\\s*(?:[,:]?\\s*(\\d+)?)?\\s*", null);
    private JTextField myField;
    private JTextField myOffsetField;

    public GotoLineNumberDialog(Project project2) {
        super(project2, true);
        this.setTitle("Go to Line/Column");
    }

    private static boolean isInternal() {
        return ApplicationManagerEx.getApplicationEx().isInternal();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myField;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    private String getText() {
        return this.myField.getText();
    }

    @Nullable
    protected final Coordinates getCoordinates() {
        Matcher m2 = this.myPattern.matcher(this.getText());
        if (!m2.matches()) {
            return null;
        }
        int l2 = StringUtil.parseInt((String)m2.group(1), (int)(this.getLine() + 1));
        int c2 = StringUtil.parseInt((String)m2.group(2), (int)-1);
        return l2 > 0 ? new Coordinates(l2 - 1, Math.max(0, c2 - 1)) : null;
    }

    protected abstract int getLine();

    protected abstract int getColumn();

    protected abstract int getOffset();

    protected abstract int getMaxOffset();

    protected abstract int coordinatesToOffset(@NotNull Coordinates var1);

    @NotNull
    protected abstract Coordinates offsetToCoordinates(int var1);

    protected JComponent createNorthPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = JBUI.insets((int)4, (int)0, (int)8, (int)8);
        gbConstraints.fill = 3;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.anchor = 13;
        JLabel label = new JLabel("[Line] [:column]:");
        panel2.add((Component)label, gbConstraints);
        gbConstraints.fill = 1;
        gbConstraints.weightx = 1.0;
        class MyTextField
        extends JTextField {
            public MyTextField() {
                super("");
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension d2 = super.getPreferredSize();
                return new Dimension(200, d2.height);
            }
        }
        this.myField = new MyTextField();
        panel2.add((Component)this.myField, gbConstraints);
        this.myField.setText(String.format("%d:%d", this.getLine() + 1, this.getColumn() + 1));
        if (GotoLineNumberDialog.isInternal()) {
            gbConstraints.gridy = 1;
            gbConstraints.weightx = 0.0;
            gbConstraints.weighty = 1.0;
            gbConstraints.anchor = 13;
            JLabel offsetLabel = new JLabel("Offset:");
            panel2.add((Component)offsetLabel, gbConstraints);
            gbConstraints.fill = 1;
            gbConstraints.weightx = 1.0;
            this.myOffsetField = new MyTextField();
            panel2.add((Component)this.myOffsetField, gbConstraints);
            this.myOffsetField.setText(String.valueOf(this.getOffset()));
            DocumentAdapter valueSync = new DocumentAdapter(){
                boolean inSync;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void textChanged(DocumentEvent e2) {
                    if (this.inSync) {
                        return;
                    }
                    this.inSync = true;
                    String s2 = "<invalid>";
                    JTextComponent f2 = null;
                    try {
                        if (e2.getDocument() == GotoLineNumberDialog.this.myField.getDocument()) {
                            f2 = GotoLineNumberDialog.this.myOffsetField;
                            Coordinates p2 = GotoLineNumberDialog.this.getCoordinates();
                            s2 = p2 == null ? s2 : String.valueOf(GotoLineNumberDialog.this.coordinatesToOffset(p2));
                        } else {
                            f2 = GotoLineNumberDialog.this.myField;
                            int offset = StringUtil.parseInt((String)GotoLineNumberDialog.this.myOffsetField.getText(), (int)-1);
                            Coordinates p3 = offset >= 0 ? GotoLineNumberDialog.this.offsetToCoordinates(Math.min(GotoLineNumberDialog.this.getMaxOffset() - 1, offset)) : null;
                            s2 = p3 == null ? s2 : String.format("%d:%d", p3.row + 1, p3.column + 1);
                        }
                        f2.setText(s2);
                    }
                    catch (IndexOutOfBoundsException ignored) {
                        if (f2 != null) {
                            f2.setText(s2);
                        }
                    }
                    finally {
                        this.inSync = false;
                    }
                }
            };
            this.myField.getDocument().addDocumentListener((DocumentListener)valueSync);
            this.myOffsetField.getDocument().addDocumentListener((DocumentListener)valueSync);
        }
        return panel2;
    }

    protected static class Coordinates {
        public final int row;
        public final int column;

        public Coordinates(int row, int column) {
            this.row = row;
            this.column = column;
        }
    }
}

