/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.StructureViewComposite;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureViewCompositeModel
extends StructureViewModelBase
implements Disposable {
    private final StructureViewComposite.StructureViewDescriptor[] myViews;

    public StructureViewCompositeModel(PsiFile file2, StructureViewComposite.StructureViewDescriptor[] views) {
        super(file2, StructureViewCompositeModel.createRootNode(file2, views));
        this.myViews = views;
    }

    private static StructureViewTreeElement createRootNode(final PsiFile file2, final StructureViewComposite.StructureViewDescriptor[] views) {
        return new StructureViewTreeElement(){

            public Object getValue() {
                return file2;
            }

            public void navigate(boolean requestFocus2) {
                file2.navigate(requestFocus2);
            }

            public boolean canNavigate() {
                return file2.canNavigate();
            }

            public boolean canNavigateToSource() {
                return file2.canNavigateToSource();
            }

            @NotNull
            public ItemPresentation getPresentation() {
                ItemPresentation itemPresentation = file2.getPresentation();
                if (itemPresentation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/StructureViewCompositeModel$1", "getPresentation"));
                }
                return itemPresentation;
            }

            @NotNull
            public TreeElement[] getChildren() {
                ArrayList<TreeElement> elements = new ArrayList<TreeElement>();
                for (StructureViewComposite.StructureViewDescriptor view2 : views) {
                    elements.add(StructureViewCompositeModel.createTreeElementFromView(file2, view2));
                }
                TreeElement[] treeElementArray = elements.toArray(new TreeElement[elements.size()]);
                if (treeElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/StructureViewCompositeModel$1", "getChildren"));
                }
                return treeElementArray;
            }
        };
    }

    @NotNull
    public Collection<NodeProvider> getNodeProviders() {
        HashSet<NodeProvider> providers = new HashSet<NodeProvider>();
        for (StructureViewComposite.StructureViewDescriptor view2 : this.myViews) {
            StructureViewModel model2 = view2.structureView.getTreeModel();
            if (!(model2 instanceof ProvidingTreeModel)) continue;
            providers.addAll(((ProvidingTreeModel)model2).getNodeProviders());
        }
        HashSet<NodeProvider> hashSet = providers;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/StructureViewCompositeModel", "getNodeProviders"));
        }
        return hashSet;
    }

    @NotNull
    public Filter[] getFilters() {
        HashSet<Filter> filters2 = new HashSet<Filter>();
        for (StructureViewComposite.StructureViewDescriptor view2 : this.myViews) {
            StructureViewModel model2 = view2.structureView.getTreeModel();
            filters2.addAll(Arrays.asList(model2.getFilters()));
        }
        Filter[] filterArray = filters2.toArray(new Filter[filters2.size()]);
        if (filterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/StructureViewCompositeModel", "getFilters"));
        }
        return filterArray;
    }

    private static TreeElement createTreeElementFromView(final PsiFile file2, final StructureViewComposite.StructureViewDescriptor view2) {
        return new StructureViewTreeElement(){

            public Object getValue() {
                return view2;
            }

            public void navigate(boolean requestFocus2) {
                file2.navigate(requestFocus2);
            }

            public boolean canNavigate() {
                return file2.canNavigate();
            }

            public boolean canNavigateToSource() {
                return file2.canNavigateToSource();
            }

            @NotNull
            public ItemPresentation getPresentation() {
                ItemPresentation itemPresentation = new ItemPresentation(){

                    @Nullable
                    public String getPresentableText() {
                        return view2.title;
                    }

                    @Nullable
                    public String getLocationString() {
                        return null;
                    }

                    @Nullable
                    public Icon getIcon(boolean unused) {
                        return view2.icon;
                    }
                };
                if (itemPresentation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/StructureViewCompositeModel$2", "getPresentation"));
                }
                return itemPresentation;
            }

            @NotNull
            public TreeElement[] getChildren() {
                TreeElement[] treeElementArray = view2.structureView.getTreeModel().getRoot().getChildren();
                if (treeElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/StructureViewCompositeModel$2", "getChildren"));
                }
                return treeElementArray;
            }
        };
    }
}

