/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.concurrency.JobLauncher;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNameModelEx;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ContributorsBasedGotoByModel;
import com.intellij.ide.util.gotoByName.CustomMatcherModel;
import com.intellij.ide.util.gotoByName.MatchResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.SynchronizedCollectConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultChooseByNameItemProvider
implements ChooseByNameItemProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.gotoByName.ChooseByNameIdea");
    private final SmartPsiElementPointer myContext;

    public DefaultChooseByNameItemProvider(@Nullable PsiElement context2) {
        this.myContext = context2 == null ? null : SmartPointerManager.getInstance((Project)context2.getProject()).createSmartPsiElementPointer(context2);
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @NotNull Processor<Object> consumer2) {
        long started;
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "filterElements"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "filterElements"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "filterElements"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "filterElements"));
        }
        if (base.myProject != null) {
            base.myProject.putUserData(ChooseByNamePopup.CURRENT_SEARCH_PATTERN, (Object)pattern);
        }
        String namePattern = DefaultChooseByNameItemProvider.getNamePattern(base, pattern);
        String qualifierPattern = DefaultChooseByNameItemProvider.getQualifierPattern(base, pattern);
        if (DefaultChooseByNameItemProvider.removeModelSpecificMarkup(base.getModel(), namePattern).isEmpty() && !base.canShowListForEmptyPattern()) {
            return true;
        }
        final ChooseByNameModel model2 = base.getModel();
        String matchingPattern = DefaultChooseByNameItemProvider.convertToMatchingPattern(base, namePattern);
        if (matchingPattern == null) {
            return true;
        }
        ArrayList namesList = new ArrayList();
        SynchronizedCollectConsumer collect = new SynchronizedCollectConsumer(namesList);
        if (model2 instanceof ChooseByNameModelEx) {
            indicator.checkCanceled();
            started = System.currentTimeMillis();
            MinusculeMatcher matcher = DefaultChooseByNameItemProvider.buildPatternMatcher(matchingPattern, NameUtil.MatchingCaseSensitivity.NONE);
            ((ChooseByNameModelEx)model2).processNames((Processor<String>)((Processor)arg_0 -> DefaultChooseByNameItemProvider.lambda$filterElements$0(indicator, base, pattern, matcher, (CollectConsumer)collect, arg_0)), everywhere);
            if (LOG.isDebugEnabled()) {
                LOG.debug("loaded + matched:" + (System.currentTimeMillis() - started) + "," + collect.getResult().size());
            }
        } else {
            String[] names = base.getNames(everywhere);
            started = System.currentTimeMillis();
            DefaultChooseByNameItemProvider.processNamesByPattern(base, names, matchingPattern, indicator, (Consumer<MatchResult>)collect);
            if (LOG.isDebugEnabled()) {
                LOG.debug("matched:" + (System.currentTimeMillis() - started) + "," + names.length);
            }
        }
        indicator.checkCanceled();
        started = System.currentTimeMillis();
        List results = (List)collect.getResult();
        DefaultChooseByNameItemProvider.sortNamesList(namePattern, results);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sorted:" + (System.currentTimeMillis() - started) + ",results:" + results.size());
        }
        indicator.checkCanceled();
        SmartList sameNameElements = new SmartList();
        THashMap qualifierMatchResults = ContainerUtil.newIdentityTroveMap();
        Comparator<Object> weightComparator = new Comparator<Object>((Map)qualifierMatchResults){
            Comparator<Object> modelComparator;
            final /* synthetic */ Map val$qualifierMatchResults;
            {
                this.val$qualifierMatchResults = map2;
                this.modelComparator = model2 instanceof Comparator ? (Comparator)model2 : new PathProximityComparator(DefaultChooseByNameItemProvider.this.myContext == null ? null : DefaultChooseByNameItemProvider.this.myContext.getElement());
            }

            @Override
            public int compare(Object o1, Object o2) {
                int result2 = this.modelComparator.compare(o1, o2);
                return result2 != 0 ? result2 : ((MatchResult)this.val$qualifierMatchResults.get(o1)).compareTo((MatchResult)this.val$qualifierMatchResults.get(o2));
            }
        };
        ArrayList<Object> qualifierMiddleMatched = new ArrayList<Object>();
        List<Pair<String, MinusculeMatcher>> patternsAndMatchers = DefaultChooseByNameItemProvider.getPatternsAndMatchers(qualifierPattern, base);
        boolean sortedByMatchingDegree = !(base.getModel() instanceof CustomMatcherModel);
        IdFilter idFilter = null;
        if (model2 instanceof ContributorsBasedGotoByModel) {
            idFilter = ((ContributorsBasedGotoByModel)model2).getIdFilter(everywhere);
        }
        GlobalSearchScope searchScope = FindSymbolParameters.searchScopeFor(base.myProject, everywhere);
        FindSymbolParameters parameters = new FindSymbolParameters(pattern, namePattern, searchScope, idFilter);
        boolean afterStartMatch = false;
        for (MatchResult result2 : namesList) {
            Object[] elements;
            indicator.checkCanceled();
            String name = result2.elementName;
            boolean needSeparator = sortedByMatchingDegree && !result2.startMatch && afterStartMatch;
            Object[] objectArray = elements = model2 instanceof ContributorsBasedGotoByModel ? ((ContributorsBasedGotoByModel)model2).getElementsByName(name, parameters, indicator) : model2.getElementsByName(name, everywhere, namePattern);
            if (elements.length > 1) {
                sameNameElements.clear();
                qualifierMatchResults.clear();
                for (Object element : elements) {
                    indicator.checkCanceled();
                    MatchResult qualifierResult = DefaultChooseByNameItemProvider.matchQualifier(element, base, patternsAndMatchers);
                    if (qualifierResult == null) continue;
                    sameNameElements.add(element);
                    qualifierMatchResults.put(element, qualifierResult);
                }
                Collections.sort(sameNameElements, weightComparator);
                for (Object element : sameNameElements) {
                    if (!((MatchResult)qualifierMatchResults.get(element)).startMatch) {
                        qualifierMiddleMatched.add(element);
                        continue;
                    }
                    if (needSeparator && !DefaultChooseByNameItemProvider.startMiddleMatchVariants(qualifierMiddleMatched, consumer2)) {
                        return false;
                    }
                    if (!consumer2.process(element)) {
                        return false;
                    }
                    needSeparator = false;
                    afterStartMatch = result2.startMatch;
                }
                continue;
            }
            if (elements.length != 1 || DefaultChooseByNameItemProvider.matchQualifier(elements[0], base, patternsAndMatchers) == null) continue;
            if (needSeparator && !DefaultChooseByNameItemProvider.startMiddleMatchVariants(qualifierMiddleMatched, consumer2)) {
                return false;
            }
            if (!consumer2.process(elements[0])) {
                return false;
            }
            afterStartMatch = result2.startMatch;
        }
        return ContainerUtil.process(qualifierMiddleMatched, consumer2);
    }

    private static boolean startMiddleMatchVariants(@NotNull List<Object> qualifierMiddleMatched, @NotNull Processor<Object> consumer2) {
        if (qualifierMiddleMatched == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierMiddleMatched", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "startMiddleMatchVariants"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "startMiddleMatchVariants"));
        }
        if (!consumer2.process((Object)"non-prefix matches:")) {
            return false;
        }
        if (!ContainerUtil.process(qualifierMiddleMatched, consumer2)) {
            return false;
        }
        qualifierMiddleMatched.clear();
        return true;
    }

    private static void sortNamesList(@NotNull String namePattern, @NotNull List<MatchResult> namesList) {
        if (namePattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namePattern", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "sortNamesList"));
        }
        if (namesList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namesList", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "sortNamesList"));
        }
        Collections.sort(namesList, (mr1, mr2) -> {
            boolean exactPrefix2;
            if (namePattern == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namePattern", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "lambda$sortNamesList$1"));
            }
            boolean exactPrefix1 = namePattern.equalsIgnoreCase(mr1.elementName);
            if (exactPrefix1 != (exactPrefix2 = namePattern.equalsIgnoreCase(mr2.elementName))) {
                return exactPrefix1 ? -1 : 1;
            }
            return mr1.compareTo((MatchResult)mr2);
        });
    }

    @NotNull
    private static String getQualifierPattern(@NotNull ChooseByNameBase base, @NotNull String pattern) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "getQualifierPattern"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "getQualifierPattern"));
        }
        pattern = base.transformPattern(pattern);
        String[] separators = base.getModel().getSeparators();
        int lastSeparatorOccurrence = 0;
        for (String separator : separators) {
            int idx = pattern.lastIndexOf(separator);
            if (idx == pattern.length() - 1) {
                idx = pattern.lastIndexOf(separator, idx - 1);
            }
            lastSeparatorOccurrence = Math.max(lastSeparatorOccurrence, idx);
        }
        String string2 = pattern.substring(0, lastSeparatorOccurrence);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "getQualifierPattern"));
        }
        return string2;
    }

    @NotNull
    private static String getNamePattern(@NotNull ChooseByNameBase base, String pattern) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "getNamePattern"));
        }
        String transformedPattern = base.transformPattern(pattern);
        String string2 = DefaultChooseByNameItemProvider.getNamePattern(base.getModel(), transformedPattern);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "getNamePattern"));
        }
        return string2;
    }

    public static String getNamePattern(ChooseByNameModel model2, String pattern) {
        String[] separators = model2.getSeparators();
        int lastSeparatorOccurrence = 0;
        for (String separator : separators) {
            int idx = pattern.lastIndexOf(separator);
            if (idx == pattern.length() - 1) {
                idx = pattern.lastIndexOf(separator, idx - 1);
            }
            lastSeparatorOccurrence = Math.max(lastSeparatorOccurrence, idx == -1 ? idx : idx + separator.length());
        }
        return pattern.substring(lastSeparatorOccurrence);
    }

    @NotNull
    private static List<String> split(@NotNull String s2, @NotNull ChooseByNameBase base) {
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "split"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "split"));
        }
        ArrayList<String> answer = new ArrayList<String>();
        for (String token : StringUtil.tokenize((String)s2, (String)StringUtil.join((String[])base.getModel().getSeparators(), (String)""))) {
            if (token.isEmpty()) continue;
            answer.add(token);
        }
        List<String> list2 = answer.isEmpty() ? Collections.singletonList(s2) : answer;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "split"));
        }
        return list2;
    }

    private static MatchResult matchQualifier(@NotNull Object element, @NotNull ChooseByNameBase base, @NotNull List<Pair<String, MinusculeMatcher>> patternsAndMatchers) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "matchQualifier"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "matchQualifier"));
        }
        if (patternsAndMatchers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternsAndMatchers", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "matchQualifier"));
        }
        String name = base.getModel().getFullName(element);
        if (name == null) {
            return null;
        }
        List<String> suspects = DefaultChooseByNameItemProvider.split(name, base);
        int matchingDegree = 0;
        int matchPosition = 0;
        boolean startMatch = true;
        block0: for (Pair<String, MinusculeMatcher> patternAndMatcher : patternsAndMatchers) {
            String pattern = (String)patternAndMatcher.first;
            MinusculeMatcher matcher = (MinusculeMatcher)patternAndMatcher.second;
            if (pattern.isEmpty()) continue;
            for (int j2 = matchPosition; j2 < suspects.size() - 1; ++j2) {
                String suspect = suspects.get(j2);
                MatchResult suspectMatch = DefaultChooseByNameItemProvider.matches(base, pattern, matcher, suspect);
                if (suspectMatch != null) {
                    matchingDegree += suspectMatch.matchingDegree;
                    startMatch &= suspectMatch.startMatch;
                    matchPosition = j2 + 1;
                    continue block0;
                }
                matchingDegree -= (j2 + 1) * (j2 + 1);
            }
            return null;
        }
        for (int j3 = matchPosition; j3 < suspects.size() - 1; ++j3) {
            matchingDegree -= (j3 + 1) * (j3 + 1);
        }
        return new MatchResult(name, matchingDegree, startMatch);
    }

    @NotNull
    private static List<Pair<String, MinusculeMatcher>> getPatternsAndMatchers(@NotNull String qualifierPattern, @NotNull ChooseByNameBase base) {
        if (qualifierPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierPattern", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "getPatternsAndMatchers"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "getPatternsAndMatchers"));
        }
        List list2 = ContainerUtil.map2List(DefaultChooseByNameItemProvider.split(qualifierPattern, base), s2 -> {
            if (base == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "lambda$getPatternsAndMatchers$2"));
            }
            String namePattern = DefaultChooseByNameItemProvider.addSearchAnywherePatternDecorationIfNeeded(base, DefaultChooseByNameItemProvider.getNamePattern(base, s2));
            return Pair.create((Object)namePattern, (Object)DefaultChooseByNameItemProvider.buildPatternMatcher(namePattern, NameUtil.MatchingCaseSensitivity.NONE));
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "getPatternsAndMatchers"));
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<String> filterNames(@NotNull ChooseByNameBase base, @NotNull String[] names, @NotNull String pattern) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "filterNames"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "filterNames"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "filterNames"));
        }
        if ((pattern = DefaultChooseByNameItemProvider.convertToMatchingPattern(base, pattern)) == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 != null) return list2;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "filterNames"));
        }
        ArrayList<String> filtered = new ArrayList<String>();
        DefaultChooseByNameItemProvider.processNamesByPattern(base, names, pattern, ProgressIndicatorProvider.getGlobalProgressIndicator(), (Consumer<MatchResult>)((Consumer)result2 -> {
            List list2 = filtered;
            synchronized (list2) {
                filtered.add(result2.elementName);
            }
        }));
        ArrayList<String> arrayList2 = filtered;
        // MONITORENTER : arrayList2
        ArrayList<String> arrayList = filtered;
        // MONITOREXIT : arrayList2
        if (arrayList != null) return arrayList;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "filterNames"));
    }

    private static void processNamesByPattern(@NotNull ChooseByNameBase base, @NotNull String[] names, @NotNull String pattern, ProgressIndicator indicator, @NotNull Consumer<MatchResult> consumer2) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "processNamesByPattern"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "processNamesByPattern"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "processNamesByPattern"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "processNamesByPattern"));
        }
        MinusculeMatcher matcher = DefaultChooseByNameItemProvider.buildPatternMatcher(pattern, NameUtil.MatchingCaseSensitivity.NONE);
        Processor processor2 = name -> {
            if (base == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "lambda$processNamesByPattern$4"));
            }
            if (pattern == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "lambda$processNamesByPattern$4"));
            }
            if (consumer2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "lambda$processNamesByPattern$4"));
            }
            ProgressManager.checkCanceled();
            MatchResult result2 = DefaultChooseByNameItemProvider.matches(base, pattern, matcher, name);
            if (result2 != null) {
                consumer2.consume((Object)result2);
            }
            return true;
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(Arrays.asList(names), indicator, false, true, processor2)) {
            throw new ProcessCanceledException();
        }
    }

    @Nullable
    private static String convertToMatchingPattern(@NotNull ChooseByNameBase base, @NotNull String pattern) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "convertToMatchingPattern"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "convertToMatchingPattern"));
        }
        pattern = DefaultChooseByNameItemProvider.removeModelSpecificMarkup(base.getModel(), pattern);
        if (!base.canShowListForEmptyPattern() && pattern.isEmpty()) {
            return null;
        }
        return DefaultChooseByNameItemProvider.addSearchAnywherePatternDecorationIfNeeded(base, pattern);
    }

    @NotNull
    private static String addSearchAnywherePatternDecorationIfNeeded(@NotNull ChooseByNameBase base, @NotNull String pattern) {
        String trimmedPattern;
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "addSearchAnywherePatternDecorationIfNeeded"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "addSearchAnywherePatternDecorationIfNeeded"));
        }
        if (base.isSearchInAnyPlace() && !(trimmedPattern = pattern.trim()).isEmpty() && trimmedPattern.length() > 1) {
            pattern = "*" + pattern;
        }
        String string2 = pattern;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "addSearchAnywherePatternDecorationIfNeeded"));
        }
        return string2;
    }

    @NotNull
    private static String removeModelSpecificMarkup(@NotNull ChooseByNameModel model2, @NotNull String pattern) {
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "removeModelSpecificMarkup"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "removeModelSpecificMarkup"));
        }
        if (model2 instanceof ContributorsBasedGotoByModel) {
            pattern = ((ContributorsBasedGotoByModel)model2).removeModelSpecificMarkup(pattern);
        }
        String string2 = pattern;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "removeModelSpecificMarkup"));
        }
        return string2;
    }

    @Nullable
    private static MatchResult matches(@NotNull ChooseByNameBase base, @NotNull String pattern, @NotNull MinusculeMatcher matcher, @Nullable String name) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "matches"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "matches"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "matches"));
        }
        if (name == null) {
            return null;
        }
        if (base.getModel() instanceof CustomMatcherModel) {
            try {
                return ((CustomMatcherModel)base.getModel()).matches(name, pattern) ? new MatchResult(name, 0, true) : null;
            }
            catch (Exception e2) {
                LOG.info((Throwable)e2);
                return null;
            }
        }
        FList fragments = matcher.matchingFragments(name);
        return fragments != null ? new MatchResult(name, matcher.matchingDegree(name, false, fragments), MinusculeMatcher.isStartMatch((Iterable)fragments)) : null;
    }

    @NotNull
    private static MinusculeMatcher buildPatternMatcher(@NotNull String pattern, @NotNull NameUtil.MatchingCaseSensitivity caseSensitivity) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "buildPatternMatcher"));
        }
        if (caseSensitivity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caseSensitivity", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "buildPatternMatcher"));
        }
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher((String)pattern, (NameUtil.MatchingCaseSensitivity)caseSensitivity);
        if (minusculeMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "buildPatternMatcher"));
        }
        return minusculeMatcher;
    }

    private static /* synthetic */ boolean lambda$filterElements$0(@NotNull ProgressIndicator indicator, @NotNull ChooseByNameBase base, @NotNull String pattern, MinusculeMatcher matcher, CollectConsumer collect, String sequence) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "lambda$filterElements$0"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "lambda$filterElements$0"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider", "lambda$filterElements$0"));
        }
        indicator.checkCanceled();
        MatchResult result2 = DefaultChooseByNameItemProvider.matches(base, pattern, matcher, sequence);
        if (result2 != null) {
            collect.consume((Object)result2);
            return true;
        }
        return false;
    }

    private static class PathProximityComparator
    implements Comparator<Object> {
        @NotNull
        private final PsiProximityComparator myProximityComparator;

        private PathProximityComparator(@Nullable PsiElement context2) {
            this.myProximityComparator = new PsiProximityComparator(context2);
        }

        private static boolean isCompiledWithoutSource(Object o2) {
            return o2 instanceof PsiCompiledElement && ((PsiCompiledElement)o2).getNavigationElement() == o2;
        }

        @Override
        public int compare(Object o1, Object o2) {
            int rc = this.myProximityComparator.compare(o1, o2);
            if (rc != 0) {
                return rc;
            }
            int o1Weight = PathProximityComparator.isCompiledWithoutSource(o1) ? 1 : 0;
            int o2Weight = PathProximityComparator.isCompiledWithoutSource(o2) ? 1 : 0;
            return o1Weight - o2Weight;
        }
    }
}

