/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ApplyIntentionAction;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.LightColors;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.OnOffButton;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoActionModel
implements ChooseByNameModel,
Comparator<Object>,
DumbAware {
    private static final Pattern INNER_GROUP_WITH_IDS = Pattern.compile("(.*) \\(\\d+\\)");
    @Nullable
    private final Project myProject;
    private final Component myContextComponent;
    @Nullable
    private final Editor myEditor;
    @Nullable
    private final PsiFile myFile;
    protected final ActionManager myActionManager = ActionManager.getInstance();
    private static final Icon EMPTY_ICON = EmptyIcon.ICON_18;
    protected final Map<AnAction, String> myActionGroups = ContainerUtil.newHashMap();
    private final NotNullLazyValue<Map<String, String>> myConfigurablesNames = VolatileNotNullLazyValue.createValue(() -> {
        THashMap map2 = ContainerUtil.newTroveMap();
        for (Configurable configurable : ShowSettingsUtilImpl.getConfigurables(this.getProject(), true)) {
            if (!(configurable instanceof SearchableConfigurable)) continue;
            map2.put(((SearchableConfigurable)configurable).getId(), configurable.getDisplayName());
        }
        return map2;
    });
    private final ModalityState myModality;

    public GotoActionModel(@Nullable Project project2, Component component, @Nullable Editor editor, @Nullable PsiFile file2) {
        this(project2, component, editor, file2, ModalityState.defaultModalityState());
    }

    public GotoActionModel(@Nullable Project project2, Component component, @Nullable Editor editor, @Nullable PsiFile file2, @Nullable ModalityState modalityState) {
        this.myProject = project2;
        this.myContextComponent = component;
        this.myEditor = editor;
        this.myFile = file2;
        this.myModality = modalityState;
        ActionGroup mainMenu = (ActionGroup)this.myActionManager.getActionOrStub("MainMenu");
        this.collectActions(this.myActionGroups, mainMenu, mainMenu.getTemplatePresentation().getText());
    }

    @NotNull
    Map<String, ApplyIntentionAction> getAvailableIntentions() {
        ApplyIntentionAction[] children2;
        TreeMap<String, ApplyIntentionAction> map2 = new TreeMap<String, ApplyIntentionAction>();
        if (this.myProject != null && this.myEditor != null && this.myFile != null && (children2 = ApplyIntentionAction.getAvailableIntentions(this.myEditor, this.myFile)) != null) {
            for (ApplyIntentionAction action2 : children2) {
                map2.put(action2.getName(), action2);
            }
        }
        TreeMap<String, ApplyIntentionAction> treeMap = map2;
        if (treeMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel", "getAvailableIntentions"));
        }
        return treeMap;
    }

    public String getPromptText() {
        return IdeBundle.message((String)"prompt.gotoaction.enter.action", (Object[])new Object[0]);
    }

    @Nullable
    public String getCheckBoxName() {
        return null;
    }

    public char getCheckBoxMnemonic() {
        return 'd';
    }

    public String getNotInMessage() {
        return IdeBundle.message((String)"label.no.menu.actions.found", (Object[])new Object[0]);
    }

    public String getNotFoundMessage() {
        return IdeBundle.message((String)"label.no.actions.found", (Object[])new Object[0]);
    }

    public boolean loadInitialCheckBoxState() {
        return true;
    }

    public void saveInitialCheckBoxState(boolean state) {
    }

    public ListCellRenderer getListCellRenderer() {
        return new GotoActionListCellRenderer((Function<OptionDescription, String>)((Function)this::getGroupName));
    }

    protected String getActionId(@NotNull AnAction anAction) {
        if (anAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anAction", "com/intellij/ide/util/gotoByName/GotoActionModel", "getActionId"));
        }
        return this.myActionManager.getId(anAction);
    }

    @NotNull
    private static JLabel createIconLabel(@Nullable Icon icon) {
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(EMPTY_ICON, 0);
        if (icon != null && icon.getIconWidth() <= EMPTY_ICON.getIconWidth() && icon.getIconHeight() <= EMPTY_ICON.getIconHeight()) {
            layeredIcon.setIcon(icon, 1, (-icon.getIconWidth() + EMPTY_ICON.getIconWidth()) / 2, (EMPTY_ICON.getIconHeight() - icon.getIconHeight()) / 2);
        }
        JLabel jLabel = new JLabel((Icon)layeredIcon);
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel", "createIconLabel"));
        }
        return jLabel;
    }

    @Override
    public int compare(@NotNull Object o1, @NotNull Object o2) {
        if (o1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/ide/util/gotoByName/GotoActionModel", "compare"));
        }
        if (o2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/ide/util/gotoByName/GotoActionModel", "compare"));
        }
        if ("...".equals(o1)) {
            return 1;
        }
        if ("...".equals(o2)) {
            return -1;
        }
        return ((MatchedValue)o1).compareTo((MatchedValue)o2);
    }

    @NotNull
    public static AnActionEvent updateActionBeforeShow(@NotNull AnAction anAction, @NotNull DataContext dataContext) {
        if (anAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anAction", "com/intellij/ide/util/gotoByName/GotoActionModel", "updateActionBeforeShow"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/util/gotoByName/GotoActionModel", "updateActionBeforeShow"));
        }
        AnActionEvent event = AnActionEvent.createFromDataContext((String)"GoToAction", null, (DataContext)dataContext);
        ActionUtil.performDumbAwareUpdate((AnAction)anAction, (AnActionEvent)event, (boolean)false);
        AnActionEvent anActionEvent = event;
        if (anActionEvent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel", "updateActionBeforeShow"));
        }
        return anActionEvent;
    }

    public static Color defaultActionForeground(boolean isSelected, @Nullable Presentation presentation) {
        if (isSelected) {
            return UIUtil.getListSelectionForeground();
        }
        if (!(presentation == null || presentation.isEnabled() && presentation.isVisible())) {
            return UIUtil.getInactiveTextColor();
        }
        return UIUtil.getListForeground();
    }

    @NotNull
    public String[] getNames(boolean checkBoxState) {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel", "getNames"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public Object[] getElementsByName(String id, boolean checkBoxState, String pattern) {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel", "getElementsByName"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    public String getGroupName(@NotNull OptionDescription description) {
        String settings;
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/ide/util/gotoByName/GotoActionModel", "getGroupName"));
        }
        String id = description.getConfigurableId();
        String name = (String)((Map)this.myConfigurablesNames.getValue()).get(id);
        String string2 = settings = SystemInfo.isMac ? "Preferences" : "Settings";
        if (name == null) {
            String string3 = settings;
            if (string3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel", "getGroupName"));
            }
            return string3;
        }
        String string4 = settings + " > " + name;
        if (string4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel", "getGroupName"));
        }
        return string4;
    }

    void initConfigurables() {
        this.myConfigurablesNames.getValue();
    }

    private void collectActions(@NotNull Map<AnAction, String> result2, @NotNull ActionGroup group, @Nullable String containingGroupName) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/util/gotoByName/GotoActionModel", "collectActions"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/ide/util/gotoByName/GotoActionModel", "collectActions"));
        }
        AnAction[] actions2 = group.getChildren(null);
        this.includeGroup(result2, group, actions2, containingGroupName);
        for (AnAction action2 : actions2) {
            if (action2 == null || action2 instanceof Separator) continue;
            if (action2 instanceof ActionGroup) {
                ActionGroup actionGroup;
                String groupName = (actionGroup = (ActionGroup)action2).getTemplatePresentation().getText();
                this.collectActions(result2, actionGroup, GotoActionModel.getGroupName(StringUtil.isEmpty((String)groupName) || !actionGroup.isPopup() ? containingGroupName : groupName));
                continue;
            }
            String groupName = group.getTemplatePresentation().getText();
            if (result2.containsKey(action2)) {
                result2.put(action2, null);
                continue;
            }
            result2.put(action2, GotoActionModel.getGroupName(StringUtil.isEmpty((String)groupName) ? containingGroupName : groupName));
        }
    }

    @Nullable
    private static String getGroupName(@Nullable String groupName) {
        Matcher matcher;
        if (groupName != null && (matcher = INNER_GROUP_WITH_IDS.matcher(groupName)).matches()) {
            return matcher.group(1);
        }
        return groupName;
    }

    private void includeGroup(@NotNull Map<AnAction, String> result2, @NotNull ActionGroup group, @NotNull AnAction[] actions2, @Nullable String containingGroupName) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/util/gotoByName/GotoActionModel", "includeGroup"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/ide/util/gotoByName/GotoActionModel", "includeGroup"));
        }
        if (actions2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/ide/util/gotoByName/GotoActionModel", "includeGroup"));
        }
        boolean showGroup = true;
        for (AnAction action2 : actions2) {
            if (this.myActionManager.getId(action2) == null) continue;
            showGroup = false;
            break;
        }
        if (showGroup) {
            result2.put((AnAction)group, GotoActionModel.getGroupName(containingGroupName));
        }
    }

    @Nullable
    public String getFullName(@NotNull Object element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/util/gotoByName/GotoActionModel", "getFullName"));
        }
        return this.getElementName(element);
    }

    @NonNls
    public String getHelpId() {
        return "procedures.navigating.goto.action";
    }

    @NotNull
    public String[] getSeparators() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel", "getSeparators"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Nullable
    public String getElementName(@NotNull Object mv) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "com/intellij/ide/util/gotoByName/GotoActionModel", "getElementName"));
        }
        return ((MatchedValue)mv).getValueText();
    }

    protected MatchMode actionMatches(@NotNull String pattern, MinusculeMatcher matcher, @NotNull AnAction anAction) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/GotoActionModel", "actionMatches"));
        }
        if (anAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anAction", "com/intellij/ide/util/gotoByName/GotoActionModel", "actionMatches"));
        }
        Presentation presentation = anAction.getTemplatePresentation();
        String text2 = presentation.getText();
        String description = presentation.getDescription();
        String groupName = this.myActionGroups.get(anAction);
        if (text2 != null && matcher.matches(text2)) {
            return MatchMode.NAME;
        }
        if (description != null && !description.equals(text2) && matcher.matches(description)) {
            return MatchMode.DESCRIPTION;
        }
        if (text2 == null) {
            return MatchMode.NONE;
        }
        if (matcher.matches(groupName + " " + text2)) {
            return anAction instanceof ToggleAction ? MatchMode.NAME : MatchMode.GROUP;
        }
        return matcher.matches(text2 + " " + groupName) ? MatchMode.GROUP : MatchMode.NONE;
    }

    @Nullable
    protected Project getProject() {
        return this.myProject;
    }

    protected Component getContextComponent() {
        return this.myContextComponent;
    }

    @NotNull
    public SortedSet<Object> sortItems(@NotNull Set<Object> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/util/gotoByName/GotoActionModel", "sortItems"));
        }
        List<ActionWrapper> toUpdate = GotoActionModel.getActionsToUpdate(elements);
        if (!toUpdate.isEmpty()) {
            this.updateActions(toUpdate);
        }
        TreeSet objects = ContainerUtilRt.newTreeSet((Comparator)this);
        objects.addAll(elements);
        TreeSet treeSet = objects;
        if (treeSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel", "sortItems"));
        }
        return treeSet;
    }

    @NotNull
    private static List<ActionWrapper> getActionsToUpdate(@NotNull Set<Object> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/util/gotoByName/GotoActionModel", "getActionsToUpdate"));
        }
        ArrayList<ActionWrapper> toUpdate = new ArrayList<ActionWrapper>();
        for (Object element : elements) {
            Comparable value2;
            if (!(element instanceof MatchedValue) || !((value2 = ((MatchedValue)element).value) instanceof ActionWrapper) || ((ActionWrapper)value2).hasPresentation()) continue;
            toUpdate.add((ActionWrapper)value2);
        }
        ArrayList<ActionWrapper> arrayList = toUpdate;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel", "getActionsToUpdate"));
        }
        return arrayList;
    }

    private void updateActions(List<ActionWrapper> toUpdate) {
        TransferToEDTQueue<ActionWrapper> queue2 = new TransferToEDTQueue<ActionWrapper>("goto action", aw -> {
            aw.getPresentation();
            return true;
        }, Conditions.FALSE, 50){

            protected void schedule(@NotNull Runnable updateRunnable) {
                if (updateRunnable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateRunnable", "com/intellij/ide/util/gotoByName/GotoActionModel$1", "schedule"));
                }
                ApplicationManager.getApplication().invokeLater(updateRunnable, GotoActionModel.this.myModality);
            }
        };
        for (ActionWrapper wrapper : toUpdate) {
            queue2.offer((Object)wrapper);
        }
        while (queue2.size() > 0) {
            ProgressManager.checkCanceled();
            TimeoutUtil.sleep((long)50L);
        }
    }

    public boolean willOpenEditor() {
        return false;
    }

    public boolean useMiddleMatching() {
        return true;
    }

    public static class GotoActionListCellRenderer
    extends DefaultListCellRenderer {
        private final Function<OptionDescription, String> myGroupNamer;

        public GotoActionListCellRenderer(Function<OptionDescription, String> groupNamer) {
            this.myGroupNamer = groupNamer;
        }

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList list2, Object matchedValue, int index, boolean isSelected, boolean cellHasFocus) {
            if (list2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/util/gotoByName/GotoActionModel$GotoActionListCellRenderer", "getListCellRendererComponent"));
            }
            boolean showIcon = UISettings.getInstance().getShowIconsInMenus();
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setBorder(IdeBorderFactory.createEmptyBorder((int)2));
            panel2.setOpaque(true);
            Color bg = UIUtil.getListBackground((boolean)isSelected);
            panel2.setBackground(bg);
            SimpleColoredComponent nameComponent = new SimpleColoredComponent();
            nameComponent.setBackground(bg);
            panel2.add((Component)nameComponent, "Center");
            if (matchedValue instanceof String) {
                nameComponent.append((String)matchedValue, new SimpleTextAttributes(0, GotoActionModel.defaultActionForeground(isSelected, null)));
                if (showIcon) {
                    panel2.add((Component)new JBLabel(EMPTY_ICON), "West");
                }
                JPanel jPanel = panel2;
                if (jPanel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel$GotoActionListCellRenderer", "getListCellRendererComponent"));
                }
                return jPanel;
            }
            Color groupFg = isSelected ? UIUtil.getListSelectionForeground() : UIUtil.getLabelDisabledForeground();
            Comparable value2 = ((MatchedValue)matchedValue).value;
            String pattern = ((MatchedValue)matchedValue).pattern;
            Border eastBorder = IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)2);
            if (value2 instanceof ActionWrapper) {
                ActionWrapper actionWithParentGroup = (ActionWrapper)value2;
                AnAction anAction = actionWithParentGroup.getAction();
                Presentation presentation = anAction.getTemplatePresentation();
                boolean toggle = anAction instanceof ToggleAction;
                String groupName = actionWithParentGroup.getAction() instanceof ApplyIntentionAction ? null : actionWithParentGroup.getGroupName();
                Color fg = GotoActionModel.defaultActionForeground(isSelected, actionWithParentGroup.getPresentation());
                if (showIcon) {
                    panel2.add((Component)GotoActionModel.createIconLabel(presentation.getIcon()), "West");
                }
                GotoActionListCellRenderer.appendWithColoredMatches(nameComponent, GotoActionListCellRenderer.getName(presentation.getText(), groupName, toggle), pattern, fg, isSelected);
                panel2.setToolTipText(presentation.getDescription());
                Shortcut[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts(ActionManager.getInstance().getId(anAction));
                String shortcutText = KeymapUtil.getPreferredShortcutText((Shortcut[])shortcuts);
                if (StringUtil.isNotEmpty((String)shortcutText)) {
                    nameComponent.append(" " + shortcutText, new SimpleTextAttributes(129, UIUtil.isUnderDarcula() ? groupFg : ColorUtil.shift((Color)groupFg, (double)1.3)));
                }
                if (toggle) {
                    AnActionEvent event = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)((ActionWrapper)value2).myDataContext);
                    boolean selected = ((ToggleAction)anAction).isSelected(event);
                    GotoActionListCellRenderer.addOnOffButton(panel2, selected);
                } else if (groupName != null) {
                    JLabel groupLabel = new JLabel(groupName);
                    groupLabel.setBackground(bg);
                    groupLabel.setBorder(eastBorder);
                    groupLabel.setForeground(groupFg);
                    panel2.add((Component)groupLabel, "East");
                }
            } else if (value2 instanceof OptionDescription) {
                String hit;
                if (!isSelected && !(value2 instanceof BooleanOptionDescription)) {
                    Color descriptorBg = UIUtil.isUnderDarcula() ? ColorUtil.brighter((Color)UIUtil.getListBackground(), (int)1) : LightColors.SLIGHTLY_GRAY;
                    panel2.setBackground(descriptorBg);
                    nameComponent.setBackground(descriptorBg);
                }
                if ((hit = ((OptionDescription)value2).getHit()) == null) {
                    hit = ((OptionDescription)value2).getOption();
                }
                hit = StringUtil.unescapeXml((String)hit);
                String fullHit = hit = hit.replace("  ", " ");
                hit = StringUtil.first((String)hit, (int)45, (boolean)true);
                Color fg = UIUtil.getListForeground((boolean)isSelected);
                GotoActionListCellRenderer.appendWithColoredMatches(nameComponent, hit.trim(), pattern, fg, isSelected);
                if (showIcon) {
                    panel2.add((Component)new JLabel(EMPTY_ICON), "West");
                }
                panel2.setToolTipText(fullHit);
                if (value2 instanceof BooleanOptionDescription) {
                    boolean selected = ((BooleanOptionDescription)value2).isOptionEnabled();
                    GotoActionListCellRenderer.addOnOffButton(panel2, selected);
                } else {
                    JLabel settingsLabel = new JLabel((String)this.myGroupNamer.fun((Object)((OptionDescription)value2)));
                    settingsLabel.setForeground(groupFg);
                    settingsLabel.setBackground(bg);
                    settingsLabel.setBorder(eastBorder);
                    panel2.add((Component)settingsLabel, "East");
                }
            }
            JPanel jPanel = panel2;
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel$GotoActionListCellRenderer", "getListCellRendererComponent"));
            }
            return jPanel;
        }

        private static void addOnOffButton(@NotNull JPanel panel2, boolean selected) {
            if (panel2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/ide/util/gotoByName/GotoActionModel$GotoActionListCellRenderer", "addOnOffButton"));
            }
            OnOffButton button = new OnOffButton();
            button.setSelected(selected);
            panel2.add((Component)button, "East");
            panel2.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)2, (int)0, (int)2));
        }

        @NotNull
        private static String getName(@Nullable String text2, @Nullable String groupName, boolean toggle) {
            String string2 = toggle && StringUtil.isNotEmpty((String)groupName) ? (StringUtil.isNotEmpty((String)text2) ? groupName + ": " + text2 : groupName) : StringUtil.notNullize((String)text2);
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel$GotoActionListCellRenderer", "getName"));
            }
            return string2;
        }

        private static void appendWithColoredMatches(SimpleColoredComponent nameComponent, @NotNull String name, @NotNull String pattern, Color fg, boolean selected) {
            int matchStart;
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/util/gotoByName/GotoActionModel$GotoActionListCellRenderer", "appendWithColoredMatches"));
            }
            if (pattern == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/GotoActionModel$GotoActionListCellRenderer", "appendWithColoredMatches"));
            }
            SimpleTextAttributes plain = new SimpleTextAttributes(0, fg);
            SimpleTextAttributes highlighted = new SimpleTextAttributes(null, fg, null, 64);
            ArrayList fragments = ContainerUtil.newArrayList();
            if (selected && (matchStart = StringUtil.indexOfIgnoreCase((String)name, (String)pattern, (int)0)) >= 0) {
                fragments.add(TextRange.from((int)matchStart, (int)pattern.length()));
            }
            SpeedSearchUtil.appendColoredFragments((SimpleColoredComponent)nameComponent, (String)name, (Iterable)fragments, (SimpleTextAttributes)plain, (SimpleTextAttributes)highlighted);
        }
    }

    public static class ActionWrapper
    implements Comparable<ActionWrapper> {
        @NotNull
        private final AnAction myAction;
        @NotNull
        private final MatchMode myMode;
        @Nullable
        private final String myGroupName;
        private final DataContext myDataContext;
        private volatile Presentation myPresentation;

        public ActionWrapper(@NotNull AnAction action2, @Nullable String groupName, @NotNull MatchMode mode, DataContext dataContext) {
            if (action2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/ide/util/gotoByName/GotoActionModel$ActionWrapper", "<init>"));
            }
            if (mode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/ide/util/gotoByName/GotoActionModel$ActionWrapper", "<init>"));
            }
            this.myAction = action2;
            this.myMode = mode;
            this.myGroupName = groupName;
            this.myDataContext = dataContext;
        }

        @NotNull
        public AnAction getAction() {
            AnAction anAction = this.myAction;
            if (anAction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel$ActionWrapper", "getAction"));
            }
            return anAction;
        }

        @NotNull
        public MatchMode getMode() {
            MatchMode matchMode = this.myMode;
            if (matchMode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel$ActionWrapper", "getMode"));
            }
            return matchMode;
        }

        @Override
        public int compareTo(@NotNull ActionWrapper o2) {
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/ide/util/gotoByName/GotoActionModel$ActionWrapper", "compareTo"));
            }
            int compared = this.myMode.compareTo(o2.getMode());
            if (compared != 0) {
                return compared;
            }
            Presentation myPresentation = this.myAction.getTemplatePresentation();
            Presentation oPresentation = o2.getAction().getTemplatePresentation();
            String myText = myPresentation.getText();
            String oText = oPresentation.getText();
            int byText = StringUtil.compare((String)StringUtil.trimEnd((String)myText, (String)"..."), (String)StringUtil.trimEnd((String)oText, (String)"..."), (boolean)true);
            if (byText != 0) {
                return byText;
            }
            int byTextLength = StringUtil.notNullize((String)myText).length() - StringUtil.notNullize((String)oText).length();
            if (byTextLength != 0) {
                return byTextLength;
            }
            int byGroup = Comparing.compare((Comparable)((Object)this.myGroupName), (Comparable)((Object)o2.getGroupName()));
            if (byGroup != 0) {
                return byGroup;
            }
            int byDesc = StringUtil.compare((String)myPresentation.getDescription(), (String)oPresentation.getDescription(), (boolean)true);
            if (byDesc != 0) {
                return byDesc;
            }
            return 0;
        }

        public boolean isAvailable() {
            return this.getPresentation().isEnabledAndVisible();
        }

        public Presentation getPresentation() {
            if (this.myPresentation != null) {
                return this.myPresentation;
            }
            this.myPresentation = GotoActionModel.updateActionBeforeShow(this.myAction, this.myDataContext).getPresentation();
            return this.myPresentation;
        }

        private boolean hasPresentation() {
            return this.myPresentation != null;
        }

        @Nullable
        public String getGroupName() {
            if (this.myAction instanceof ActionGroup && Comparing.equal((String)this.myAction.getTemplatePresentation().getText(), (String)this.myGroupName)) {
                return null;
            }
            return this.myGroupName;
        }

        public boolean isGroupAction() {
            return this.myAction instanceof ActionGroup;
        }

        public boolean equals(Object obj) {
            return obj instanceof ActionWrapper && this.compareTo((ActionWrapper)obj) == 0;
        }

        public int hashCode() {
            String text2 = this.myAction.getTemplatePresentation().getText();
            return text2 != null ? text2.hashCode() : 0;
        }

        public String toString() {
            return this.myAction.toString();
        }
    }

    public static enum MatchMode {
        NONE,
        INTENTION,
        NAME,
        DESCRIPTION,
        GROUP,
        NON_MENU;

    }

    public static class MatchedValue
    implements Comparable<MatchedValue> {
        @NotNull
        public final Comparable value;
        @NotNull
        final String pattern;

        public MatchedValue(@NotNull Comparable value2, @NotNull String pattern) {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ide/util/gotoByName/GotoActionModel$MatchedValue", "<init>"));
            }
            if (pattern == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/GotoActionModel$MatchedValue", "<init>"));
            }
            this.value = value2;
            this.pattern = pattern;
        }

        @Nullable
        @VisibleForTesting
        public String getValueText() {
            if (this.value instanceof OptionDescription) {
                return ((OptionDescription)this.value).getHit();
            }
            if (!(this.value instanceof ActionWrapper)) {
                return null;
            }
            return ((ActionWrapper)this.value).getAction().getTemplatePresentation().getText();
        }

        @Nullable
        public String toString() {
            return this.getMatchingDegree() + " " + this.getValueText();
        }

        private int getMatchingDegree() {
            String text2 = this.getValueText();
            if (text2 != null) {
                int degree = this.getRank(text2);
                return this.value instanceof ActionWrapper && !((ActionWrapper)this.value).isGroupAction() ? degree + 1 : degree;
            }
            return 0;
        }

        private int getRank(@NotNull String text2) {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/util/gotoByName/GotoActionModel$MatchedValue", "getRank"));
            }
            if (StringUtil.equalsIgnoreCase((CharSequence)StringUtil.trimEnd((String)text2, (String)"..."), (CharSequence)this.pattern)) {
                return 3;
            }
            if (StringUtil.startsWithIgnoreCase((String)text2, (String)this.pattern)) {
                return 2;
            }
            if (StringUtil.containsIgnoreCase((String)text2, (String)this.pattern)) {
                return 1;
            }
            return 0;
        }

        @Override
        public int compareTo(@NotNull MatchedValue o2) {
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/ide/util/gotoByName/GotoActionModel$MatchedValue", "compareTo"));
            }
            int diff = o2.getMatchingDegree() - this.getMatchingDegree();
            if (diff != 0) {
                return diff;
            }
            boolean edt = ApplicationManager.getApplication().isDispatchThread();
            if (this.value instanceof ActionWrapper && o2.value instanceof ActionWrapper) {
                int compared;
                if (edt) {
                    boolean p1Enable = ((ActionWrapper)this.value).isAvailable();
                    boolean p2enable = ((ActionWrapper)o2.value).isAvailable();
                    if (p1Enable && !p2enable) {
                        return -1;
                    }
                    if (!p1Enable && p2enable) {
                        return 1;
                    }
                }
                if ((compared = this.value.compareTo(o2.value)) != 0) {
                    return compared;
                }
            }
            if (this.value instanceof ActionWrapper && o2.value instanceof BooleanOptionDescription) {
                return edt && ((ActionWrapper)this.value).isAvailable() ? -1 : 1;
            }
            if (o2.value instanceof ActionWrapper && this.value instanceof BooleanOptionDescription) {
                return edt && ((ActionWrapper)o2.value).isAvailable() ? 1 : -1;
            }
            if (this.value instanceof OptionDescription && o2.value instanceof BooleanOptionDescription) {
                return 1;
            }
            if (o2.value instanceof OptionDescription && this.value instanceof BooleanOptionDescription) {
                return -1;
            }
            if (this.value instanceof OptionDescription && !(o2.value instanceof OptionDescription)) {
                return 1;
            }
            if (o2.value instanceof OptionDescription && !(this.value instanceof OptionDescription)) {
                return -1;
            }
            diff = StringUtil.notNullize((String)this.getValueText()).length() - StringUtil.notNullize((String)o2.getValueText()).length();
            if (diff != 0) {
                return diff;
            }
            diff = this.value.compareTo(o2.value);
            if (diff != 0) {
                return diff;
            }
            return o2.hashCode() - this.hashCode();
        }
    }
}

