/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.lang.Language;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.ChooseByNameRegistry;
import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoClassModel2
extends FilteringGotoByModel<Language> {
    private String[] mySeparators;

    public GotoClassModel2(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/gotoByName/GotoClassModel2", "<init>"));
        }
        super(project2, ChooseByNameRegistry.getInstance().getClassModelContributors());
    }

    @Override
    protected Language filterValueFor(NavigationItem item) {
        return item instanceof PsiElement ? ((PsiElement)item).getLanguage() : null;
    }

    @Override
    protected synchronized Collection<Language> getFilterItems() {
        Collection result2 = super.getFilterItems();
        if (result2 == null) {
            return null;
        }
        HashSet<Language> items2 = new HashSet<Language>(result2);
        items2.add(Language.ANY);
        return items2;
    }

    @Nullable
    public String getPromptText() {
        return IdeBundle.message((String)"prompt.gotoclass.enter.class.name", (Object[])new Object[0]);
    }

    public String getCheckBoxName() {
        return IdeBundle.message((String)"checkbox.include.non.project.classes", (Object[])new Object[0]);
    }

    public String getNotInMessage() {
        return IdeBundle.message((String)"label.no.matches.found.in.project", (Object[])new Object[0]);
    }

    public String getNotFoundMessage() {
        return IdeBundle.message((String)"label.no.matches.found", (Object[])new Object[0]);
    }

    public char getCheckBoxMnemonic() {
        return SystemInfo.isMac ? (char)'P' : 'n';
    }

    public boolean loadInitialCheckBoxState() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        return Boolean.TRUE.toString().equals(propertiesComponent.getValue("GoToClass.toSaveIncludeLibraries")) && Boolean.TRUE.toString().equals(propertiesComponent.getValue("GoToClass.includeLibraries"));
    }

    public void saveInitialCheckBoxState(boolean state) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        if (Boolean.TRUE.toString().equals(propertiesComponent.getValue("GoToClass.toSaveIncludeLibraries"))) {
            propertiesComponent.setValue("GoToClass.includeLibraries", Boolean.toString(state));
        }
    }

    public String getFullName(Object element) {
        if (element instanceof PsiElement && !((PsiElement)element).isValid()) {
            return null;
        }
        for (ChooseByNameContributor c2 : this.getContributors()) {
            String result2;
            if (!(c2 instanceof GotoClassContributor) || (result2 = ((GotoClassContributor)c2).getQualifiedName((NavigationItem)element)) == null) continue;
            return result2;
        }
        return this.getElementName(element);
    }

    @NotNull
    public String[] getSeparators() {
        if (this.mySeparators == null) {
            this.mySeparators = GotoClassModel2.getSeparatorsFromContributors(this.getContributors());
        }
        if (this.mySeparators == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoClassModel2", "getSeparators"));
        }
        return this.mySeparators;
    }

    public static String[] getSeparatorsFromContributors(ChooseByNameContributor[] contributors) {
        HashSet<String> separators = new HashSet<String>();
        separators.add(".");
        for (ChooseByNameContributor c2 : contributors) {
            if (!(c2 instanceof GotoClassContributor)) continue;
            ContainerUtil.addIfNotNull(separators, (Object)((GotoClassContributor)c2).getQualifiedNameSeparator());
        }
        return ArrayUtil.toStringArray(separators);
    }

    @Override
    public String getHelpId() {
        return "procedures.navigating.goto.class";
    }

    @Override
    @NotNull
    public String removeModelSpecificMarkup(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/GotoClassModel2", "removeModelSpecificMarkup"));
        }
        if (pattern.startsWith("@")) {
            String string2 = pattern.substring(1);
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoClassModel2", "removeModelSpecificMarkup"));
            }
            return string2;
        }
        String string3 = pattern;
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoClassModel2", "removeModelSpecificMarkup"));
        }
        return string3;
    }

    public boolean willOpenEditor() {
        return true;
    }

    @Override
    public boolean sameNamesForProjectAndLibraries() {
        return !FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping;
    }
}

