/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.NonProjectScopeDisablerEP;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoFileModel
extends FilteringGotoByModel<FileType>
implements DumbAware {
    private final int myMaxSize;

    public GotoFileModel(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/gotoByName/GotoFileModel", "<init>"));
        }
        super(project2, (ChooseByNameContributor[])Extensions.getExtensions((ExtensionPointName)ChooseByNameContributor.FILE_EP_NAME));
        this.myMaxSize = ApplicationManager.getApplication().isUnitTestMode() ? Integer.MAX_VALUE : WindowManagerEx.getInstanceEx().getFrame((Project)project2).getSize().width;
    }

    @Override
    protected boolean acceptItem(NavigationItem item) {
        if (item instanceof PsiFile) {
            PsiFile file2 = (PsiFile)item;
            Collection types = this.getFilterItems();
            if (types != null) {
                if (types.contains(file2.getFileType())) {
                    return true;
                }
                VirtualFile vFile = file2.getVirtualFile();
                return vFile != null && types.contains(vFile.getFileType());
            }
            return true;
        }
        return super.acceptItem(item);
    }

    @Override
    @Nullable
    protected FileType filterValueFor(NavigationItem item) {
        return item instanceof PsiFile ? ((PsiFile)item).getFileType() : null;
    }

    public String getPromptText() {
        return IdeBundle.message((String)"prompt.gotofile.enter.file.name", (Object[])new Object[0]);
    }

    public String getCheckBoxName() {
        if (NonProjectScopeDisablerEP.isSearchInNonProjectDisabled()) {
            return null;
        }
        return IdeBundle.message((String)"checkbox.include.non.project.files", (Object[])new Object[0]);
    }

    public char getCheckBoxMnemonic() {
        return SystemInfo.isMac ? (char)'P' : 'n';
    }

    public String getNotInMessage() {
        return IdeBundle.message((String)"label.no.non.java.files.found", (Object[])new Object[0]);
    }

    public String getNotFoundMessage() {
        return IdeBundle.message((String)"label.no.files.found", (Object[])new Object[0]);
    }

    public boolean loadInitialCheckBoxState() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        return propertiesComponent.isTrueValue("GoToClass.toSaveIncludeLibraries") && propertiesComponent.isTrueValue("GoToFile.includeJavaFiles");
    }

    public void saveInitialCheckBoxState(boolean state) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        if (propertiesComponent.isTrueValue("GoToClass.toSaveIncludeLibraries")) {
            propertiesComponent.setValue("GoToFile.includeJavaFiles", Boolean.toString(state));
        }
    }

    @Override
    public PsiElementListCellRenderer getListCellRenderer() {
        return new GotoFileCellRenderer(this.myMaxSize);
    }

    @Override
    public boolean sameNamesForProjectAndLibraries() {
        return !FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping;
    }

    @Nullable
    public String getFullName(Object element) {
        if (element instanceof PsiFileSystemItem) {
            VirtualFile file2 = ((PsiFileSystemItem)element).getVirtualFile();
            VirtualFile root = this.getTopLevelRoot(file2);
            return root != null ? GotoFileCellRenderer.getRelativePathFromRoot(file2, root) : GotoFileCellRenderer.getRelativePath(file2, this.myProject);
        }
        return this.getElementName(element);
    }

    private VirtualFile getTopLevelRoot(VirtualFile file2) {
        return (VirtualFile)JBIterable.generate((Object)this.getContentRoot(file2), r2 -> this.getContentRoot(r2.getParent())).last();
    }

    private VirtualFile getContentRoot(@Nullable VirtualFile file2) {
        return file2 == null ? null : ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).getContentRootForFile(file2);
    }

    @NotNull
    public String[] getSeparators() {
        String[] stringArray = new String[]{"/", "\\"};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoFileModel", "getSeparators"));
        }
        return stringArray;
    }

    @Override
    public String getHelpId() {
        return "procedures.navigating.goto.class";
    }

    public boolean willOpenEditor() {
        return true;
    }

    @Override
    @NotNull
    public String removeModelSpecificMarkup(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/GotoFileModel", "removeModelSpecificMarkup"));
        }
        if (pattern.endsWith("/") || pattern.endsWith("\\")) {
            String string2 = pattern.substring(0, pattern.length() - 1);
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoFileModel", "removeModelSpecificMarkup"));
            }
            return string2;
        }
        String string3 = pattern;
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoFileModel", "removeModelSpecificMarkup"));
        }
        return string3;
    }
}

