/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.CommonBundle;
import com.intellij.application.options.PathMacrosCollector;
import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectMacrosUtil;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public class ExistingModuleLoader
extends ModuleBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.projectWizard.ExistingModuleLoader");

    public static ExistingModuleLoader setUpLoader(String moduleFilePath) {
        ExistingModuleLoader moduleLoader = new ExistingModuleLoader();
        moduleLoader.setModuleFilePath(moduleFilePath);
        int startIndex = moduleFilePath.lastIndexOf(47);
        int endIndex = moduleFilePath.lastIndexOf(".");
        if (startIndex >= 0 && endIndex > startIndex + 1) {
            String name = moduleFilePath.substring(startIndex + 1, endIndex);
            moduleLoader.setName(name);
        }
        return moduleLoader;
    }

    @NotNull
    public Module createModule(@NotNull ModifiableModuleModel moduleModel) throws InvalidDataException, IOException, ModuleWithNameAlreadyExists, JDOMException, ConfigurationException {
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/intellij/ide/util/projectWizard/ExistingModuleLoader", "createModule"));
        }
        LOG.assertTrue(this.getName() != null);
        String moduleFilePath = this.getModuleFilePath();
        LOG.assertTrue(moduleFilePath != null);
        LOG.assertTrue(new File(moduleFilePath).exists());
        Module module2 = moduleModel.loadModule(moduleFilePath);
        if (module2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/ExistingModuleLoader", "createModule"));
        }
        return module2;
    }

    public void setupRootModel(ModifiableRootModel modifiableRootModel) throws ConfigurationException {
    }

    public ModuleType getModuleType() {
        return null;
    }

    public boolean validate(Project current, Project dest) {
        block7: {
            if (this.getName() == null) {
                return false;
            }
            String moduleFilePath = this.getModuleFilePath();
            if (moduleFilePath == null) {
                return false;
            }
            File file2 = new File(moduleFilePath);
            if (file2.exists()) {
                try {
                    boolean ok;
                    ConversionResult result2 = ConversionService.getInstance().convertModule(dest, file2);
                    if (result2.openingIsCanceled()) {
                        return false;
                    }
                    Element root = JDOMUtil.load((File)file2);
                    Set<String> usedMacros = PathMacrosCollector.getMacroNames(root);
                    usedMacros.remove("$MODULE_DIR$");
                    usedMacros.removeAll(PathMacros.getInstance().getAllMacroNames());
                    if (usedMacros.size() > 0 && !(ok = ProjectMacrosUtil.showMacrosConfigurationDialog(current, usedMacros))) {
                        return false;
                    }
                    break block7;
                }
                catch (IOException | JDOMException e2) {
                    Messages.showMessageDialog((String)e2.getMessage(), (String)IdeBundle.message((String)"title.error.reading.file", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                    return false;
                }
            }
            Messages.showErrorDialog((Project)current, (String)IdeBundle.message((String)"title.module.file.does.not.exist", (Object[])new Object[]{moduleFilePath}), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

