/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.ide.DataManager;
import com.intellij.ide.util.scopeChooser.EditScopesDialog;
import com.intellij.ide.util.scopeChooser.IgnoringComboBox;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.ide.util.scopeChooser.ScopeDescriptorProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.packageDependencies.ChangeListsScopesProvider;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.ListCellRendererWrapper;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeChooserCombo
extends ComboboxWithBrowseButton
implements Disposable {
    private Project myProject;
    private boolean mySuggestSearchInLibs;
    private boolean myPrevSearchFiles;
    private NamedScopesHolder.ScopeListener myScopeListener;
    private NamedScopeManager myNamedScopeManager;
    private DependencyValidationManager myValidationManager;
    private boolean myCurrentSelection = true;
    private boolean myUsageView = true;
    private Condition<ScopeDescriptor> myScopeFilter;
    private boolean myShowEmptyScopes;
    private BrowseListener myBrowseListener = null;

    public ScopeChooserCombo() {
        super((JComboBox)new IgnoringComboBox(){

            @Override
            protected boolean isIgnored(Object item) {
                return item instanceof ScopeSeparator;
            }
        });
    }

    public ScopeChooserCombo(Project project2, boolean suggestSearchInLibs, boolean prevSearchWholeFiles, String preselect) {
        this();
        this.init(project2, suggestSearchInLibs, prevSearchWholeFiles, preselect);
    }

    public void init(Project project2, String preselect) {
        this.init(project2, false, true, preselect);
    }

    public void init(Project project2, boolean suggestSearchInLibs, boolean prevSearchWholeFiles, String preselect) {
        this.init(project2, suggestSearchInLibs, prevSearchWholeFiles, preselect, null);
    }

    public void init(Project project2, boolean suggestSearchInLibs, boolean prevSearchWholeFiles, String preselect, @Nullable Condition<ScopeDescriptor> scopeFilter) {
        this.mySuggestSearchInLibs = suggestSearchInLibs;
        this.myPrevSearchFiles = prevSearchWholeFiles;
        this.myProject = project2;
        this.myScopeListener = () -> {
            SearchScope selectedScope = this.getSelectedScope();
            this.rebuildModel();
            if (selectedScope != null) {
                this.selectScope(selectedScope.getDisplayName());
            }
        };
        this.myScopeFilter = scopeFilter;
        this.myNamedScopeManager = NamedScopeManager.getInstance((Project)project2);
        this.myNamedScopeManager.addScopeListener(this.myScopeListener);
        this.myValidationManager = DependencyValidationManager.getInstance((Project)project2);
        this.myValidationManager.addScopeListener(this.myScopeListener);
        this.addActionListener(this.createScopeChooserListener());
        JComboBox combo = this.getComboBox();
        combo.setRenderer(new ScopeDescriptionWithDelimiterRenderer());
        this.rebuildModel();
        this.selectScope(preselect);
        new ComboboxSpeedSearch(combo){

            @Override
            protected String getElementText(Object element) {
                if (element instanceof ScopeDescriptor) {
                    ScopeDescriptor descriptor2 = (ScopeDescriptor)element;
                    return descriptor2.getDisplay();
                }
                return null;
            }
        };
    }

    public void setBrowseListener(BrowseListener browseListener) {
        this.myBrowseListener = browseListener;
    }

    public void setCurrentSelection(boolean currentSelection) {
        this.myCurrentSelection = currentSelection;
    }

    public void setUsageView(boolean usageView2) {
        this.myUsageView = usageView2;
    }

    public void dispose() {
        super.dispose();
        if (this.myValidationManager != null) {
            this.myValidationManager.removeScopeListener(this.myScopeListener);
            this.myValidationManager = null;
        }
        if (this.myNamedScopeManager != null) {
            this.myNamedScopeManager.removeScopeListener(this.myScopeListener);
            this.myNamedScopeManager = null;
        }
        this.myScopeListener = null;
    }

    private void selectScope(String preselect) {
        if (preselect != null) {
            JComboBox combo = this.getComboBox();
            DefaultComboBoxModel model2 = (DefaultComboBoxModel)combo.getModel();
            for (int i2 = 0; i2 < model2.getSize(); ++i2) {
                ScopeDescriptor descriptor2 = (ScopeDescriptor)model2.getElementAt(i2);
                if (!preselect.equals(descriptor2.getDisplay())) continue;
                combo.setSelectedIndex(i2);
                break;
            }
        }
    }

    private ActionListener createScopeChooserListener() {
        return e2 -> {
            EditScopesDialog dlg;
            String selection = this.getSelectedScopeName();
            if (this.myBrowseListener != null) {
                this.myBrowseListener.onBeforeBrowseStarted();
            }
            if ((dlg = EditScopesDialog.showDialog(this.myProject, selection)).isOK()) {
                this.rebuildModel();
                NamedScope namedScope = dlg.getSelectedScope();
                if (namedScope != null) {
                    this.selectScope(namedScope.getName());
                }
            }
            if (this.myBrowseListener != null) {
                this.myBrowseListener.onAfterBrowseFinished();
            }
        };
    }

    private void rebuildModel() {
        this.getComboBox().setModel(this.createModel());
    }

    @NotNull
    private DefaultComboBoxModel<ScopeDescriptor> createModel() {
        DefaultComboBoxModel<ScopeDescriptor> model2 = new DefaultComboBoxModel<ScopeDescriptor>();
        this.createPredefinedScopeDescriptors(model2);
        List changeLists = ChangeListsScopesProvider.getInstance(this.myProject).getFilteredScopes();
        if (!changeLists.isEmpty()) {
            model2.addElement(new ScopeSeparator("VCS Scopes"));
            for (NamedScope changeListScope : changeLists) {
                GlobalSearchScope scope = GlobalSearchScopesCore.filterScope((Project)this.myProject, (NamedScope)changeListScope);
                this.addScopeDescriptor(model2, new ScopeDescriptor((SearchScope)scope));
            }
        }
        ArrayList<ScopeDescriptor> customScopes = new ArrayList<ScopeDescriptor>();
        NamedScopesHolder[] holders = NamedScopesHolder.getAllNamedScopeHolders((Project)this.myProject);
        for (NamedScopesHolder holder : holders) {
            NamedScope[] scopes;
            for (NamedScope scope : scopes = holder.getEditableScopes()) {
                GlobalSearchScope searchScope = GlobalSearchScopesCore.filterScope((Project)this.myProject, (NamedScope)scope);
                customScopes.add(new ScopeDescriptor((SearchScope)searchScope));
            }
        }
        if (!customScopes.isEmpty()) {
            model2.addElement(new ScopeSeparator("Custom Scopes"));
            for (ScopeDescriptor scope : customScopes) {
                this.addScopeDescriptor(model2, scope);
            }
        }
        DefaultComboBoxModel<ScopeDescriptor> defaultComboBoxModel = model2;
        if (defaultComboBoxModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/scopeChooser/ScopeChooserCombo", "createModel"));
        }
        return defaultComboBoxModel;
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension preferredSize = super.getPreferredSize();
        return new Dimension(Math.min(400, preferredSize.width), preferredSize.height);
    }

    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        Dimension minimumSize = super.getMinimumSize();
        return new Dimension(Math.min(200, minimumSize.width), minimumSize.height);
    }

    private void createPredefinedScopeDescriptors(@NotNull DefaultComboBoxModel<ScopeDescriptor> model2) {
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/util/scopeChooser/ScopeChooserCombo", "createPredefinedScopeDescriptors"));
        }
        DataContext context2 = DataManager.getInstance().getDataContext();
        for (SearchScope scope : PredefinedSearchScopeProvider.getInstance().getPredefinedScopes(this.myProject, context2, this.mySuggestSearchInLibs, this.myPrevSearchFiles, this.myCurrentSelection, this.myUsageView, this.myShowEmptyScopes)) {
            this.addScopeDescriptor(model2, new ScopeDescriptor(scope));
        }
        for (ScopeDescriptorProvider provider : (ScopeDescriptorProvider[])Extensions.getExtensions(ScopeDescriptorProvider.EP_NAME)) {
            for (ScopeDescriptor scopeDescriptor : provider.getScopeDescriptors(this.myProject)) {
                if (this.myScopeFilter != null && !this.myScopeFilter.value((Object)scopeDescriptor)) continue;
                model2.addElement(scopeDescriptor);
            }
        }
    }

    private void addScopeDescriptor(DefaultComboBoxModel<ScopeDescriptor> model2, ScopeDescriptor scopeDescriptor) {
        if (this.myScopeFilter == null || this.myScopeFilter.value((Object)scopeDescriptor)) {
            model2.addElement(scopeDescriptor);
        }
    }

    public void setShowEmptyScopes(boolean showEmptyScopes) {
        this.myShowEmptyScopes = showEmptyScopes;
    }

    @Nullable
    public SearchScope getSelectedScope() {
        JComboBox combo = this.getComboBox();
        int idx = combo.getSelectedIndex();
        return idx < 0 ? null : ((ScopeDescriptor)combo.getSelectedItem()).getScope();
    }

    @Nullable
    public String getSelectedScopeName() {
        JComboBox combo = this.getComboBox();
        int idx = combo.getSelectedIndex();
        return idx < 0 ? null : ((ScopeDescriptor)combo.getSelectedItem()).getDisplay();
    }

    public static interface BrowseListener {
        public void onBeforeBrowseStarted();

        public void onAfterBrowseFinished();
    }

    private static class ScopeDescriptionWithDelimiterRenderer
    extends ListCellRendererWrapper<ScopeDescriptor> {
        private ScopeDescriptionWithDelimiterRenderer() {
        }

        public void customize(JList list2, ScopeDescriptor value2, int index, boolean selected, boolean hasFocus) {
            this.setText(value2.getDisplay());
            if (value2 instanceof ScopeSeparator) {
                this.setSeparator();
            }
        }
    }

    private static class ScopeSeparator
    extends ScopeDescriptor {
        private final String myText;

        ScopeSeparator(@NotNull String text2) {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/util/scopeChooser/ScopeChooserCombo$ScopeSeparator", "<init>"));
            }
            super(null);
            this.myText = text2;
        }

        @Override
        public String getDisplay() {
            return this.myText;
        }
    }
}

