/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.SettingsProvider;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTreeStructureBase
extends AbstractTreeStructure {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.treeView.AbstractTreeStructureBase");
    protected final Project myProject;

    protected AbstractTreeStructureBase(Project project2) {
        this.myProject = project2;
    }

    public Object[] getChildElements(Object element) {
        LOG.assertTrue(element instanceof AbstractTreeNode, element != null ? element.getClass().getName() : null);
        AbstractTreeNode treeNode = (AbstractTreeNode)element;
        Collection elements = treeNode.getChildren();
        List<TreeStructureProvider> providers = this.getProvidersDumbAware();
        if (!providers.isEmpty()) {
            ViewSettings settings = treeNode instanceof SettingsProvider ? ((SettingsProvider)treeNode).getSettings() : ViewSettings.DEFAULT;
            for (TreeStructureProvider provider : providers) {
                try {
                    elements = provider.modify(treeNode, elements, settings);
                }
                catch (ProcessCanceledException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    LOG.error((Throwable)e3);
                }
            }
        }
        for (AbstractTreeNode node : elements) {
            node.setParent(treeNode);
        }
        return ArrayUtil.toObjectArray((Collection)elements);
    }

    public boolean isValid(Object element) {
        return element instanceof AbstractTreeNode;
    }

    public Object getParentElement(Object element) {
        if (element instanceof AbstractTreeNode) {
            return ((AbstractTreeNode)element).getParent();
        }
        return null;
    }

    @NotNull
    public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        NodeDescriptor nodeDescriptor = (NodeDescriptor)element;
        if (nodeDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeStructureBase", "createDescriptor"));
        }
        return nodeDescriptor;
    }

    public AsyncResult<Object> revalidateElement(Object element) {
        return super.revalidateElement(element);
    }

    @Nullable
    public abstract List<TreeStructureProvider> getProviders();

    @Nullable
    public Object getDataFromProviders(@NotNull List<AbstractTreeNode> selectedNodes, String dataId) {
        if (selectedNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedNodes", "com/intellij/ide/util/treeView/AbstractTreeStructureBase", "getDataFromProviders"));
        }
        List<TreeStructureProvider> providers = this.getProvidersDumbAware();
        if (!providers.isEmpty()) {
            for (TreeStructureProvider treeStructureProvider : providers) {
                Object fromProvider = treeStructureProvider.getData(selectedNodes, dataId);
                if (fromProvider == null) continue;
                return fromProvider;
            }
        }
        return null;
    }

    @NotNull
    private List<TreeStructureProvider> getProvidersDumbAware() {
        if (this.myProject == null) {
            List<TreeStructureProvider> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeStructureBase", "getProvidersDumbAware"));
            }
            return list2;
        }
        List<TreeStructureProvider> providers = this.getProviders();
        if (providers == null) {
            List<TreeStructureProvider> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeStructureBase", "getProvidersDumbAware"));
            }
            return list3;
        }
        List list4 = DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(providers);
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeStructureBase", "getProvidersDumbAware"));
        }
        return list4;
    }
}

