/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView.smartTree;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.smartTree.CachingChildrenTreeNode;
import com.intellij.ide.util.treeView.smartTree.TreeElementWrapper;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.NotNull;

public class SmartTreeStructure
extends AbstractTreeStructure {
    protected final TreeModel myModel;
    protected final Project myProject;
    private TreeElementWrapper myRootElementWrapper;

    public SmartTreeStructure(@NotNull Project project2, @NotNull TreeModel model2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/treeView/smartTree/SmartTreeStructure", "<init>"));
        }
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/util/treeView/smartTree/SmartTreeStructure", "<init>"));
        }
        this.myModel = model2;
        this.myProject = project2;
    }

    public void commit() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
    }

    @NotNull
    public ActionCallback asyncCommit() {
        ActionCallback actionCallback = SmartTreeStructure.asyncCommitDocuments((Project)this.myProject);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/smartTree/SmartTreeStructure", "asyncCommit"));
        }
        return actionCallback;
    }

    public boolean hasSomethingToCommit() {
        return PsiDocumentManager.getInstance((Project)this.myProject).hasUncommitedDocuments();
    }

    @NotNull
    public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        AbstractTreeNode abstractTreeNode = (AbstractTreeNode)element;
        if (abstractTreeNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/smartTree/SmartTreeStructure", "createDescriptor"));
        }
        return abstractTreeNode;
    }

    public Object[] getChildElements(Object element) {
        return ((AbstractTreeNode)element).getChildren().toArray();
    }

    public Object getParentElement(Object element) {
        return ((AbstractTreeNode)element).getParent();
    }

    public Object getRootElement() {
        if (this.myRootElementWrapper == null) {
            this.myRootElementWrapper = this.createTree();
        }
        return this.myRootElementWrapper;
    }

    protected TreeElementWrapper createTree() {
        return new TreeElementWrapper(this.myProject, this.myModel.getRoot(), this.myModel);
    }

    public boolean isAlwaysLeaf(Object element) {
        return ((AbstractTreeNode)element).isAlwaysLeaf();
    }

    public void rebuildTree() {
        ((CachingChildrenTreeNode)((Object)this.getRootElement())).rebuildChildren();
    }
}

