/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.ide.license.LicenseManager;
import com.intellij.ide.license.LicensingFacadeImpl;
import com.intellij.ide.license.appcode.AppCodeLicenseManager;
import com.intellij.ide.license.clion.CLionLicenseManager;
import com.intellij.ide.license.commandLine.RubyMineInspectionsToolLicense;
import com.intellij.ide.license.commandLine.TeamServerIdeaLicense;
import com.intellij.ide.license.dbe.DbeLicenseManager;
import com.intellij.ide.license.go.GoIdeEAPLicenseManager;
import com.intellij.ide.license.idea.IdeaEAPLicenseManager;
import com.intellij.ide.license.phpstorm.PhpStormLicenseManager;
import com.intellij.ide.license.pycharm.PyCharmLicenseManager;
import com.intellij.ide.license.rider.RiderEAPLicenseManager;
import com.intellij.ide.license.rider.RiderLicenseManager;
import com.intellij.ide.license.rubymine.RubyMineLicenseManager;
import com.intellij.ide.license.webstorm.WebStormLicenseManager;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.idea.IdeaApplication;
import com.intellij.idea.Main;
import com.intellij.idea.StartupUtil;
import com.intellij.idea.cloudConfig.CloudConfigProviderImpl;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.ui.LicensingFacade;
import com.intellij.util.PlatformUtils;
import javax.swing.SwingUtilities;

public class MainImpl {
    private static final String TC_PACKAGE = "TeamServer";
    private static final String INSPECTIONS_PACKAGE = "Inspections Tool";
    private static final String BETA_SUFFIX = "Beta";

    private MainImpl() {
    }

    protected static void start(final String[] args) {
        StartupUtil.prepareAndStart(args, new StartupUtil.AppStarter(){

            @Override
            public void beforeImportConfigs() {
                new CloudConfigProviderImpl();
            }

            @Override
            public void start(final boolean newConfigFolder) {
                MainImpl.setLicenseManager(args);
                LicenseManager.getInstance().startUp(new LicenseManager.StartupAction(){

                    @Override
                    public void proceed() {
                        PluginManager.installExceptionHandler();
                        if (newConfigFolder && !ConfigImportHelper.isConfigImported()) {
                            StartupUtil.runStartupWizard();
                        }
                        IdeaApplication app = new IdeaApplication(args);
                        SwingUtilities.invokeLater(() -> {
                            PluginManager.installExceptionHandler();
                            app.run();
                        });
                    }

                    @Override
                    public void cancel() {
                        System.exit(7);
                    }

                    @Override
                    public boolean cancelMeansShutdown() {
                        return true;
                    }
                });
            }
        });
    }

    private static void setLicenseManager(String[] args) {
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        if (TC_PACKAGE.equals(appInfo.getPackageCode())) {
            LicenseManager.setInstance(new TeamServerIdeaLicense());
        } else if (Main.isUITraverser((String[])args)) {
            LicenseManager.setInstance(new IdeaEAPLicenseManager());
        } else if (PlatformUtils.isRubyMine()) {
            if (INSPECTIONS_PACKAGE.equals(appInfo.getPackageCode())) {
                LicenseManager.setInstance(new RubyMineInspectionsToolLicense());
            } else {
                LicenseManager.setInstance(new RubyMineLicenseManager());
            }
        } else if (PlatformUtils.isWebStorm()) {
            LicenseManager.setInstance(new WebStormLicenseManager());
        } else if (PlatformUtils.isPhpStorm()) {
            LicenseManager.setInstance(new PhpStormLicenseManager());
        } else if (PlatformUtils.isPyCharm()) {
            LicenseManager.setInstance(new PyCharmLicenseManager());
        } else if (PlatformUtils.isAppCode()) {
            LicenseManager.setInstance(new AppCodeLicenseManager());
        } else if (PlatformUtils.isCLion()) {
            LicenseManager.setInstance(new CLionLicenseManager());
        } else if (PlatformUtils.isDatabaseIDE()) {
            LicenseManager.setInstance(new DbeLicenseManager());
        } else if (PlatformUtils.isRider()) {
            if (appInfo.isEAP() || MainImpl.isBeta(appInfo)) {
                LicenseManager.setInstance(new RiderEAPLicenseManager());
            } else {
                LicenseManager.setInstance(new RiderLicenseManager());
            }
        } else if (PlatformUtils.isGoIde() && (appInfo.isEAP() || MainImpl.isBeta(appInfo))) {
            LicenseManager.setInstance(new GoIdeEAPLicenseManager());
        }
        LicensingFacade.ourInstance = new LicensingFacadeImpl();
    }

    private static boolean isBeta(ApplicationInfoEx appInfo) {
        String version = appInfo.getMinorVersion();
        return version != null && version.contains(BETA_SUFFIX);
    }
}

