/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea.cloudConfig;

import com.intellij.ide.license.impl.JetprofileSource;
import com.intellij.idea.cloudConfig.ETagCloudConfigFileClient;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cloudconfig.Configuration;
import com.jetbrains.cloudconfig.auth.AuthProvider;
import com.jetbrains.cloudconfig.auth.JbaTokenAuthProvider;
import com.jetbrains.ls.util.RpcUtil;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudConfigClientUtil {
    public static final String CONFIG_URL = "https://config-storage.labs.intellij.net/files";
    private static final int TIMEOUT = 10000;
    public static final String INSTALLED_PLUGINS_FILENAME = "installed_plugins.txt";
    private static String myOsName;
    public static ETagCloudConfigFileClient testClient;

    @NotNull
    public static String getName() {
        String string2 = "/" + ApplicationNamesInfo.getInstance().getProductName() + "/";
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/cloudConfig/CloudConfigClientUtil", "getName"));
        }
        return string2;
    }

    @NotNull
    public static List<String> readPlugins(@NotNull String pluginList) {
        if (pluginList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginList", "com/intellij/idea/cloudConfig/CloudConfigClientUtil", "readPlugins"));
        }
        List plugins2 = StringUtil.split((String)pluginList, (String)"\n");
        ArrayList<String> result2 = new ArrayList<String>();
        int size = plugins2.size();
        for (int i2 = 0; i2 < size; i2 += 2) {
            result2.add((String)plugins2.get(i2));
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/cloudConfig/CloudConfigClientUtil", "readPlugins"));
        }
        return arrayList;
    }

    @NotNull
    public static String getOS() {
        if (myOsName == null) {
            myOsName = CloudConfigClientUtil.calcOS();
        }
        String string2 = myOsName;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/cloudConfig/CloudConfigClientUtil", "getOS"));
        }
        return string2;
    }

    @NotNull
    private static String calcOS() {
        if (SystemInfo.isMac) {
            if ("mac" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/cloudConfig/CloudConfigClientUtil", "calcOS"));
            }
            return "mac";
        }
        if (SystemInfo.isWindows) {
            if ("win" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/cloudConfig/CloudConfigClientUtil", "calcOS"));
            }
            return "win";
        }
        if (SystemInfo.isLinux) {
            if ("linux" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/cloudConfig/CloudConfigClientUtil", "calcOS"));
            }
            return "linux";
        }
        if (SystemInfo.isFreeBSD) {
            if ("freebsd" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/cloudConfig/CloudConfigClientUtil", "calcOS"));
            }
            return "freebsd";
        }
        if (SystemInfo.isUnix) {
            if ("unix" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/cloudConfig/CloudConfigClientUtil", "calcOS"));
            }
            return "unix";
        }
        if ("unknown" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/cloudConfig/CloudConfigClientUtil", "calcOS"));
        }
        return "unknown";
    }

    @NotNull
    public static byte[] loadBytes(@NotNull SevenZFile reader, int length) throws IOException {
        int count;
        int n2;
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/idea/cloudConfig/CloudConfigClientUtil", "loadBytes"));
        }
        byte[] bytes = new byte[length];
        for (count = 0; count < bytes.length && (n2 = reader.read(bytes, count, bytes.length - count)) > 0; count += n2) {
        }
        if (count == bytes.length) {
            if (bytes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/cloudConfig/CloudConfigClientUtil", "loadBytes"));
            }
            return bytes;
        }
        byte[] newBytes = new byte[count];
        System.arraycopy(bytes, 0, newBytes, 0, count);
        if (newBytes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/cloudConfig/CloudConfigClientUtil", "loadBytes"));
        }
        return newBytes;
    }

    @Nullable
    public static ETagCloudConfigFileClient createClient() {
        Application application = ApplicationManager.getApplication();
        if (application != null && application.isUnitTestMode()) {
            return testClient;
        }
        Configuration configuration = CloudConfigClientUtil.createConfiguration();
        return configuration == null ? null : new ETagCloudConfigFileClient(CONFIG_URL, configuration);
    }

    @Nullable
    private static Configuration createConfiguration() {
        String userId = JetprofileSource.getSharedUserId();
        if (userId == null) {
            return null;
        }
        return new Configuration().connectTimeout(10000).readTimeout(10000).auth((AuthProvider)new JbaTokenAuthProvider(userId){

            public void authenticate(HttpURLConnection connection) throws IOException {
                super.authenticate(connection);
                if (connection instanceof HttpsURLConnection) {
                    SSLContext context2 = RpcUtil.getClientSSLContext();
                    assert (context2 != null);
                    ((HttpsURLConnection)connection).setSSLSocketFactory(context2.getSocketFactory());
                }
            }
        });
    }

    @Nullable
    public static String getUserLogin() {
        return JetprofileSource.getSharedLogin();
    }
}

