/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea.cloudConfig;

import com.intellij.ide.cloudConfig.CloudConfigProvider;
import com.intellij.ide.customize.AbstractCustomizeWizardStep;
import com.intellij.ide.customize.CustomizeMacKeyboardLayoutStep;
import com.intellij.ide.customize.CustomizePluginsStepPanel;
import com.intellij.ide.customize.CustomizeUIThemeStepPanel;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.cloudConfig.CloudConfigClientUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cloudconfig.CloudConfigFileClient;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudConfigProviderImpl
extends CloudConfigProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.idea.cloudConfig.CloudConfigProviderImpl");
    private CloudConfigFileClient myClient;
    private boolean myRemoteData;
    private boolean myShareData;
    private String myLafClassName;
    private boolean mySkipKeyboardStep;
    private String myDisabledPlugins;
    private String myInstalledPluginsFile;
    private List<String> myInstalledPlugins = Collections.emptyList();

    public CloudConfigProviderImpl() {
        if (!Boolean.getBoolean("use.jba.cloud.config")) {
            return;
        }
        this.myClient = CloudConfigClientUtil.createClient();
        if (this.myClient == null) {
            return;
        }
        try {
            this.myRemoteData = this.myClient.list(CloudConfigClientUtil.getName()).contains("files.7z");
        }
        catch (IOException e2) {
            LOG.debug((Throwable)e2);
            return;
        }
        CloudConfigProviderImpl.setProvider(this);
    }

    private boolean loadRemoteData() {
        try {
            String laf = "laf.xml";
            String keymap = CloudConfigClientUtil.getOS() + ".keymap.xml";
            String disabledPlugins = "disabled_plugins.txt";
            String installedPlugins = "installed_plugins.txt";
            ArrayList files2 = ContainerUtil.newArrayList((Object[])new String[]{laf, keymap, disabledPlugins, installedPlugins});
            HashMap<String, String> result2 = new HashMap<String, String>();
            this.loadRemoteData("updates.7z", files2, result2);
            this.loadRemoteData("files.7z", files2, result2);
            this.myLafClassName = (String)result2.get(laf);
            this.mySkipKeyboardStep = !StringUtil.isEmpty((String)((String)result2.get(keymap)));
            this.myDisabledPlugins = (String)result2.get(disabledPlugins);
            this.myInstalledPluginsFile = (String)result2.get(installedPlugins);
            return true;
        }
        catch (IOException e2) {
            LOG.error((Throwable)e2);
            this.myRemoteData = false;
            this.myShareData = false;
            CloudConfigProviderImpl.setProvider(null);
            return false;
        }
    }

    private void loadRemoteData(@NotNull String name, @NotNull List<String> files2, @NotNull Map<String, String> result2) throws IOException {
        InputStream stream;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/idea/cloudConfig/CloudConfigProviderImpl", "loadRemoteData"));
        }
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/idea/cloudConfig/CloudConfigProviderImpl", "loadRemoteData"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/idea/cloudConfig/CloudConfigProviderImpl", "loadRemoteData"));
        }
        if (files2.isEmpty()) {
            return;
        }
        File archiveFile = new File(PathManager.getConfigPath(), "jba_config/caches/" + name);
        FileUtil.createParentDirs((File)archiveFile);
        try {
            stream = this.myClient.read(CloudConfigClientUtil.getName() + name);
            assert (stream != null);
        }
        catch (FileNotFoundException e2) {
            return;
        }
        try (InputStream inputStream = stream;
             FileOutputStream outputStream = new FileOutputStream(archiveFile);){
            FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        var7_8 = null;
        try (SevenZFile archive = new SevenZFile(archiveFile);){
            while (!files2.isEmpty()) {
                SevenZArchiveEntry entry = archive.getNextEntry();
                if (entry == null) {
                    break;
                }
                if (entry.isDirectory() || !files2.remove(entry.getName())) continue;
                byte[] bytes = CloudConfigClientUtil.loadBytes(archive, (int)entry.getSize());
                result2.put(entry.getName(), new String(bytes, CharsetToolkit.UTF8_CHARSET));
            }
        }
        catch (Throwable throwable) {
            var7_8 = throwable;
            throw throwable;
        }
    }

    @Override
    public void initConfigsPanel(@NotNull ButtonGroup group, @NotNull JRadioButton customButton) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/idea/cloudConfig/CloudConfigProviderImpl", "initConfigsPanel"));
        }
        if (customButton == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customButton", "com/intellij/idea/cloudConfig/CloudConfigProviderImpl", "initConfigsPanel"));
        }
        if (this.myRemoteData) {
            customButton.setText("JetBrains Account: enabled plugins, UI and editor themes only");
            customButton.addItemListener(e2 -> {
                if (customButton == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customButton", "com/intellij/idea/cloudConfig/CloudConfigProviderImpl", "lambda$initConfigsPanel$0"));
                }
                this.myShareData = customButton.isSelected();
            });
            customButton.setVisible(true);
            group.add(customButton);
        }
    }

    @Override
    public void importFinished(@NotNull File newConfigDir) {
        if (newConfigDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newConfigDir", "com/intellij/idea/cloudConfig/CloudConfigProviderImpl", "importFinished"));
        }
        if (this.myShareData) {
            try {
                FileUtil.writeToFile((File)new File(newConfigDir, "jba_config/.auto_connect"), (String)"remote");
            }
            catch (IOException e2) {
                LOG.debug((Throwable)e2);
            }
        }
        CloudConfigProviderImpl.setProvider(null);
    }

    @Override
    public void beforeStartupWizard() {
        if (this.myShareData && this.myRemoteData && this.loadRemoteData()) {
            this.handleLaf();
            this.handleDisabledPlugins();
            this.handleInstalledPlugins();
        }
    }

    private void handleLaf() {
        if (this.myLafClassName != null) {
            try {
                Element laf;
                Element root = new SAXBuilder().build((Reader)new StringReader(this.myLafClassName)).getRootElement();
                Element component = root.getChild("component");
                if (component != null && (laf = component.getChild("laf")) != null) {
                    this.myLafClassName = laf.getAttributeValue("class-name");
                    if (this.myLafClassName != null) {
                        UIManager.setLookAndFeel(this.myLafClassName);
                    }
                    return;
                }
            }
            catch (Exception e2) {
                LOG.debug((Throwable)e2);
            }
            this.myLafClassName = null;
        }
    }

    private void handleDisabledPlugins() {
        if (!StringUtil.isEmpty((String)this.myDisabledPlugins)) {
            try {
                PluginManagerCore.savePluginsList(CloudConfigClientUtil.readPlugins(this.myDisabledPlugins), false, new File(PathManager.getConfigPath(), "disabled_plugins.txt"));
                this.myDisabledPlugins = "";
            }
            catch (IOException e2) {
                this.myDisabledPlugins = null;
            }
        }
    }

    private void handleInstalledPlugins() {
        if (!StringUtil.isEmpty((String)this.myInstalledPluginsFile)) {
            this.myInstalledPlugins = CloudConfigClientUtil.readPlugins(this.myInstalledPluginsFile);
            this.myInstalledPluginsFile = "";
        }
    }

    @Override
    @Nullable
    public String getLafClassName() {
        return this.myLafClassName;
    }

    @Override
    @NotNull
    public List<String> getInstalledPlugins() {
        List<String> list2 = this.myInstalledPlugins;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/cloudConfig/CloudConfigProviderImpl", "getInstalledPlugins"));
        }
        return list2;
    }

    @Override
    public int initSteps(@NotNull List<AbstractCustomizeWizardStep> steps) {
        if (steps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/intellij/idea/cloudConfig/CloudConfigProviderImpl", "initSteps"));
        }
        if (this.myShareData && this.myRemoteData) {
            if (this.myLafClassName != null) {
                CloudConfigProviderImpl.deleteStep(steps, CustomizeUIThemeStepPanel.class);
            }
            if (this.mySkipKeyboardStep) {
                CloudConfigProviderImpl.deleteStep(steps, CustomizeMacKeyboardLayoutStep.class);
            }
            if (this.myDisabledPlugins != null) {
                int size = steps.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    AbstractCustomizeWizardStep step = steps.get(i2);
                    if (!CustomizePluginsStepPanel.class.isInstance(step)) continue;
                    return i2 < size - 1 ? i2 + 1 : i2;
                }
            }
        }
        return 0;
    }

    private static void deleteStep(@NotNull List<AbstractCustomizeWizardStep> steps, Class stepClass) {
        if (steps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/intellij/idea/cloudConfig/CloudConfigProviderImpl", "deleteStep"));
        }
        AbstractCustomizeWizardStep result2 = (AbstractCustomizeWizardStep)ContainerUtil.find(steps, step -> stepClass.isInstance(step));
        if (result2 != null) {
            steps.remove(result2);
        }
    }

    @Override
    public void startupWizardFinished() {
        this.importFinished(new File(PathManager.getConfigPath()));
    }
}

