/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea.cloudConfig;

import com.intellij.idea.cloudConfig.ETagStorageImpl;
import com.jetbrains.cloudconfig.CloudConfigFileClient;
import com.jetbrains.cloudconfig.Configuration;
import com.jetbrains.cloudconfig.ETagStorage;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ETagCloudConfigFileClient
extends CloudConfigFileClient {
    private final ETagStorageImpl myTagStorage;

    public ETagCloudConfigFileClient(@NotNull String endpoint, @NotNull Configuration config) {
        if (endpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endpoint", "com/intellij/idea/cloudConfig/ETagCloudConfigFileClient", "<init>"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/idea/cloudConfig/ETagCloudConfigFileClient", "<init>"));
        }
        this(endpoint, config, new ETagStorageImpl());
    }

    private ETagCloudConfigFileClient(@NotNull String endpoint, @NotNull Configuration config, @NotNull ETagStorageImpl eTagStorage) {
        if (endpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endpoint", "com/intellij/idea/cloudConfig/ETagCloudConfigFileClient", "<init>"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/idea/cloudConfig/ETagCloudConfigFileClient", "<init>"));
        }
        if (eTagStorage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eTagStorage", "com/intellij/idea/cloudConfig/ETagCloudConfigFileClient", "<init>"));
        }
        super(endpoint, config, (ETagStorage)eTagStorage);
        this.myTagStorage = eTagStorage;
    }

    public void delete(String file2) throws IOException {
        super.delete(file2);
        this.myTagStorage.store(file2, null);
    }

    public void clearTags() {
        this.myTagStorage.clear();
    }
}

