/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indentation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.tree.TokenSet;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IndentationFoldingBuilder
implements FoldingBuilder,
DumbAware {
    private final TokenSet myTokenSet;

    public IndentationFoldingBuilder(TokenSet tokenSet) {
        this.myTokenSet = tokenSet;
    }

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode astNode, @NotNull Document document) {
        if (astNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "com/intellij/indentation/IndentationFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/indentation/IndentationFoldingBuilder", "buildFoldRegions"));
        }
        LinkedList<FoldingDescriptor> descriptors = new LinkedList<FoldingDescriptor>();
        this.collectDescriptors(astNode, descriptors);
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/indentation/IndentationFoldingBuilder", "buildFoldRegions"));
        }
        return foldingDescriptorArray;
    }

    private void collectDescriptors(@NotNull ASTNode node, @NotNull List<FoldingDescriptor> descriptors) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/indentation/IndentationFoldingBuilder", "collectDescriptors"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/indentation/IndentationFoldingBuilder", "collectDescriptors"));
        }
        LinkedList<ASTNode> toProcess = new LinkedList<ASTNode>();
        toProcess.add(node);
        while (!toProcess.isEmpty()) {
            ASTNode current = (ASTNode)toProcess.remove();
            if (current.getTreeParent() != null && current.getTextLength() > 1 && this.myTokenSet.contains(current.getElementType())) {
                descriptors.add(new FoldingDescriptor(current, current.getTextRange()));
            }
            for (ASTNode child = current.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                toProcess.add(child);
            }
        }
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/indentation/IndentationFoldingBuilder", "getPlaceholderText"));
        }
        StringBuilder builder = new StringBuilder();
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            String text2 = child.getText();
            if (text2 == null) {
                if (builder.length() <= 0) continue;
                break;
            }
            if (!text2.contains("\n")) {
                builder.append(text2);
                continue;
            }
            if (builder.length() > 0) {
                builder.append(text2.substring(0, text2.indexOf(10)));
                break;
            }
            builder.append(IndentationFoldingBuilder.getFirstNonEmptyLine(text2));
            if (builder.length() > 0) break;
        }
        return builder.toString();
    }

    @NotNull
    private static String getFirstNonEmptyLine(@NotNull String text2) {
        int end;
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/indentation/IndentationFoldingBuilder", "getFirstNonEmptyLine"));
        }
        int start2 = 0;
        while ((end = text2.indexOf(10, start2)) != -1 && start2 >= end) {
            start2 = end + 1;
        }
        String string2 = end == -1 ? text2.substring(start2) : text2.substring(start2, end);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/indentation/IndentationFoldingBuilder", "getFirstNonEmptyLine"));
        }
        return string2;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/indentation/IndentationFoldingBuilder", "isCollapsedByDefault"));
        }
        return false;
    }
}

