/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.injected.editor;

import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectedCaret
implements Caret {
    private final EditorWindow myEditorWindow;
    final Caret myDelegate;

    InjectedCaret(EditorWindow window, Caret delegate2) {
        this.myEditorWindow = window;
        this.myDelegate = delegate2;
    }

    @NotNull
    public Editor getEditor() {
        EditorWindow editorWindow = this.myEditorWindow;
        if (editorWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/InjectedCaret", "getEditor"));
        }
        return editorWindow;
    }

    @NotNull
    public CaretModel getCaretModel() {
        CaretModel caretModel = this.myEditorWindow.getCaretModel();
        if (caretModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/InjectedCaret", "getCaretModel"));
        }
        return caretModel;
    }

    public Caret getDelegate() {
        return this.myDelegate;
    }

    public boolean isValid() {
        return this.myDelegate.isValid();
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean scrollToCaret) {
        this.myDelegate.moveCaretRelatively(columnShift, lineShift, withSelection, scrollToCaret);
    }

    public void moveToLogicalPosition(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/injected/editor/InjectedCaret", "moveToLogicalPosition"));
        }
        LogicalPosition hostPos = this.myEditorWindow.injectedToHost(pos);
        this.myDelegate.moveToLogicalPosition(hostPos);
    }

    public void moveToVisualPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/injected/editor/InjectedCaret", "moveToVisualPosition"));
        }
        LogicalPosition hostPos = this.myEditorWindow.injectedToHost(this.myEditorWindow.visualToLogicalPosition(pos));
        this.myDelegate.moveToLogicalPosition(hostPos);
    }

    public void moveToOffset(int offset) {
        this.moveToOffset(offset, false);
    }

    public void moveToOffset(int offset, boolean locateBeforeSoftWrap) {
        int hostOffset = this.myEditorWindow.getDocument().injectedToHost(offset);
        this.myDelegate.moveToOffset(hostOffset, locateBeforeSoftWrap);
    }

    public boolean isUpToDate() {
        return this.myDelegate.isUpToDate();
    }

    @NotNull
    public LogicalPosition getLogicalPosition() {
        LogicalPosition hostPos = this.myDelegate.getLogicalPosition();
        LogicalPosition logicalPosition = this.myEditorWindow.hostToInjected(hostPos);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/InjectedCaret", "getLogicalPosition"));
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        LogicalPosition logicalPosition = this.getLogicalPosition();
        VisualPosition visualPosition = this.myEditorWindow.logicalToVisualPosition(logicalPosition);
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/InjectedCaret", "getVisualPosition"));
        }
        return visualPosition;
    }

    public int getOffset() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getOffset());
    }

    public int getVisualLineStart() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getVisualLineStart());
    }

    public int getVisualLineEnd() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getVisualLineEnd());
    }

    public int getSelectionStart() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getSelectionStart());
    }

    @NotNull
    public VisualPosition getSelectionStartPosition() {
        VisualPosition visualPosition = this.myDelegate.getSelectionStartPosition();
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/InjectedCaret", "getSelectionStartPosition"));
        }
        return visualPosition;
    }

    public int getSelectionEnd() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getSelectionEnd());
    }

    @NotNull
    public VisualPosition getSelectionEndPosition() {
        VisualPosition visualPosition = this.myDelegate.getSelectionEndPosition();
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/InjectedCaret", "getSelectionEndPosition"));
        }
        return visualPosition;
    }

    @Nullable
    public String getSelectedText() {
        return this.myDelegate.getSelectedText();
    }

    public int getLeadSelectionOffset() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getLeadSelectionOffset());
    }

    @NotNull
    public VisualPosition getLeadSelectionPosition() {
        VisualPosition visualPosition = this.myDelegate.getLeadSelectionPosition();
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/InjectedCaret", "getLeadSelectionPosition"));
        }
        return visualPosition;
    }

    public boolean hasSelection() {
        return this.myDelegate.hasSelection();
    }

    public void setSelection(int startOffset, int endOffset) {
        TextRange hostRange = this.myEditorWindow.getDocument().injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myDelegate.setSelection(hostRange.getStartOffset(), hostRange.getEndOffset());
    }

    public void setSelection(int startOffset, int endOffset, boolean updateSystemSelection) {
        TextRange hostRange = this.myEditorWindow.getDocument().injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myDelegate.setSelection(hostRange.getStartOffset(), hostRange.getEndOffset(), updateSystemSelection);
    }

    public void setSelection(int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        TextRange hostRange = this.myEditorWindow.getDocument().injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myDelegate.setSelection(hostRange.getStartOffset(), endPosition, hostRange.getEndOffset());
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        TextRange hostRange = this.myEditorWindow.getDocument().injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myDelegate.setSelection(startPosition, hostRange.getStartOffset(), endPosition, hostRange.getEndOffset());
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset, boolean updateSystemSelection) {
        TextRange hostRange = this.myEditorWindow.getDocument().injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myDelegate.setSelection(startPosition, hostRange.getStartOffset(), endPosition, hostRange.getEndOffset(), updateSystemSelection);
    }

    public void removeSelection() {
        this.myDelegate.removeSelection();
    }

    public void selectLineAtCaret() {
        this.myDelegate.selectLineAtCaret();
    }

    public void selectWordAtCaret(boolean honorCamelWordsSettings) {
        this.myDelegate.selectWordAtCaret(honorCamelWordsSettings);
    }

    @Nullable
    public Caret clone(boolean above) {
        Caret clone = this.myDelegate.clone(above);
        return clone == null ? null : new InjectedCaret(this.myEditorWindow, clone);
    }

    public void dispose() {
        this.myDelegate.dispose();
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value2) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/injected/editor/InjectedCaret", "putUserDataIfAbsent"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/injected/editor/InjectedCaret", "putUserDataIfAbsent"));
        }
        Object object = this.myDelegate.putUserDataIfAbsent(key, value2);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/InjectedCaret", "putUserDataIfAbsent"));
        }
        return (T)object;
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/injected/editor/InjectedCaret", "replace"));
        }
        return this.myDelegate.replace(key, oldValue, newValue);
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/injected/editor/InjectedCaret", "getUserData"));
        }
        return (T)this.myDelegate.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/injected/editor/InjectedCaret", "putUserData"));
        }
        this.myDelegate.putUserData(key, value2);
    }

    public boolean isAtRtlLocation() {
        return this.myDelegate.isAtRtlLocation();
    }

    public boolean isAtBidiRunBoundary() {
        return this.myDelegate.isAtBidiRunBoundary();
    }

    @NotNull
    public CaretVisualAttributes getVisualAttributes() {
        CaretVisualAttributes caretVisualAttributes = this.myDelegate.getVisualAttributes();
        if (caretVisualAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/InjectedCaret", "getVisualAttributes"));
        }
        return caretVisualAttributes;
    }

    public void setVisualAttributes(@NotNull CaretVisualAttributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/injected/editor/InjectedCaret", "setVisualAttributes"));
        }
        this.myDelegate.setVisualAttributes(attributes);
    }
}

