/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.injected.editor;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

class RangeMarkerWindow
implements RangeMarkerEx {
    private final DocumentWindow myDocumentWindow;
    private final RangeMarkerEx myHostMarker;
    private final int myStartShift;
    private final int myEndShift;

    RangeMarkerWindow(@NotNull DocumentWindow documentWindow, RangeMarkerEx hostMarker, int startShift, int endShift) {
        if (documentWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentWindow", "com/intellij/injected/editor/RangeMarkerWindow", "<init>"));
        }
        this.myDocumentWindow = documentWindow;
        this.myHostMarker = hostMarker;
        this.myStartShift = startShift;
        this.myEndShift = endShift;
    }

    @NotNull
    public Document getDocument() {
        DocumentWindow documentWindow = this.myDocumentWindow;
        if (documentWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/RangeMarkerWindow", "getDocument"));
        }
        return documentWindow;
    }

    public int getStartOffset() {
        int hostOffset = this.myHostMarker.getStartOffset();
        return this.myDocumentWindow.hostToInjected(hostOffset) - this.myStartShift;
    }

    public int getEndOffset() {
        int hostOffset = this.myHostMarker.getEndOffset();
        return this.myDocumentWindow.hostToInjected(hostOffset) + this.myStartShift + this.myEndShift;
    }

    @Override
    public boolean isValid() {
        int endOffset;
        if (!this.myHostMarker.isValid() || !this.myDocumentWindow.isValid()) {
            return false;
        }
        int startOffset = this.getStartOffset();
        return startOffset <= (endOffset = this.getEndOffset()) && endOffset <= this.myDocumentWindow.getTextLength();
    }

    @Override
    public boolean setValid(boolean value2) {
        return this.myHostMarker.setValid(value2);
    }

    public void setGreedyToLeft(boolean greedy) {
        this.myHostMarker.setGreedyToLeft(greedy);
    }

    public void setGreedyToRight(boolean greedy) {
        this.myHostMarker.setGreedyToRight(greedy);
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/injected/editor/RangeMarkerWindow", "getUserData"));
        }
        return (T)this.myHostMarker.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, T value2) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/injected/editor/RangeMarkerWindow", "putUserData"));
        }
        this.myHostMarker.putUserData(key, value2);
    }

    @Override
    public void documentChanged(@NotNull DocumentEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/injected/editor/RangeMarkerWindow", "documentChanged"));
        }
        this.myHostMarker.documentChanged(e2);
    }

    @Override
    public long getId() {
        return this.myHostMarker.getId();
    }

    public RangeMarkerEx getDelegate() {
        return this.myHostMarker;
    }

    public boolean isGreedyToRight() {
        return this.myHostMarker.isGreedyToRight();
    }

    public boolean isGreedyToLeft() {
        return this.myHostMarker.isGreedyToLeft();
    }

    @Override
    public int intervalStart() {
        return this.getStartOffset();
    }

    @Override
    public int intervalEnd() {
        return this.getEndOffset();
    }

    @Override
    public int setIntervalStart(int start2) {
        throw new IllegalStateException();
    }

    @Override
    public int setIntervalEnd(int end) {
        throw new IllegalStateException();
    }

    public void dispose() {
        this.myHostMarker.dispose();
    }

    public String toString() {
        return "RangeMarkerWindow" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "valid" : "invalid") + "," + this.getStartOffset() + "," + this.getEndOffset() + (this.isGreedyToRight() ? "]" : ")") + " " + this.getId();
    }
}

