/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.concurrency.JobScheduler;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.net.NetUtils;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class DebugAttachDetector {
    private static final Logger LOG = Logger.getInstance(DebugAttachDetector.class);
    private String myHost;
    private int myPort = -1;
    private ScheduledFuture<?> myTask;
    private boolean myAttached;
    private boolean myReady;

    public static Pair<String, Integer> getAttachAddress(List<String> arguments) {
        String host = null;
        int port = -1;
        block2: for (String argument : arguments) {
            String[] params;
            if (!argument.startsWith("-agentlib:jdwp") || !argument.contains("transport=dt_socket")) continue;
            for (String param : params = argument.split(",")) {
                if (!param.startsWith("address")) continue;
                try {
                    String[] address = param.split("=")[1].split(":");
                    if (address.length == 1) {
                        port = Integer.parseInt(address[0]);
                        break block2;
                    }
                    host = address[0];
                    port = Integer.parseInt(address[1]);
                    break block2;
                }
                catch (Exception e2) {
                    LOG.error((Throwable)e2);
                    return null;
                }
            }
        }
        if (port > -1) {
            return Pair.create(host, (Object)port);
        }
        return null;
    }

    public DebugAttachDetector() {
        ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        if (!app.isInternal() || app.isUnitTestMode() || app.isHeadlessEnvironment() || Boolean.getBoolean("disable.attach.detector") || Boolean.getBoolean("idea.debug.mode")) {
            return;
        }
        Pair<String, Integer> attachAddress = DebugAttachDetector.getAttachAddress(ManagementFactory.getRuntimeMXBean().getInputArguments());
        if (attachAddress == null) {
            return;
        }
        this.myHost = (String)attachAddress.first;
        this.myPort = (Integer)attachAddress.second;
        this.myTask = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> {
            boolean attached;
            boolean bl = attached = !NetUtils.canConnectToRemoteSocket((String)this.myHost, (int)this.myPort);
            if (!this.myReady) {
                this.myAttached = attached;
                this.myReady = true;
            } else if (attached != this.myAttached) {
                this.myAttached = attached;
                Notifications.Bus.notify((Notification)new Notification("System Messages", "Remote debugger", this.myAttached ? "attached" : "detached", NotificationType.WARNING));
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }
}

