/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class LoadAllContentsAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.internal.LoadAllContentsAction");
    private final AtomicInteger count = new AtomicInteger();
    private final AtomicLong totalSize = new AtomicLong();

    public LoadAllContentsAction() {
        super("Load all files content", "Measure FileUtil.loadFile() for all files in the project", null);
    }

    public void actionPerformed(AnActionEvent e2) {
        Project project2 = e2.getProject();
        String m2 = "Started loading content";
        LOG.info(m2);
        System.out.println(m2);
        long start2 = System.currentTimeMillis();
        this.count.set(0);
        this.totalSize.set(0L);
        ApplicationManagerEx.getApplicationEx().runProcessWithProgressSynchronously(() -> ProjectRootManager.getInstance((Project)project2).getFileIndex().iterateContent(new ContentIterator(){

            public boolean processFile(VirtualFile fileOrDir) {
                if (fileOrDir.isDirectory() || fileOrDir.is(VFileProperty.SPECIAL)) {
                    return true;
                }
                try {
                    LoadAllContentsAction.this.count.incrementAndGet();
                    byte[] bytes = FileUtil.loadFileBytes((File)new File(fileOrDir.getPath()));
                    LoadAllContentsAction.this.totalSize.addAndGet(bytes.length);
                    ProgressManager.getInstance().getProgressIndicator().setText(fileOrDir.getPresentableUrl());
                }
                catch (IOException e1) {
                    LOG.error((Throwable)e1);
                }
                return true;
            }
        }), "Loading", false, project2);
        long end = System.currentTimeMillis();
        String message2 = "Finished loading content of " + this.count + " files. Total size=" + StringUtil.formatFileSize((long)this.totalSize.get()) + ". Elapsed=" + (end - start2) / 1000L + "sec.";
        LOG.info(message2);
        System.out.println(message2);
    }

    public void update(AnActionEvent e2) {
        e2.getPresentation().setEnabled(e2.getData(CommonDataKeys.PROJECT) != null);
    }
}

