/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.internal.ImageDuplicateResultsDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ShowImageDuplicatesAction
extends AnAction {
    private static final List<String> IMAGE_EXTENSIONS = Arrays.asList("png", "jpg", "jpeg", "gif", "tiff", "bmp");

    public void actionPerformed(AnActionEvent e2) {
        Project project2 = ShowImageDuplicatesAction.getEventProject((AnActionEvent)e2);
        assert (project2 != null);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ShowImageDuplicatesAction.collectAndShowDuplicates(project2), "Gathering images", true, project2);
    }

    private static void collectAndShowDuplicates(Project project2) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null && !indicator.isCanceled()) {
            indicator.setText("Collecting project images...");
            indicator.setIndeterminate(false);
            ArrayList<VirtualFile> images = new ArrayList<VirtualFile>();
            for (String ext : IMAGE_EXTENSIONS) {
                images.addAll(FilenameIndex.getAllFilesByExt(project2, ext));
            }
            HashMap<Long, Set<VirtualFile>> duplicates = new HashMap<Long, Set<VirtualFile>>();
            HashMap<Long, VirtualFile> all2 = new HashMap<Long, VirtualFile>();
            for (int i2 = 0; i2 < images.size(); ++i2) {
                indicator.setFraction((double)(i2 + 1) / (double)images.size());
                VirtualFile file2 = (VirtualFile)images.get(i2);
                if (!(file2.getFileSystem() instanceof LocalFileSystem)) continue;
                long length = file2.getLength();
                if (all2.containsKey(length)) {
                    if (!duplicates.containsKey(length)) {
                        HashSet files2 = new HashSet();
                        files2.add(all2.get(length));
                        duplicates.put(length, files2);
                    }
                    ((Set)duplicates.get(length)).add(file2);
                } else {
                    all2.put(length, file2);
                }
                indicator.checkCanceled();
            }
            ShowImageDuplicatesAction.showResults(project2, images, duplicates, all2);
        }
    }

    private static void showResults(Project project2, List<VirtualFile> images, Map<Long, Set<VirtualFile>> duplicates, Map<Long, VirtualFile> all2) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator == null || indicator.isCanceled()) {
            return;
        }
        indicator.setText("MD5 check");
        int count = duplicates.values().stream().mapToInt(Set::size).sum();
        HashMap realDuplicates = new HashMap();
        int seek = 0;
        for (Set<VirtualFile> files2 : duplicates.values()) {
            for (VirtualFile file2 : files2) {
                indicator.setFraction((double)(++seek) / (double)count);
                try {
                    String md5 = ShowImageDuplicatesAction.getMD5Checksum(file2.getInputStream());
                    if (realDuplicates.containsKey(md5)) {
                        ((Set)realDuplicates.get(md5)).add(file2);
                        continue;
                    }
                    HashSet<VirtualFile> set2 = new HashSet<VirtualFile>();
                    set2.add(file2);
                    realDuplicates.put(md5, set2);
                }
                catch (Exception exception) {}
            }
        }
        count = 0;
        for (String key : new ArrayList(realDuplicates.keySet())) {
            int size = ((Set)realDuplicates.get(key)).size();
            if (size == 1) {
                realDuplicates.remove(key);
                continue;
            }
            count += size;
        }
        ApplicationManager.getApplication().invokeLater(() -> new ImageDuplicateResultsDialog(project2, images, realDuplicates).show());
    }

    public void update(AnActionEvent e2) {
        e2.getPresentation().setEnabledAndVisible(ShowImageDuplicatesAction.getEventProject((AnActionEvent)e2) != null);
    }

    public static byte[] createChecksum(InputStream fis) throws Exception {
        int read2;
        byte[] buffer = new byte[1024];
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        while ((read2 = fis.read(buffer)) > 0) {
            md5.update(buffer, 0, read2);
        }
        fis.close();
        return md5.digest();
    }

    public static String getMD5Checksum(InputStream fis) throws Exception {
        byte[] bytes = ShowImageDuplicatesAction.createChecksum(fis);
        String md5 = "";
        for (byte b2 : bytes) {
            md5 = md5 + Integer.toString((b2 & 0xFF) + 256, 16).substring(1);
        }
        return md5;
    }
}

