/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.Consumer;
import com.intellij.util.TimeoutUtil;

public class TestWriteActionUnderProgress
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e2) {
        ApplicationImpl app = (ApplicationImpl)ApplicationManager.getApplication();
        boolean success = app.runWriteActionWithProgressInDispatchThread("Progress", null, null, null, (Consumer<ProgressIndicator>)((Consumer)TestWriteActionUnderProgress::runIndeterminateProgress));
        assert (success);
        app.runWriteActionWithProgressInBackgroundThread("Cancellable Progress", null, null, "Stop", (Consumer<ProgressIndicator>)((Consumer)TestWriteActionUnderProgress::runDeterminateProgress));
    }

    private static void runDeterminateProgress(ProgressIndicator indicator) {
        indicator.setIndeterminate(false);
        int iterations = 3000;
        indicator.setText("In background thread");
        for (int i2 = 0; i2 < iterations; ++i2) {
            TimeoutUtil.sleep((long)1L);
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            indicator.setFraction(((double)i2 + 1.0) / (double)iterations);
            indicator.setText2(String.valueOf(i2));
            ProgressManager.checkCanceled();
        }
    }

    private static void runIndeterminateProgress(ProgressIndicator indicator) {
        indicator.setIndeterminate(true);
        indicator.setText("In Event Dispatch thread");
        for (int i2 = 0; i2 < 1000; ++i2) {
            TimeoutUtil.sleep((long)5L);
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            indicator.checkCanceled();
        }
    }
}

