/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.anomalies;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.Pair;
import java.awt.Component;
import java.awt.Window;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TopAnomaliesAction
extends ActionGroup {
    private static final Comparator<Pair<?, Integer>> COMPARATOR = (o1, o2) -> {
        int h2;
        int i2 = (Integer)o2.getSecond() - (Integer)o1.getSecond();
        if (i2 != 0) {
            return i2;
        }
        int h1 = o1.hashCode();
        if (h1 > (h2 = o2.hashCode())) {
            return 1;
        }
        if (h1 < h2) {
            return -1;
        }
        return 0;
    };
    private static final int LIMIT = 10;
    private static final ResettableAction TOP_PARENTS = new ResettableAction("Parents"){
        TreeSet<Pair<JComponent, Integer>> top = new TreeSet(TopAnomaliesAction.access$000());
        TreeSet<Pair<JComponent, Integer>> old = new TreeSet(TopAnomaliesAction.access$000());

        public void update(AnActionEvent e2) {
            e2.getPresentation().setText("Top 10 Component Parents");
        }

        @Override
        void reset() {
            this.top.clear();
            this.old.clear();
        }

        public void actionPerformed(AnActionEvent e2) {
            this.old = new TreeSet<Pair<JComponent, Integer>>((SortedSet<Pair<JComponent, Integer>>)this.top);
            this.top.clear();
            Window[] windows = Window.getWindows();
            for (Window window : windows) {
                if (!window.isVisible() || !(window instanceof JFrame)) continue;
                JFrame f2 = (JFrame)window;
                this.checkParents((JComponent)f2.getContentPane(), this.top, 10);
            }
            System.out.println("Top 10 component parents");
            for (Pair pair : this.top) {
                System.out.println(((JComponent)pair.first).getClass().getName() + " (" + pair.second + " children)" + TopAnomaliesAction.getChange(this.old, pair.first, (Integer)pair.second));
            }
        }

        private void checkParents(JComponent component, Set<Pair<JComponent, Integer>> top, int limit) {
            top.add((Pair<JComponent, Integer>)Pair.create((Object)component, (Object)component.getComponentCount()));
            TopAnomaliesAction.trimToLimit(top, limit);
            for (int i2 = 0; i2 < component.getComponentCount(); ++i2) {
                Component child = component.getComponent(i2);
                if (!(child instanceof JComponent)) continue;
                this.checkParents((JComponent)child, top, limit);
            }
        }
    };
    private static final ResettableAction TOP_UI_PROPERTIES = new ResettableAction("ClientProperties"){
        TreeSet<Pair<JComponent, Integer>> top = new TreeSet(TopAnomaliesAction.access$000());
        TreeSet<Pair<JComponent, Integer>> old = new TreeSet(TopAnomaliesAction.access$000());

        public void update(AnActionEvent e2) {
            e2.getPresentation().setText("Top 10 ClientProperties");
        }

        @Override
        void reset() {
            this.top.clear();
            this.old.clear();
        }

        public void actionPerformed(AnActionEvent e2) {
            this.old = new TreeSet<Pair<JComponent, Integer>>((SortedSet<Pair<JComponent, Integer>>)this.top);
            this.top.clear();
            Window[] windows = Window.getWindows();
            for (Window window : windows) {
                if (!window.isVisible() || !(window instanceof JFrame)) continue;
                JFrame f2 = (JFrame)window;
                this.checkClientProperties((JComponent)f2.getContentPane(), this.top, 10);
            }
            System.out.println("Top 10 ClientProperties");
            for (Pair pair : this.top) {
                System.out.println(((JComponent)pair.first).getClass().getName() + " (" + pair.second + " properties)" + TopAnomaliesAction.getChange(this.old, pair.first, (Integer)pair.second));
            }
        }

        private void checkClientProperties(JComponent component, Set<Pair<JComponent, Integer>> top, int limit) {
            try {
                Field clientProperties = JComponent.class.getDeclaredField("clientProperties");
                clientProperties.setAccessible(true);
                Object o2 = clientProperties.get(component);
                if (o2 != null) {
                    Method size = o2.getClass().getMethod("size", new Class[0]);
                    size.setAccessible(true);
                    Object sizeResult = size.invoke(o2, new Object[0]);
                    if (sizeResult instanceof Integer) {
                        top.add((Pair<JComponent, Integer>)Pair.create((Object)component, (Object)((Integer)sizeResult)));
                        TopAnomaliesAction.trimToLimit(top, limit);
                    }
                }
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException clientProperties) {
                // empty catch block
            }
            for (int i2 = 0; i2 < component.getComponentCount(); ++i2) {
                Component child = component.getComponent(i2);
                if (!(child instanceof JComponent)) continue;
                this.checkClientProperties((JComponent)child, top, limit);
            }
        }
    };
    private static final ResettableAction RESET_THEM_ALL = new ResettableAction("Reset Statistics"){

        @Override
        void reset() {
        }

        public void actionPerformed(AnActionEvent e2) {
            for (ResettableAction action2 : CHILDREN) {
                action2.reset();
            }
        }
    };
    private static ResettableAction[] CHILDREN = new ResettableAction[]{TOP_PARENTS, TOP_UI_PROPERTIES, RESET_THEM_ALL};

    public void update(AnActionEvent e2) {
        e2.getPresentation().setText("Top 10");
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e2) {
        if (CHILDREN == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/anomalies/TopAnomaliesAction", "getChildren"));
        }
        return CHILDREN;
    }

    private static <K, V> void trimToLimit(Set<Pair<K, V>> top, int limit) {
        int k2 = 0;
        Iterator<Pair<K, V>> iterator2 = top.iterator();
        while (iterator2.hasNext()) {
            iterator2.next();
            if (++k2 < limit) continue;
            iterator2.remove();
        }
    }

    private static <K, V extends Integer> String getChange(Set<Pair<K, V>> old, K key, int newResult) {
        for (Pair<K, V> oldPair : old) {
            if (oldPair.first != key) continue;
            int oldResult = (Integer)oldPair.second;
            if (oldResult == newResult) break;
            return (oldResult > newResult ? " -" : " +") + Math.abs(newResult - oldResult);
        }
        return "";
    }

    static /* synthetic */ Comparator access$000() {
        return COMPARATOR;
    }

    private static abstract class ResettableAction
    extends AnAction {
        protected ResettableAction(@Nullable String text2) {
            super(text2);
        }

        abstract void reset();
    }
}

