/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.encodings;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class EncodingViewer
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.internal.encodings.EncodingViewer");
    private JPanel myPanel;
    private JTextArea myText;
    private JComboBox myEncoding;
    private JButton myLoadFile;
    private byte[] myBytes;

    public EncodingViewer() {
        super(false);
        this.$$$setupUI$$$();
        this.initEncodings();
        this.myLoadFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                VirtualFile file2 = FileChooser.chooseFile((FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), (Component)EncodingViewer.this.myPanel, null, null);
                if (file2 != null) {
                    EncodingViewer.this.loadFrom(file2);
                }
            }
        });
        this.init();
    }

    protected String getDimensionServiceKey() {
        return "EncodingViewer";
    }

    private void loadFrom(VirtualFile virtualFile) {
        try {
            this.myBytes = virtualFile.contentsToByteArray();
        }
        catch (IOException e2) {
            LOG.error((Throwable)e2);
            return;
        }
        this.refreshText();
    }

    private void refreshText() {
        String selectedCharset = this.getSelectedCharset();
        if (this.myBytes == null || selectedCharset == null) {
            return;
        }
        try {
            this.myText.setText(new String(this.myBytes, selectedCharset));
        }
        catch (UnsupportedEncodingException e2) {
            LOG.error((Throwable)e2);
        }
    }

    private String getSelectedCharset() {
        return ((Charset)this.myEncoding.getSelectedItem()).name();
    }

    private void initEncodings() {
        Charset[] availableCharsets = CharsetToolkit.getAvailableCharsets();
        this.myEncoding.setModel(new DefaultComboBoxModel<Charset>(availableCharsets));
        int defaultIndex = Arrays.asList(availableCharsets).indexOf(CharsetToolkit.getDefaultSystemCharset());
        this.myEncoding.setSelectedIndex(defaultIndex);
        this.myEncoding.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() == 1) {
                    EncodingViewer.this.refreshText();
                }
            }
        });
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JComboBox jComboBox;
        JButton jButton;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myLoadFile = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/CommonBundle").getString("button.load.file"));
        jPanel2.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myEncoding = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setVerticalScrollBarPolicy(22);
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myText = jTextArea = new JTextArea();
        jTextArea.setRows(20);
        jTextArea.setEditable(false);
        jBScrollPane.setViewportView(jTextArea);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (string2.charAt(i2) == '&') {
                if (++i2 == string2.length()) break;
                if (!bl && string2.charAt(i2) != '&') {
                    bl = true;
                    c2 = string2.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i2));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n2);
        }
    }
}

