/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.focus;

import com.intellij.internal.focus.FocusTracesDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.intellij.openapi.wm.impl.FocusRequestInfo;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;

public class FocusTracesAction
extends AnAction
implements DumbAware {
    private static boolean myActive = false;
    private AWTEventListener myFocusTracker;

    public static boolean isActive() {
        return myActive;
    }

    public void actionPerformed(AnActionEvent e2) {
        Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        IdeFocusManager manager = IdeFocusManager.getGlobalInstance();
        if (!(manager instanceof FocusManagerImpl)) {
            return;
        }
        final FocusManagerImpl focusManager = (FocusManagerImpl)manager;
        boolean bl = myActive = !myActive;
        if (myActive) {
            this.myFocusTracker = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    if (event instanceof FocusEvent && event.getID() == 1004) {
                        focusManager.recordFocusRequest(((FocusEvent)event).getComponent(), false);
                    }
                }
            };
            Toolkit.getDefaultToolkit().addAWTEventListener(this.myFocusTracker, 4L);
        }
        if (!myActive) {
            List<FocusRequestInfo> requests = focusManager.getRequests();
            new FocusTracesDialog(project2, new ArrayList<FocusRequestInfo>(requests)).show();
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.myFocusTracker);
            this.myFocusTracker = null;
            requests.clear();
        }
    }

    public void update(AnActionEvent e2) {
        Presentation presentation = e2.getPresentation();
        if (myActive) {
            presentation.setText("Stop Focus Tracing");
        } else {
            presentation.setText("Start Focus Tracing");
        }
        presentation.setEnabled(e2.getData(CommonDataKeys.PROJECT) != null);
    }
}

