/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector;

import com.intellij.internal.inspector.UiDropperActionExtension;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.StripeTable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.WeakKeyWeakValueHashMap;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.TwoColorsIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.RoundRectangle2D;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UiDropperAction
extends ToggleAction
implements DumbAware {
    private static AnAction clickAction;
    private static final String UI_DROPPER_PLACE = "UI Dropper Place";
    private UiDropper myUiDropper;

    public static void setClickAction(@NotNull AnAction action2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/internal/inspector/UiDropperAction", "setClickAction"));
        }
        clickAction = action2;
    }

    public boolean isSelected(AnActionEvent e2) {
        return this.myUiDropper != null;
    }

    public void setSelected(AnActionEvent e2, boolean state) {
        if (state) {
            UiInspectorNotification[] existing;
            if (this.myUiDropper == null) {
                this.myUiDropper = new UiDropper();
            }
            if ((existing = (UiInspectorNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(UiInspectorNotification.class, null)).length == 0) {
                Notifications.Bus.notify((Notification)new UiInspectorNotification(), null);
            }
        } else {
            UiDropper inspector = this.myUiDropper;
            this.myUiDropper = null;
            if (inspector != null) {
                Disposer.dispose((Disposable)inspector);
            }
        }
    }

    private static TreeModel buildModel(Component c2) {
        Container parent = c2.getParent();
        while (parent != null) {
            c2 = parent;
            parent = c2.getParent();
        }
        return new DefaultTreeModel(new HierarchyTree.ComponentNode(c2));
    }

    private static Object fromObject(Object o2, Class<?> type) {
        if (o2 == null) {
            return null;
        }
        if (type.isAssignableFrom(o2.getClass())) {
            return o2;
        }
        if ("null".equals(o2)) {
            return null;
        }
        String value2 = String.valueOf(o2).trim();
        if (type == Integer.TYPE) {
            return Integer.parseInt(value2);
        }
        if (type == Boolean.TYPE) {
            return "yes".equalsIgnoreCase(value2) || "true".equalsIgnoreCase(value2);
        }
        if (type == Byte.TYPE) {
            return Byte.parseByte(value2);
        }
        if (type == Short.TYPE) {
            return Short.parseShort(value2);
        }
        if (type == Double.TYPE) {
            return Double.parseDouble(value2);
        }
        if (type == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value2));
        }
        String[] s2 = value2.split("(?i)\\s*(?:[x@:]|[a-z]+:)\\s*", 6);
        if (type == Dimension.class) {
            if (s2.length == 2) {
                return new Dimension(Integer.parseInt(s2[0]), Integer.parseInt(s2[1]));
            }
        } else if (type == Point.class) {
            if (s2.length == 2) {
                return new Point(Integer.parseInt(s2[0]), Integer.parseInt(s2[1]));
            }
        } else if (type == Rectangle.class) {
            if (s2.length >= 5) {
                return new Rectangle(Integer.parseInt(s2[3]), Integer.parseInt(s2[4]), Integer.parseInt(s2[1]), Integer.parseInt(s2[2]));
            }
        } else if (type == Insets.class) {
            if (s2.length >= 5) {
                return new Insets(Integer.parseInt(s2[1]), Integer.parseInt(s2[2]), Integer.parseInt(s2[4]), Integer.parseInt(s2[4]));
            }
        } else if (type == Color.class && s2.length >= 5) {
            return new ColorUIResource(new Color(Integer.parseInt(s2[1]), Integer.parseInt(s2[2]), Integer.parseInt(s2[3]), Integer.parseInt(s2[4])));
        }
        throw new UnsupportedOperationException(type.toString());
    }

    private static class UiDropper
    implements AWTEventListener,
    Disposable {
        Map<Component, InspectorWindow> myComponentToInspector = new WeakKeyWeakValueHashMap();
        HighlightComponent myHighlightComponent;
        Component lastComponent;
        MyLabel myLabel;

        public UiDropper() {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 131122L);
            UiDropperActionExtension[] extensions = (UiDropperActionExtension[])Extensions.getExtensions(UiDropperActionExtension.EP_NAME);
            if (extensions.length > 0) {
                AnAction action2 = extensions[0].getAnAction();
                UiDropperAction.setClickAction(action2);
                return;
            }
        }

        public void dispose() {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            if (this.myHighlightComponent != null) {
                this.myHighlightComponent.dispose();
                this.myHighlightComponent = null;
            }
            if (this.myLabel != null) {
                this.myLabel.dispose();
                this.myLabel = null;
            }
            this.myComponentToInspector.clear();
        }

        private void highlightJBListCell(JBList jbList, Point pointOnList) {
            this.cleanupHighlighting();
            int index = jbList.locationToIndex(pointOnList);
            Rectangle cellBounds = jbList.getCellBounds(index, index);
            if (cellBounds.contains(pointOnList)) {
                Object elementAt = jbList.getModel().getElementAt(index);
                JRootPane rootPane = SwingUtilities.getRootPane((Component)jbList);
                JComponent glassPane = (JComponent)rootPane.getGlassPane();
                if (!(glassPane instanceof IdeGlassPane)) {
                    rootPane.setGlassPane(new IdeGlassPaneImpl(rootPane));
                }
                this.myHighlightComponent = new HighlightComponent((Color)new JBColor((Color)JBColor.GREEN, (Color)JBColor.RED), glassPane, (Component)jbList);
                this.myLabel = elementAt instanceof PopupFactoryImpl.ActionItem ? new MyLabel(elementAt.getClass().getName() + " (\"" + elementAt.toString() + "\")", glassPane, cellBounds.width) : new MyLabel("JBList Cell: " + elementAt.getClass().getName() + " (\"" + elementAt.toString() + "\")", glassPane);
                Point jbListLocationOnRootPane = SwingUtilities.convertPoint((Component)jbList, new Point(0, 0), jbList.getRootPane());
                this.myHighlightComponent.setBounds(jbListLocationOnRootPane.x + cellBounds.x, jbListLocationOnRootPane.y + cellBounds.y, cellBounds.width, cellBounds.height);
                this.calcMyLabelLocation(this.myHighlightComponent.getBounds().getLocation(), glassPane);
                glassPane.add(this.myHighlightComponent);
                glassPane.add(this.myLabel);
                glassPane.revalidate();
                glassPane.repaint();
            } else {
                this.highlightCmp(true, (Component)jbList);
            }
        }

        private void highlightCmp(boolean enable, Component myComponent2) {
            if (myComponent2 instanceof HighlightComponent) {
                return;
            }
            Component target = enable ? myComponent2 : this.myHighlightComponent;
            JRootPane rootPane = target == null ? null : SwingUtilities.getRootPane(target);
            JComponent glassPane = rootPane == null ? null : (JComponent)rootPane.getGlassPane();
            this.cleanupHighlighting();
            if (glassPane == null) {
                return;
            }
            if (enable) {
                this.myHighlightComponent = new HighlightComponent((Color)new JBColor((Color)JBColor.GREEN, (Color)JBColor.RED), glassPane, myComponent2);
                this.myLabel = new MyLabel(myComponent2.getClass().getName(), glassPane);
                Point pt = SwingUtilities.convertPoint(myComponent2, new Point(0, 0), rootPane);
                this.myHighlightComponent.setBounds(pt.x, pt.y, myComponent2.getWidth(), myComponent2.getHeight());
                this.calcMyLabelLocation(pt, glassPane);
                glassPane.add(this.myHighlightComponent);
                glassPane.add(this.myLabel);
            } else {
                glassPane.remove(this.myHighlightComponent);
                this.myHighlightComponent = null;
            }
            glassPane.revalidate();
            glassPane.repaint();
        }

        @Nullable
        private static String getCellText(@NotNull JBList jbList, @NotNull Point pointOnList) {
            if (jbList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jbList", "com/intellij/internal/inspector/UiDropperAction$UiDropper", "getCellText"));
            }
            if (pointOnList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointOnList", "com/intellij/internal/inspector/UiDropperAction$UiDropper", "getCellText"));
            }
            int index = jbList.locationToIndex(pointOnList);
            Rectangle cellBounds = jbList.getCellBounds(index, index);
            if (cellBounds.contains(pointOnList)) {
                Object elementAt = jbList.getModel().getElementAt(index);
                if (elementAt instanceof PopupFactoryImpl.ActionItem) {
                    return ((PopupFactoryImpl.ActionItem)elementAt).getText();
                }
                return elementAt.toString();
            }
            return null;
        }

        private void cleanupHighlighting() {
            if (this.myHighlightComponent != null) {
                this.myHighlightComponent.dispose();
                this.myHighlightComponent = null;
            }
            if (this.myLabel != null) {
                this.myLabel.dispose();
                this.myLabel = null;
            }
        }

        private void calcMyLabelLocation(Point pt, JComponent glasspane) {
            int width = this.myLabel.getPreferredSize().width;
            int height = this.myLabel.getPreferredSize().height;
            int shift = 18;
            int x2 = pt.x;
            int y2 = pt.y - shift;
            if (pt.x + width > glasspane.getWidth()) {
                x2 = Math.max(0, glasspane.getWidth() - width);
            }
            if (pt.y + height > glasspane.getHeight()) {
                y2 = Math.max(0, glasspane.getHeight() - height);
            }
            this.myLabel.setBounds(x2, Math.max(y2, 0), width, height);
        }

        public void showInspector(@NotNull Component c2) {
            if (c2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/internal/inspector/UiDropperAction$UiDropper", "showInspector"));
            }
            InspectorWindow window = this.myComponentToInspector.get(c2);
            if (window != null) {
                window.myHierarchyTree.setModel(UiDropperAction.buildModel(c2));
                window.myHierarchyTree.setCellRenderer((TreeCellRenderer)((Object)new ComponentTreeCellRenderer(c2)));
                window.myHierarchyTree.expandPath();
                window.switchInfo(c2);
                window.setVisible(true);
                window.toFront();
            } else {
                window = new InspectorWindow(c2);
                this.myComponentToInspector.put(c2, window);
                window.pack();
                window.setVisible(true);
                window.toFront();
            }
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event instanceof MouseEvent) {
                this.processMouseEvent((MouseEvent)event);
            } else if (event instanceof ContainerEvent) {
                UiDropper.processContainerEvent((ContainerEvent)event);
            }
        }

        private void processMouseEvent(MouseEvent me) {
            if (!me.isAltDown() || !me.isControlDown()) {
                this.cleanupHighlighting();
                return;
            }
            if (me instanceof MouseWheelEvent && ((MouseWheelEvent)me).getWheelRotation() > 0 && this.lastComponent != null && this.lastComponent.getParent() != null) {
                this.lastComponent = this.lastComponent.getParent();
                this.highlightCmp(true, this.lastComponent);
                me.consume();
                return;
            }
            Component component = me.getComponent();
            if (component instanceof HighlightComponent) {
                return;
            }
            me.consume();
            Point mousePoint = me.getPoint();
            if (component instanceof JFrame) {
                JLayeredPane layeredPane = ((JFrame)component).getLayeredPane();
                Point pt = SwingUtilities.convertPoint(component, mousePoint, layeredPane);
                component = layeredPane.findComponentAt(pt);
            } else if (component instanceof Container) {
                component = ((Container)component).findComponentAt(mousePoint);
            }
            if (component instanceof HighlightComponent) {
                return;
            }
            if (component == null) {
                component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            }
            if (component != null) {
                if (me.getClickCount() == 1 && me.getID() == 500 && me.getButton() == 1 && clickAction != null) {
                    HashMap dataMap = new HashMap();
                    dataMap.put("Component", component);
                    if (component instanceof JBList) {
                        dataMap.put("ItemName", UiDropper.getCellText((JBList)component, mousePoint));
                    }
                    DataContext dataContext = SimpleDataContext.getSimpleContext((Map<String, Object>)dataMap, null);
                    AnActionEvent event = AnActionEvent.createFromDataContext((String)UiDropperAction.UI_DROPPER_PLACE, null, (DataContext)dataContext);
                    clickAction.actionPerformed(event);
                    return;
                }
                this.lastComponent = component;
                if (component instanceof JBList) {
                    this.highlightJBListCell((JBList)component, mousePoint);
                    return;
                }
                this.highlightCmp(true, component);
            }
        }

        private static void processContainerEvent(ContainerEvent event) {
            Component child;
            Component component = child = event.getID() == 300 ? event.getChild() : null;
            if (child instanceof JComponent && !(event.getSource() instanceof CellRendererPane)) {
                String text2 = ExceptionUtil.getThrowableText((Throwable)new Throwable());
                int first = text2.indexOf("at com.intellij", text2.indexOf("at java.awt"));
                int last = text2.indexOf("at java.awt.EventQueue");
                if (last == -1) {
                    last = text2.length();
                }
                String val = last > first && first > 0 ? text2.substring(first, last) : null;
                ((JComponent)child).putClientProperty("uiInspector.addedAt", val);
            }
        }
    }

    private static class InspectorTableModel
    extends AbstractTableModel {
        final List<String> PROPERTIES;
        final List<String> ACCESSIBLE_CONTEXT_PROPERTIES;
        final Component myComponent;
        final List<PropertyBean> myProperties;

        InspectorTableModel(@NotNull Component c2) {
            if (c2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/internal/inspector/UiDropperAction$InspectorTableModel", "<init>"));
            }
            this.PROPERTIES = Arrays.asList("ui", "getLocation", "getLocationOnScreen", "getSize", "isOpaque", "getBorder", "getForeground", "getBackground", "getFont", "getMinimumSize", "getMaximumSize", "getPreferredSize", "isForegroundSet", "isBackgroundSet", "isFontSet", "isMinimumSizeSet", "isMaximumSizeSet", "isPreferredSizeSet", "getText", "isEditable", "getIcon", "getVisibleRect", "getLayout", "getAlignmentX", "getAlignmentY", "getTooltipText", "getToolTipText", "isShowing", "isEnabled", "isVisible", "isDoubleBuffered", "isFocusable", "isFocusCycleRoot", "isFocusOwner", "isValid", "isDisplayable", "isLightweight");
            this.ACCESSIBLE_CONTEXT_PROPERTIES = Arrays.asList("getAccessibleRole", "getAccessibleName", "getAccessibleDescription", "getAccessibleAction", "getAccessibleChildrenCount", "getAccessibleIndexInParent", "getAccessibleRelationSet", "getAccessibleStateSet", "getAccessibleEditableText", "getAccessibleTable", "getAccessibleText", "getAccessibleValue", "accessibleChangeSupport");
            this.myProperties = ContainerUtil.newArrayList();
            this.myComponent = c2;
            this.fillTable();
        }

        void fillTable() {
            this.addProperties("", this.myComponent, this.PROPERTIES);
            Object addedAt = this.myComponent instanceof JComponent ? ((JComponent)this.myComponent).getClientProperty("uiInspector.addedAt") : null;
            this.myProperties.add(new PropertyBean("added-at", addedAt));
            boolean isAccessible = this.myComponent instanceof Accessible;
            this.myProperties.add(new PropertyBean("accessible", isAccessible));
            AccessibleContext context2 = this.myComponent.getAccessibleContext();
            this.myProperties.add(new PropertyBean("accessibleContext", context2));
            if (isAccessible) {
                this.addProperties("  ", this.myComponent.getAccessibleContext(), this.ACCESSIBLE_CONTEXT_PROPERTIES);
            }
        }

        private void addProperties(@NotNull String prefix, @NotNull Object component, @NotNull List<String> methodNames) {
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/internal/inspector/UiDropperAction$InspectorTableModel", "addProperties"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/internal/inspector/UiDropperAction$InspectorTableModel", "addProperties"));
            }
            if (methodNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodNames", "com/intellij/internal/inspector/UiDropperAction$InspectorTableModel", "addProperties"));
            }
            Class<?> clazz0 = component.getClass();
            Class<?> clazz = clazz0.isAnonymousClass() ? clazz0.getSuperclass() : clazz0;
            this.myProperties.add(new PropertyBean(prefix + "class", clazz.getName()));
            for (String name : methodNames) {
                String propertyName = (String)ObjectUtils.notNull((Object)StringUtil.getPropertyName((String)name), (Object)name);
                try {
                    Object propertyValue;
                    try {
                        propertyValue = ReflectionUtil.findMethod(Arrays.asList(clazz.getMethods()), (String)name, (Class[])new Class[0]).invoke(component, new Object[0]);
                    }
                    catch (Exception e2) {
                        propertyValue = ReflectionUtil.findField(clazz, null, (String)name).get(component);
                    }
                    this.myProperties.add(new PropertyBean(prefix + propertyName, propertyValue));
                }
                catch (Exception exception) {}
            }
        }

        @Override
        @Nullable
        public Object getValueAt(int row, int column) {
            PropertyBean bean = this.myProperties.get(row);
            if (bean != null) {
                switch (column) {
                    case 0: {
                        return bean.propertyName;
                    }
                }
                return bean.propertyValue;
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1 && this.updater(this.myProperties.get(row)) != null;
        }

        @Override
        public void setValueAt(Object value2, int row, int col) {
            PropertyBean bean = this.myProperties.get(row);
            try {
                this.myProperties.set(row, new PropertyBean(bean.propertyName, ((Function)ObjectUtils.notNull(this.updater(bean))).fun(value2)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Nullable
        public Function<Object, Object> updater(PropertyBean bean) {
            String name = bean.propertyName.trim();
            try {
                Method getter;
                try {
                    getter = this.myComponent.getClass().getMethod("get" + StringUtil.capitalize((String)name), new Class[0]);
                }
                catch (Exception e2) {
                    getter = this.myComponent.getClass().getMethod("is" + StringUtil.capitalize((String)name), new Class[0]);
                }
                Method finalGetter = getter;
                Method setter = this.myComponent.getClass().getMethod("set" + StringUtil.capitalize((String)name), getter.getReturnType());
                setter.setAccessible(true);
                return o2 -> {
                    try {
                        setter.invoke((Object)this.myComponent, UiDropperAction.fromObject(o2, finalGetter.getReturnType()));
                        return finalGetter.invoke((Object)this.myComponent, new Object[0]);
                    }
                    catch (Exception e2) {
                        throw new RuntimeException(e2);
                    }
                };
            }
            catch (Exception e3) {
                try {
                    Field field = ReflectionUtil.findField(this.myComponent.getClass(), null, (String)name);
                    if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
                        return null;
                    }
                    return o2 -> {
                        try {
                            field.set(this.myComponent, UiDropperAction.fromObject(o2, field.getType()));
                            return field.get(this.myComponent);
                        }
                        catch (Exception e1) {
                            throw new RuntimeException(e1);
                        }
                    };
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.myProperties.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return columnIndex == 0 ? "Property" : "Value";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? String.class : Object.class;
        }

        public void refresh() {
            this.myProperties.clear();
            this.fillTable();
            this.fireTableDataChanged();
        }
    }

    private static class PropertyBean {
        final String propertyName;
        final Object propertyValue;

        PropertyBean(String name, Object value2) {
            this.propertyName = name;
            this.propertyValue = value2;
        }
    }

    private static class ObjectRenderer
    extends JLabel
    implements Renderer<Object> {
        private ObjectRenderer() {
            this.putClientProperty("html.disable", Boolean.TRUE);
        }

        @Override
        public JComponent setValue(@NotNull Object value2) {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiDropperAction$ObjectRenderer", "setValue"));
            }
            this.setText(String.valueOf(value2).replace('\n', ' '));
            return this;
        }
    }

    private static class IconRenderer
    extends JLabel
    implements Renderer<Icon> {
        private IconRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Icon value2) {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiDropperAction$IconRenderer", "setValue"));
            }
            this.setIcon(value2);
            return this;
        }
    }

    private static class BooleanRenderer
    extends JLabel
    implements Renderer<Boolean> {
        private BooleanRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Boolean value2) {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiDropperAction$BooleanRenderer", "setValue"));
            }
            this.setText(value2 != false ? "Yes" : "No");
            return this;
        }
    }

    private static class FontRenderer
    extends JLabel
    implements Renderer<Font> {
        private FontRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Font value2) {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiDropperAction$FontRenderer", "setValue"));
            }
            StringBuilder sb2 = new StringBuilder();
            sb2.append(value2.getFontName()).append(" (").append(value2.getFamily()).append("), ").append(value2.getSize()).append("px");
            if (1 == (1 & value2.getStyle())) {
                sb2.append(" bold");
            }
            if (2 == (2 & value2.getStyle())) {
                sb2.append(" italic");
            }
            if (value2 instanceof UIResource) {
                sb2.append(" UIResource");
            }
            this.setText(sb2.toString());
            return this;
        }
    }

    private static class ColorRenderer
    extends JLabel
    implements Renderer<Color> {
        private ColorRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Color value2) {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiDropperAction$ColorRenderer", "setValue"));
            }
            StringBuilder sb2 = new StringBuilder();
            sb2.append(" r:").append(value2.getRed());
            sb2.append(" g:").append(value2.getGreen());
            sb2.append(" b:").append(value2.getBlue());
            sb2.append(" a:").append(value2.getAlpha());
            sb2.append(" argb:0x");
            String hex = Integer.toHexString(value2.getRGB());
            for (int i2 = hex.length(); i2 < 8; ++i2) {
                sb2.append('0');
            }
            sb2.append(hex.toUpperCase(Locale.ENGLISH));
            if (value2 instanceof UIResource) {
                sb2.append(" UIResource");
            }
            this.setText(sb2.toString());
            this.setIcon((Icon)JBUI.scale((JBUI.JBIcon)new ColorIcon(13, 11, value2, true)));
            return this;
        }
    }

    private static class RectangleRenderer
    extends JLabel
    implements Renderer<Rectangle> {
        private RectangleRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Rectangle value2) {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiDropperAction$RectangleRenderer", "setValue"));
            }
            this.setText(RectangleRenderer.toString(value2));
            return this;
        }

        @NotNull
        static String toString(@NotNull Rectangle r2) {
            if (r2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/internal/inspector/UiDropperAction$RectangleRenderer", "toString"));
            }
            String string2 = r2.width + "x" + r2.height + " @ " + r2.x + ":" + r2.y;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/inspector/UiDropperAction$RectangleRenderer", "toString"));
            }
            return string2;
        }
    }

    private static class InsetsRenderer
    extends JLabel
    implements Renderer<Insets> {
        private InsetsRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Insets value2) {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiDropperAction$InsetsRenderer", "setValue"));
            }
            this.setText("top: " + value2.top + " left:" + value2.left + " bottom:" + value2.bottom + " right:" + value2.right);
            return this;
        }
    }

    private static class DimensionRenderer
    extends JLabel
    implements Renderer<Dimension> {
        private DimensionRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Dimension value2) {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiDropperAction$DimensionRenderer", "setValue"));
            }
            this.setText(String.valueOf(value2.width) + "x" + value2.height);
            return this;
        }
    }

    private static class PointRenderer
    extends JLabel
    implements Renderer<Point> {
        private PointRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Point value2) {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiDropperAction$PointRenderer", "setValue"));
            }
            this.setText(String.valueOf(value2.x) + ':' + value2.y);
            return this;
        }
    }

    private static interface Renderer<T> {
        public JComponent setValue(@NotNull T var1);
    }

    private static class ValueCellRenderer
    implements TableCellRenderer {
        private static final Map<Class, Renderer> RENDERERS = ContainerUtil.newHashMap();
        private static final Renderer<Object> DEFAULT_RENDERER;
        private static final JLabel NULL_RENDERER;

        private ValueCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value2 == null) {
                NULL_RENDERER.setOpaque(isSelected);
                NULL_RENDERER.setForeground(isSelected ? table2.getSelectionForeground() : table2.getForeground());
                NULL_RENDERER.setBackground(isSelected ? table2.getSelectionBackground() : table2.getBackground());
                return NULL_RENDERER;
            }
            Renderer renderer = (Renderer)ObjectUtils.notNull(ValueCellRenderer.getRenderer(value2.getClass()), DEFAULT_RENDERER);
            JComponent result2 = renderer.setValue(value2);
            result2.setOpaque(isSelected);
            result2.setForeground(isSelected ? table2.getSelectionForeground() : table2.getForeground());
            result2.setBackground(isSelected ? table2.getSelectionBackground() : table2.getBackground());
            return result2;
        }

        @Nullable
        private static Renderer<Object> getRenderer(Class clazz) {
            Class<?>[] interfaces;
            if (clazz == null) {
                return null;
            }
            Renderer<Object> renderer = RENDERERS.get(clazz);
            if (renderer != null) {
                return renderer;
            }
            for (Class<?> aClass : interfaces = clazz.getInterfaces()) {
                renderer = ValueCellRenderer.getRenderer(aClass);
                if (renderer == null) continue;
                return renderer;
            }
            if ((clazz = clazz.getSuperclass()) != null) {
                return ValueCellRenderer.getRenderer(clazz);
            }
            return null;
        }

        static {
            RENDERERS.put(Point.class, new PointRenderer());
            RENDERERS.put(Dimension.class, new DimensionRenderer());
            RENDERERS.put(Insets.class, new InsetsRenderer());
            RENDERERS.put(Rectangle.class, new RectangleRenderer());
            RENDERERS.put(Color.class, new ColorRenderer());
            RENDERERS.put(Font.class, new FontRenderer());
            RENDERERS.put(Boolean.class, new BooleanRenderer());
            RENDERERS.put(Icon.class, new IconRenderer());
            DEFAULT_RENDERER = new ObjectRenderer();
            NULL_RENDERER = new JLabel("-");
        }
    }

    private static class DimensionsComponent
    extends JComponent {
        Component myComponent;
        int myWidth;
        int myHeight;
        Border myBorder;
        Insets myInsets;

        private DimensionsComponent(@NotNull Component component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/internal/inspector/UiDropperAction$DimensionsComponent", "<init>"));
            }
            this.myComponent = component;
            this.setOpaque(true);
            this.setBackground((Color)JBColor.WHITE);
            this.setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
            this.setFont((Font)JBUI.Fonts.label((float)9.0f));
            this.update();
        }

        public void update() {
            this.myWidth = this.myComponent.getWidth();
            this.myHeight = this.myComponent.getHeight();
            if (this.myComponent instanceof JComponent) {
                this.myBorder = ((JComponent)this.myComponent).getBorder();
                this.myInsets = ((JComponent)this.myComponent).getInsets();
            }
        }

        @Override
        protected void paintComponent(Graphics g2) {
            Graphics2D g2d = (Graphics2D)g2;
            Rectangle bounds = this.getBounds();
            g2d.setColor(this.getBackground());
            Insets insets = this.getInsets();
            g2d.fillRect(insets.left, insets.top, bounds.width - insets.left - insets.right, bounds.height - insets.top - insets.bottom);
            g2d.setColor(this.getForeground());
            String sizeString = String.valueOf(this.myWidth) + " x " + this.myHeight;
            FontMetrics fm = g2d.getFontMetrics();
            int sizeWidth = fm.stringWidth(sizeString);
            int fontHeight = fm.getHeight();
            g2d.drawString(sizeString, bounds.width / 2 - sizeWidth / 2, bounds.height / 2 + fontHeight / 2);
            g2d.setColor((Color)JBColor.GRAY);
            int innerX = bounds.width / 2 - sizeWidth / 2 - 20;
            int innerY = bounds.height / 2 - fontHeight / 2 - 5;
            int innerWidth = sizeWidth + 40;
            int innerHeight = fontHeight + 10;
            g2d.drawRect(innerX, innerY, innerWidth, innerHeight);
            Insets borderInsets = null;
            if (this.myBorder != null) {
                borderInsets = this.myBorder.getBorderInsets(this.myComponent);
            }
            UIUtil.drawDottedRectangle((Graphics)g2d, (int)(innerX - 15), (int)(innerY - 15), (int)(innerX - 15 + innerWidth + 30), (int)(innerY - 15 + innerHeight + 30));
            DimensionsComponent.drawInsets(g2d, fm, "border", borderInsets, 15, fontHeight, innerX, innerY, innerWidth, innerHeight);
            g2d.drawRect(innerX - 30, innerY - 30, innerWidth + 60, innerHeight + 60);
            DimensionsComponent.drawInsets(g2d, fm, "insets", this.myInsets, 30, fontHeight, innerX, innerY, innerWidth, innerHeight);
        }

        private static void drawInsets(Graphics2D g2d, FontMetrics fm, String name, Insets insets, int offset, int fontHeight, int innerX, int innerY, int innerWidth, int innerHeight) {
            g2d.setColor((Color)JBColor.BLACK);
            g2d.drawString(name, innerX - offset + 5, innerY - offset + fontHeight);
            g2d.setColor((Color)JBColor.GRAY);
            int dashWidth = fm.stringWidth("-");
            if (insets != null) {
                String top = Integer.toString(insets.top);
                String bottom = Integer.toString(insets.bottom);
                String left = Integer.toString(insets.left);
                String right = Integer.toString(insets.right);
                g2d.drawString(top, innerX - offset + ((innerWidth + offset * 2) / 2 - fm.stringWidth(top) / 2), innerY - offset + fontHeight);
                g2d.drawString(bottom, innerX - offset + ((innerWidth + offset * 2) / 2 - fm.stringWidth(bottom) / 2), innerY - offset + innerHeight + offset * 2 - 8 + fontHeight / 2);
                g2d.drawString(left, innerX - offset + 7 - fm.stringWidth(left) / 2, innerY - offset + (innerHeight + offset * 2) / 2 + fontHeight / 2);
                g2d.drawString(right, innerX + innerWidth + offset - 7 - fm.stringWidth(right) / 2, innerY - offset + (innerHeight + offset * 2) / 2 + fontHeight / 2);
            } else {
                g2d.drawString("-", innerX - offset + ((innerWidth + offset * 2) / 2 - dashWidth / 2), innerY - offset + fontHeight);
                g2d.drawString("-", innerX - offset + ((innerWidth + offset * 2) / 2 - dashWidth / 2), innerY - offset + innerHeight + offset * 2 - 8 + fontHeight / 2);
                g2d.drawString("-", innerX - offset + 7 - dashWidth / 2, innerY - offset + (innerHeight + offset * 2) / 2 + fontHeight / 2);
                g2d.drawString("-", innerX + innerWidth + offset - 7 - dashWidth / 2, innerY - offset + (innerHeight + offset * 2) / 2 + fontHeight / 2);
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return JBUI.size((int)120);
        }

        @Override
        public Dimension getPreferredSize() {
            return JBUI.size((int)150);
        }
    }

    private static class InspectorTable
    extends JPanel {
        InspectorTableModel myModel;
        DimensionsComponent myDimensionComponent;

        private InspectorTable(@NotNull Component component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/internal/inspector/UiDropperAction$InspectorTable", "<init>"));
            }
            this.setLayout(new BorderLayout());
            this.myModel = new InspectorTableModel(component);
            StripeTable table2 = new StripeTable((TableModel)this.myModel);
            new TableSpeedSearch((JTable)table2);
            TableColumnModel columnModel = table2.getColumnModel();
            TableColumn propertyColumn = columnModel.getColumn(0);
            propertyColumn.setMinWidth(JBUI.scale((int)200));
            propertyColumn.setMaxWidth(JBUI.scale((int)200));
            propertyColumn.setResizable(false);
            TableColumn valueColumn = columnModel.getColumn(1);
            valueColumn.setMinWidth(JBUI.scale((int)200));
            valueColumn.setResizable(false);
            valueColumn.setCellRenderer(new ValueCellRenderer());
            valueColumn.setCellEditor(new DefaultCellEditor((JTextField)new JBTextField()){

                @Override
                public Component getTableCellEditorComponent(JTable table2, Object value2, boolean isSelected, int row, int column) {
                    Component comp = table2.getCellRenderer(row, column).getTableCellRendererComponent(table2, value2, false, false, row, column);
                    if (comp instanceof JLabel) {
                        value2 = ((JLabel)comp).getText();
                    }
                    Component result2 = super.getTableCellEditorComponent(table2, value2, isSelected, row, column);
                    ((JComponent)result2).setBorder(BorderFactory.createLineBorder((Color)JBColor.GRAY, 1));
                    return result2;
                }

                @Override
                public Object getCellEditorValue() {
                    return super.getCellEditorValue();
                }
            });
            table2.setAutoResizeMode(3);
            this.add((Component)new JBScrollPane((Component)table2), "Center");
            this.myDimensionComponent = new DimensionsComponent(component);
            this.add((Component)this.myDimensionComponent, "South");
        }

        public void refresh() {
            this.myModel.refresh();
            this.myDimensionComponent.update();
            this.myDimensionComponent.repaint();
        }
    }

    private static class HighlightComponent
    extends JComponent {
        Color myColor;
        JComponent myGlassPane;
        Component myOriginalComponent;

        private HighlightComponent(@NotNull Color c2, @NotNull JComponent glassPane, @NotNull Component originalComponent) {
            if (c2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/internal/inspector/UiDropperAction$HighlightComponent", "<init>"));
            }
            if (glassPane == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "glassPane", "com/intellij/internal/inspector/UiDropperAction$HighlightComponent", "<init>"));
            }
            if (originalComponent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalComponent", "com/intellij/internal/inspector/UiDropperAction$HighlightComponent", "<init>"));
            }
            this.myColor = c2;
            this.myGlassPane = glassPane;
            this.myOriginalComponent = originalComponent;
        }

        @Override
        protected void paintComponent(Graphics g2) {
            Graphics2D g2d = (Graphics2D)g2;
            Color oldColor = g2d.getColor();
            g2d.setColor(this.myColor);
            Composite old = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, 0.2f));
            Rectangle r2 = this.getBounds();
            g2d.fillRect(0, 0, r2.width, r2.height);
            g2d.setColor(this.myColor.darker());
            g2d.drawRect(0, 0, r2.width - 1, r2.height - 1);
            g2d.setComposite(old);
            g2d.setColor(oldColor);
        }

        public void dispose() {
            if (this.myGlassPane != null) {
                this.myGlassPane.remove(this);
            }
        }
    }

    private static class MyLabel
    extends JLabel {
        private final JComponent myGlasspane;
        private String myText;

        private MyLabel(@NotNull String text2, @NotNull JComponent glasspane) {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/internal/inspector/UiDropperAction$MyLabel", "<init>"));
            }
            if (glasspane == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "glasspane", "com/intellij/internal/inspector/UiDropperAction$MyLabel", "<init>"));
            }
            super(text2);
            this.myText = text2;
            this.myGlasspane = glasspane;
            this.setForeground((Color)Gray._230);
            this.setFont(UIUtil.getLabelFont());
        }

        public MyLabel(String text2, JComponent glassPane, int width) {
            super(text2);
            this.myText = text2;
            this.myGlasspane = glassPane;
            this.setForeground((Color)Gray._230);
            this.setFont(new Font(UIUtil.getLabelFont().getName(), 0, 6));
        }

        public void dispose() {
            if (this.myGlasspane != null) {
                this.myGlasspane.remove(this);
            }
        }

        @Override
        protected void paintComponent(Graphics g2) {
            boolean cornerRadius = false;
            Rectangle bounds = this.getBounds();
            Graphics2D g22 = (Graphics2D)g2;
            g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g22.setColor((Color)Gray._90);
            g22.fill(new RoundRectangle2D.Float(0.0f, 0.0f, bounds.width, bounds.height, (float)cornerRadius, (float)cornerRadius));
            super.paintComponent(g2);
        }
    }

    private static abstract class HierarchyTree
    extends JTree
    implements TreeSelectionListener {
        final Component myComponent;

        private HierarchyTree(Component c2) {
            this.myComponent = c2;
            this.setModel(UiDropperAction.buildModel(c2));
            this.setCellRenderer((TreeCellRenderer)((Object)new ComponentTreeCellRenderer(c2)));
            this.getSelectionModel().addTreeSelectionListener(this);
            new TreeSpeedSearch(this);
        }

        public void expandPath() {
            TreeUtil.expandAll((JTree)this);
            int count = this.getRowCount();
            ComponentNode node = new ComponentNode(this.myComponent);
            for (int i2 = 0; i2 < count; ++i2) {
                TreePath row = this.getPathForRow(i2);
                if (!row.getLastPathComponent().equals(node)) continue;
                this.setSelectionPath(row);
                this.scrollPathToVisible(this.getSelectionPath());
                break;
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent e2) {
            TreePath path = e2.getNewLeadSelectionPath();
            if (path == null) {
                this.onComponentChanged(null);
                return;
            }
            Object component = path.getLastPathComponent();
            if (component instanceof ComponentNode) {
                Component c2 = ((ComponentNode)component).getComponent();
                this.onComponentChanged(c2);
            }
        }

        public abstract void onComponentChanged(Component var1);

        private static class ComponentNode
        extends DefaultMutableTreeNode {
            private final Component myComponent;
            String myText;

            private ComponentNode(@NotNull Component component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/internal/inspector/UiDropperAction$HierarchyTree$ComponentNode", "<init>"));
                }
                super(component);
                this.myComponent = component;
                this.children = ComponentNode.prepareChildren(this.myComponent);
            }

            Component getComponent() {
                return this.myComponent;
            }

            @Override
            public String toString() {
                return this.myText != null ? this.myText : this.myComponent.getClass().getName();
            }

            public void setText(String value2) {
                this.myText = value2;
            }

            public boolean equals(Object obj) {
                return obj instanceof ComponentNode && ((ComponentNode)obj).getComponent() == this.getComponent();
            }

            private static Vector prepareChildren(Component parent) {
                Vector<ComponentNode> result2 = new Vector<ComponentNode>();
                if (parent instanceof Container) {
                    for (Component component : ((Container)parent).getComponents()) {
                        result2.add(new ComponentNode(component));
                    }
                }
                if (parent instanceof Window) {
                    Window[] children2;
                    for (Window child : children2 = ((Window)parent).getOwnedWindows()) {
                        if (child instanceof InspectorWindow) continue;
                        result2.add(new ComponentNode(child));
                    }
                }
                return result2;
            }
        }
    }

    private static class ComponentTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final Component myInitialSelection;

        ComponentTreeCellRenderer(Component initialSelection) {
            this.myInitialSelection = initialSelection;
            this.setFont((Font)JBUI.Fonts.label((float)11.0f));
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)3));
        }

        public void customizeCellRenderer(@NotNull JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Color background;
            if (tree2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/internal/inspector/UiDropperAction$ComponentTreeCellRenderer", "customizeCellRenderer"));
            }
            Color foreground = selected ? UIUtil.getTreeSelectionForeground() : UIUtil.getTreeForeground();
            Color color = background = selected ? UIUtil.getTreeSelectionBackground() : null;
            if (value2 instanceof HierarchyTree.ComponentNode) {
                HierarchyTree.ComponentNode componentNode = (HierarchyTree.ComponentNode)value2;
                Component component = componentNode.getComponent();
                Class<?> clazz0 = component.getClass();
                Class<?> clazz = clazz0.isAnonymousClass() ? clazz0.getSuperclass() : clazz0;
                String name = component.getName();
                if (!selected) {
                    if (!component.isVisible()) {
                        foreground = JBColor.GRAY;
                    } else if (component.getWidth() == 0 || component.getHeight() == 0) {
                        foreground = new JBColor(new Color(128, 10, 0), (Color)JBColor.BLUE);
                    } else if (component.getPreferredSize() != null && (component.getSize().width < component.getPreferredSize().width || component.getSize().height < component.getPreferredSize().height)) {
                        foreground = PlatformColors.BLUE;
                    }
                    if (this.myInitialSelection == componentNode.getComponent()) {
                        background = new Color(31, 128, 8, 58);
                    }
                }
                this.append(clazz.getSimpleName());
                if (StringUtil.isNotEmpty((String)name)) {
                    this.append(" \"" + name + "\"");
                }
                this.append(": " + RectangleRenderer.toString(component.getBounds()), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                if (component.isOpaque()) {
                    this.append(", opaque", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
                if (component.isDoubleBuffered()) {
                    this.append(", double-buffered", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
                componentNode.setText(this.toString());
                this.setIcon((Icon)JBUI.scale((JBUI.JBIcon)new TwoColorsIcon(11, component.getForeground(), component.getBackground())));
            }
            this.setForeground(foreground);
            this.setBackground(background);
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)tree2, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
        }
    }

    private static class InspectorWindow
    extends JDialog {
        private InspectorTable myInspectorTable;
        private Component myComponent;
        private HighlightComponent myHighlightComponent;
        private HierarchyTree myHierarchyTree;
        private final JPanel myWrapperPanel;

        private InspectorWindow(@NotNull Component component) throws HeadlessException {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/internal/inspector/UiDropperAction$InspectorWindow", "<init>"));
            }
            super(InspectorWindow.findWindow(component));
            Window window = InspectorWindow.findWindow(component);
            this.setModal(window instanceof JDialog && ((JDialog)window).isModal());
            this.myComponent = component;
            this.getRootPane().setBorder(JBUI.Borders.empty((int)5));
            this.setDefaultCloseOperation(2);
            this.setLayout(new BorderLayout());
            this.setTitle(component.getClass().getName());
            DefaultActionGroup actions2 = new DefaultActionGroup();
            actions2.addAction((AnAction)new IconWithTextAction("Highlight"){

                public void actionPerformed(AnActionEvent e2) {
                }

                public void update(AnActionEvent e2) {
                    e2.getPresentation().setEnabled(myComponent != null && myComponent.isVisible());
                }
            });
            actions2.addSeparator();
            actions2.add((AnAction)new IconWithTextAction("Refresh"){

                public void actionPerformed(AnActionEvent e2) {
                    this.getCurrentTable().refresh();
                }

                public void update(AnActionEvent e2) {
                    e2.getPresentation().setEnabled(myComponent != null && myComponent.isVisible());
                }
            });
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ContextToolbar", (ActionGroup)actions2, true);
            this.add((Component)toolbar.getComponent(), "North");
            this.myWrapperPanel = new JPanel(new BorderLayout());
            this.myInspectorTable = new InspectorTable(component);
            this.myHierarchyTree = new HierarchyTree(component){

                @Override
                public void onComponentChanged(Component c2) {
                    boolean wasHighlighted = myHighlightComponent != null;
                    this.switchInfo(c2);
                }
            };
            this.myWrapperPanel.add((Component)this.myInspectorTable, "Center");
            JSplitPane splitPane = new JSplitPane();
            splitPane.setDividerLocation(0.5);
            splitPane.setRightComponent(this.myWrapperPanel);
            JBScrollPane pane = new JBScrollPane((Component)this.myHierarchyTree);
            splitPane.setLeftComponent((Component)pane);
            this.add((Component)splitPane, "Center");
            this.myHierarchyTree.expandPath();
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e2) {
                    this.close();
                }
            });
            this.getRootPane().getActionMap().put("CLOSE", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    this.close();
                }
            });
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "CLOSE");
        }

        private static Window findWindow(Component component) {
            DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)component);
            if (dialogWrapper != null) {
                return dialogWrapper.getPeer().getWindow();
            }
            return null;
        }

        private InspectorTable getCurrentTable() {
            return this.myInspectorTable;
        }

        private void switchInfo(@Nullable Component c2) {
            if (c2 == null) {
                return;
            }
            this.myComponent = c2;
            this.setTitle(this.myComponent.getClass().getName());
            this.myWrapperPanel.removeAll();
            this.myInspectorTable = new InspectorTable(c2);
            this.myWrapperPanel.add((Component)this.myInspectorTable, "Center");
            this.myWrapperPanel.revalidate();
            this.myWrapperPanel.repaint();
        }

        public void close() {
            this.myComponent = null;
            this.setVisible(false);
            this.dispose();
        }
    }

    private static class UiInspectorNotification
    extends Notification {
        private UiInspectorNotification() {
            super("System Messages", "UI Dropper", "Hold ctr + alt and navigate cursor to component.\nUse mouse wheel to get info of parent component.", NotificationType.INFORMATION);
        }
    }
}

