/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.performance;

import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class EditorRenderingBenchmarkAction
extends AnAction
implements DumbAware {
    private static final int PERIOD = 5;
    private final NotificationGroup myNotificationGroup = NotificationGroup.logOnlyGroup((String)"editor-rendering-benchmark");

    public void actionPerformed(AnActionEvent e2) {
        Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        Editor editor = (Editor)e2.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            this.myNotificationGroup.createNotification("No active editor", MessageType.ERROR).notify(project2);
            return;
        }
        this.myNotificationGroup.createNotification(String.format("Benchmarking the editor for %s seconds...", 5), MessageType.INFO).notify(project2);
        ApplicationManager.getApplication().invokeLater(() -> {
            JComponent component = editor.getComponent();
            Rectangle r2 = component.getVisibleRect();
            long threshold = System.currentTimeMillis() + 5000L;
            int n2 = 0;
            do {
                component.paintImmediately(r2);
                ++n2;
            } while (System.currentTimeMillis() < threshold);
            double fps = (double)n2 / 5.0;
            this.myNotificationGroup.createNotification(String.format("Benchmark results: %.1f FPS (%d x %d)", fps, r2.width, r2.height), MessageType.INFO).notify(project2);
        });
    }
}

