/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.psiView;

import com.intellij.internal.psiView.PsiViewerDialog;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.Nullable;

public class PsiViewerAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e2) {
        Editor editor = this.isForContext() ? (Editor)e2.getData(CommonDataKeys.EDITOR) : null;
        new PsiViewerDialog(e2.getProject(), editor).show();
    }

    public void update(AnActionEvent e2) {
        boolean enabled = PsiViewerAction.isEnabled(e2.getProject());
        e2.getPresentation().setEnabledAndVisible(enabled);
        if (enabled && this.isForContext() && e2.getData(CommonDataKeys.EDITOR) == null) {
            e2.getPresentation().setEnabled(false);
        }
    }

    protected boolean isForContext() {
        return false;
    }

    private static boolean isEnabled(@Nullable Project project2) {
        if (project2 == null) {
            return false;
        }
        if (ApplicationManagerEx.getApplicationEx().isInternal()) {
            return true;
        }
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            if (!"PLUGIN_MODULE".equals(ModuleType.get((Module)module2).getId())) continue;
            return true;
        }
        return false;
    }

    public static class ForContext
    extends PsiViewerAction {
        @Override
        protected boolean isForContext() {
            return true;
        }
    }
}

