/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.ideSettings;

import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.ideSettings.IdeSettingsDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.hash.HashSet;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeSettingsStatisticsUtils {
    public static final GroupDescriptor GROUP = GroupDescriptor.create("IDE Settings", 100.0);

    @Nullable
    public static Object getApplicationProvider(@NotNull String providerName) {
        if (providerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providerName", "com/intellij/internal/statistic/ideSettings/IdeSettingsStatisticsUtils", "getApplicationProvider"));
        }
        return IdeSettingsStatisticsUtils.getProviderInstance(IdeSettingsStatisticsUtils.getApplicationComponentByName(providerName));
    }

    public static Set<UsageDescriptor> getUsages(@NotNull IdeSettingsDescriptor descriptor2, @NotNull Object componentInstance) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/internal/statistic/ideSettings/IdeSettingsStatisticsUtils", "getUsages"));
        }
        if (componentInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentInstance", "com/intellij/internal/statistic/ideSettings/IdeSettingsStatisticsUtils", "getUsages"));
        }
        HashSet descriptors = new HashSet();
        String providerName = descriptor2.myProviderName;
        List<String> propertyNames = descriptor2.getPropertyNames();
        if (providerName != null && propertyNames.size() > 0) {
            for (String propertyName : propertyNames) {
                Object propertyValue = IdeSettingsStatisticsUtils.getPropertyValue(componentInstance, propertyName);
                if (propertyValue == null) continue;
                descriptors.add(new UsageDescriptor(IdeSettingsStatisticsUtils.getUsageDescriptorKey(providerName, propertyName, propertyValue.toString()), 1));
            }
        }
        return descriptors;
    }

    @Nullable
    private static Object getPropertyValue(Object componentInstance, String propertyName) {
        Class<?> componentInstanceClass = componentInstance.getClass();
        Object propertyValue = ReflectionUtil.getField(componentInstanceClass, (Object)componentInstance, null, (String)propertyName);
        if (propertyValue == null) {
            Method method2 = ReflectionUtil.getMethod(componentInstanceClass, (String)("get" + StringUtil.capitalize((String)propertyName)), (Class[])new Class[0]);
            if (method2 == null) {
                method2 = ReflectionUtil.getMethod(componentInstanceClass, (String)("is" + StringUtil.capitalize((String)propertyName)), (Class[])new Class[0]);
            }
            if (method2 != null) {
                try {
                    propertyValue = method2.invoke(componentInstance, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return propertyValue;
    }

    private static String getUsageDescriptorKey(@NotNull String providerName, @NotNull String name, @NotNull String value2) {
        if (providerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providerName", "com/intellij/internal/statistic/ideSettings/IdeSettingsStatisticsUtils", "getUsageDescriptorKey"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/internal/statistic/ideSettings/IdeSettingsStatisticsUtils", "getUsageDescriptorKey"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/statistic/ideSettings/IdeSettingsStatisticsUtils", "getUsageDescriptorKey"));
        }
        String shortName = StringUtil.getShortName((String)providerName);
        return shortName + "#" + name + "(" + value2 + ")";
    }

    @Nullable
    public static Object getProjectProvider(@Nullable Project project2, @NotNull String providerName) {
        if (providerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providerName", "com/intellij/internal/statistic/ideSettings/IdeSettingsStatisticsUtils", "getProjectProvider"));
        }
        return IdeSettingsStatisticsUtils.getProviderInstance(IdeSettingsStatisticsUtils.getProjectComponentByName(project2, providerName));
    }

    @Nullable
    private static Object getProviderInstance(Object componentInstance) {
        if (componentInstance instanceof PersistentStateComponent) {
            return ((PersistentStateComponent)componentInstance).getState();
        }
        return componentInstance;
    }

    @Nullable
    private static Object getApplicationComponentByName(@NotNull String providerName) {
        if (providerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providerName", "com/intellij/internal/statistic/ideSettings/IdeSettingsStatisticsUtils", "getApplicationComponentByName"));
        }
        return ApplicationManager.getApplication().getPicoContainer().getComponentInstance((Object)providerName);
    }

    @Nullable
    private static Object getProjectComponentByName(@Nullable Project project2, String providerName) {
        if (project2 != null) {
            return project2.getPicoContainer().getComponentInstance((Object)providerName);
        }
        return null;
    }
}

