/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.PropertyResourceBundle;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XMLCatalogManager {
    private static final Logger LOG = Logger.getInstance(XMLCatalogManager.class);
    private static final Field ourResources;
    private static final Field ourPropertyFileUri;
    private final CatalogManager myManager;

    public XMLCatalogManager(@NotNull String propertiesFilePath) {
        if (propertiesFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesFilePath", "com/intellij/javaee/XMLCatalogManager", "<init>"));
        }
        this.myManager = new CatalogManager();
        File file2 = new File(propertiesFilePath);
        try {
            String s2 = FileUtil.loadFile((File)file2);
            PropertyResourceBundle bundle = new PropertyResourceBundle(new StringReader(s2));
            ourResources.set(this.myManager, bundle);
            ourPropertyFileUri.set(this.myManager, file2.toURI().toURL());
        }
        catch (IllegalAccessException e2) {
            LOG.error((Throwable)e2);
        }
        catch (IOException e3) {
            LOG.warn((Throwable)e3);
        }
    }

    @Nullable
    public String resolve(String uri2) {
        try {
            Catalog catalog = this.myManager.getCatalog();
            if (catalog == null) {
                return null;
            }
            String resolved = catalog.resolveSystem(uri2);
            return resolved == null ? catalog.resolvePublic(uri2, null) : resolved;
        }
        catch (IOException e2) {
            LOG.warn((Throwable)e2);
            return null;
        }
    }

    public CatalogManager getManager() {
        return this.myManager;
    }

    static {
        try {
            ourResources = CatalogManager.class.getDeclaredField("resources");
            ourResources.setAccessible(true);
            ourPropertyFileUri = CatalogManager.class.getDeclaredField("propertyFileURI");
            ourPropertyFileUri.setAccessible(true);
        }
        catch (NoSuchFieldException e2) {
            throw new RuntimeException(e2);
        }
    }
}

