/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.codeinsight;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JsonDuplicatePropertyKeysInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string2 = JsonBundle.message("inspection.duplicate.keys.name", new Object[0]);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/codeinsight/JsonDuplicatePropertyKeysInspection", "getDisplayName"));
        }
        return string2;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/json/codeinsight/JsonDuplicatePropertyKeysInspection", "buildVisitor"));
        }
        JsonElementVisitor jsonElementVisitor = new JsonElementVisitor(){

            @Override
            public void visitObject(@NotNull JsonObject o2) {
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/json/codeinsight/JsonDuplicatePropertyKeysInspection$1", "visitObject"));
                }
                MultiMap keys = new MultiMap();
                for (JsonProperty property : o2.getPropertyList()) {
                    keys.putValue((Object)property.getName(), (Object)property.getNameElement());
                }
                for (Map.Entry entry : keys.entrySet()) {
                    Collection sameNamedKeys = (Collection)entry.getValue();
                    if (sameNamedKeys.size() <= 1) continue;
                    for (PsiElement element : sameNamedKeys) {
                        holder.registerProblem(element, JsonBundle.message("inspection.duplicate.keys.msg.duplicate.keys", entry.getKey()), new LocalQuickFix[0]);
                    }
                }
            }
        };
        if (jsonElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/codeinsight/JsonDuplicatePropertyKeysInspection", "buildVisitor"));
        }
        return jsonElementVisitor;
    }
}

