/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.formatter;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.json.JsonFileType;
import com.intellij.json.JsonLanguage;
import com.intellij.json.formatter.JsonCodeStyleSettings;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonCodeStylePanel
extends CodeStyleAbstractPanel {
    public static final String ALIGNMENT_SAMPLE = "{\n    \"foo\": {\n        \"bar\": true,\n        \"baz\": false\n    },\n    \"quux\": [\n        1, 2.0, 3e0, 4.0e0\n    ],\n    \"longPropertyName\": null\n}";
    private JComboBox myPropertiesAlignmentCombo;
    private JPanel myPreviewPanel;
    private JPanel myPanel;
    private JBCheckBox myRemoveTrailingCommaCheckbox;

    public JsonCodeStylePanel(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/json/formatter/JsonCodeStylePanel", "<init>"));
        }
        super(JsonLanguage.INSTANCE, null, settings);
        this.$$$setupUI$$$();
        this.addPanelToWatch(this.myPanel);
        this.installPreviewPanel(this.myPreviewPanel);
        for (JsonCodeStyleSettings.PropertyAlignment alignment : JsonCodeStyleSettings.PropertyAlignment.values()) {
            this.myPropertiesAlignmentCombo.addItem(alignment);
        }
        this.myPropertiesAlignmentCombo.setRenderer(new ListCellRendererWrapper<JsonCodeStyleSettings.PropertyAlignment>(){

            public void customize(JList list2, JsonCodeStyleSettings.PropertyAlignment value2, int index, boolean selected, boolean hasFocus) {
                this.setText(value2.getDescription());
            }
        });
        this.myPropertiesAlignmentCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() == 1) {
                    JsonCodeStylePanel.this.somethingChanged();
                }
            }
        });
    }

    @Override
    protected int getRightMargin() {
        return 80;
    }

    @Override
    @Nullable
    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme2) {
        return EditorHighlighterFactory.getInstance().createEditorHighlighter((VirtualFile)new LightVirtualFile("a.json"), scheme2, null);
    }

    @Override
    @NotNull
    protected FileType getFileType() {
        JsonFileType jsonFileType = JsonFileType.INSTANCE;
        if (jsonFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/formatter/JsonCodeStylePanel", "getFileType"));
        }
        return jsonFileType;
    }

    @Override
    @Nullable
    protected String getPreviewText() {
        return ALIGNMENT_SAMPLE;
    }

    @Override
    public void apply(CodeStyleSettings settings) throws ConfigurationException {
        JsonCodeStyleSettings jsonSettings = this.getCustomSettings(settings);
        jsonSettings.PROPERTY_ALIGNMENT = this.getSelectedAlignmentType().getId();
        jsonSettings.REMOVE_TRAILING_COMMA = this.myRemoveTrailingCommaCheckbox.isSelected();
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        JsonCodeStyleSettings jsonSettings = this.getCustomSettings(settings);
        return jsonSettings.PROPERTY_ALIGNMENT != this.getSelectedAlignmentType().getId() || jsonSettings.REMOVE_TRAILING_COMMA != this.myRemoveTrailingCommaCheckbox.isSelected();
    }

    @Override
    @Nullable
    public JComponent getPanel() {
        return this.myPanel;
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        JsonCodeStyleSettings jsonSettings = this.getCustomSettings(settings);
        this.myRemoveTrailingCommaCheckbox.setSelected(jsonSettings.REMOVE_TRAILING_COMMA);
        for (int i2 = 0; i2 < this.myPropertiesAlignmentCombo.getItemCount(); ++i2) {
            if (((JsonCodeStyleSettings.PropertyAlignment)((Object)this.myPropertiesAlignmentCombo.getItemAt(i2))).getId() != jsonSettings.PROPERTY_ALIGNMENT) continue;
            this.myPropertiesAlignmentCombo.setSelectedIndex(i2);
            break;
        }
    }

    @NotNull
    private JsonCodeStyleSettings.PropertyAlignment getSelectedAlignmentType() {
        JsonCodeStyleSettings.PropertyAlignment propertyAlignment = (JsonCodeStyleSettings.PropertyAlignment)((Object)this.myPropertiesAlignmentCombo.getSelectedItem());
        if (propertyAlignment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/formatter/JsonCodeStylePanel", "getSelectedAlignmentType"));
        }
        return propertyAlignment;
    }

    @NotNull
    private JsonCodeStyleSettings getCustomSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/json/formatter/JsonCodeStylePanel", "getCustomSettings"));
        }
        JsonCodeStyleSettings jsonCodeStyleSettings = (JsonCodeStyleSettings)settings.getCustomSettings(JsonCodeStyleSettings.class);
        if (jsonCodeStyleSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/formatter/JsonCodeStylePanel", "getCustomSettings"));
        }
        return jsonCodeStyleSettings;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JComboBox jComboBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 10, 0, 0), -1, -1, false, false));
        this.myPreviewPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 2, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Font font = jPanel3.getFont();
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createLineBorder(Color.black), (String)ResourceBundle.getBundle("com/intellij/json/JsonBundle").getString("formatter.other.tab.group.title"), (int)0, (int)0, (Font)new Font(font.getName(), font.getStyle(), font.getSize()), (Color)new Color(-16777216)));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/json/JsonBundle").getString("formatter.other.tab.label.align.properties"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPropertiesAlignmentCombo = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(0, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        this.myRemoveTrailingCommaCheckbox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setMargin(new Insets(1, 0, 0, 1));
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("com/intellij/json/JsonBundle").getString("formatter.other.tab.remove.trailing.comma"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel2.add((Component)spacer4, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (string2.charAt(i2) == '&') {
                if (++i2 == string2.length()) break;
                if (!bl && string2.charAt(i2) != '&') {
                    bl = true;
                    c2 = string2.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i2));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n2);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (string2.charAt(i2) == '&') {
                if (++i2 == string2.length()) break;
                if (!bl && string2.charAt(i2) != '&') {
                    bl = true;
                    c2 = string2.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i2));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n2);
        }
    }
}

