/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi;

import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonParserDefinition;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonPsiUtil {
    private JsonPsiUtil() {
    }

    public static boolean isArrayElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/json/psi/JsonPsiUtil", "isArrayElement"));
        }
        return element instanceof JsonValue && element.getParent() instanceof JsonArray;
    }

    public static boolean isPropertyKey(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/json/psi/JsonPsiUtil", "isPropertyKey"));
        }
        PsiElement parent = element.getParent();
        return parent instanceof JsonProperty && element == ((JsonProperty)parent).getNameElement();
    }

    public static boolean isPropertyValue(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/json/psi/JsonPsiUtil", "isPropertyValue"));
        }
        PsiElement parent = element.getParent();
        return parent instanceof JsonProperty && element == ((JsonProperty)parent).getValue();
    }

    @NotNull
    public static PsiElement findFurthestSiblingOfSameType(@NotNull PsiElement anchor, boolean after2) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/json/psi/JsonPsiUtil", "findFurthestSiblingOfSameType"));
        }
        ASTNode node = anchor.getNode();
        IElementType expectedType = node.getElementType();
        ASTNode lastSeen = node;
        while (node != null) {
            IElementType elementType = node.getElementType();
            if (elementType == expectedType) {
                lastSeen = node;
            } else if (elementType != TokenType.WHITE_SPACE ? !JsonParserDefinition.JSON_COMMENTARIES.contains(elementType) || JsonParserDefinition.JSON_COMMENTARIES.contains(expectedType) : expectedType == JsonElementTypes.LINE_COMMENT && node.getText().indexOf(10, 1) != -1) break;
            node = after2 ? node.getTreeNext() : node.getTreePrev();
        }
        PsiElement psiElement = lastSeen.getPsi();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/JsonPsiUtil", "findFurthestSiblingOfSameType"));
        }
        return psiElement;
    }

    public static boolean hasElementType(@NotNull ASTNode node, @NotNull TokenSet set2) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/json/psi/JsonPsiUtil", "hasElementType"));
        }
        if (set2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/json/psi/JsonPsiUtil", "hasElementType"));
        }
        return set2.contains(node.getElementType());
    }

    public static boolean hasElementType(@NotNull ASTNode node, IElementType ... types) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/json/psi/JsonPsiUtil", "hasElementType"));
        }
        return JsonPsiUtil.hasElementType(node, TokenSet.create((IElementType[])types));
    }

    public static boolean hasElementType(@NotNull PsiElement element, @NotNull TokenSet set2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/json/psi/JsonPsiUtil", "hasElementType"));
        }
        if (set2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/json/psi/JsonPsiUtil", "hasElementType"));
        }
        return element.getNode() != null && JsonPsiUtil.hasElementType(element.getNode(), set2);
    }

    public static boolean hasElementType(@NotNull PsiElement element, IElementType ... types) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/json/psi/JsonPsiUtil", "hasElementType"));
        }
        return element.getNode() != null && JsonPsiUtil.hasElementType(element.getNode(), types);
    }

    @NotNull
    public static String getElementTextWithoutHostEscaping(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/json/psi/JsonPsiUtil", "getElementTextWithoutHostEscaping"));
        }
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)element.getProject());
        if (manager.isInjectedFragment(element.getContainingFile())) {
            String string2 = manager.getUnescapedText(element);
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/JsonPsiUtil", "getElementTextWithoutHostEscaping"));
            }
            return string2;
        }
        String string3 = element.getText();
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/JsonPsiUtil", "getElementTextWithoutHostEscaping"));
        }
        return string3;
    }

    @NotNull
    public static String stripQuotes(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/json/psi/JsonPsiUtil", "stripQuotes"));
        }
        if (text2.length() > 0) {
            char firstChar = text2.charAt(0);
            char lastChar = text2.charAt(text2.length() - 1);
            if (firstChar == '\'' || firstChar == '\"') {
                if (text2.length() > 1 && firstChar == lastChar && !JsonPsiUtil.isEscapedChar(text2, text2.length() - 1)) {
                    String string2 = text2.substring(1, text2.length() - 1);
                    if (string2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/JsonPsiUtil", "stripQuotes"));
                    }
                    return string2;
                }
                String string3 = text2.substring(1);
                if (string3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/JsonPsiUtil", "stripQuotes"));
                }
                return string3;
            }
        }
        String string4 = text2;
        if (string4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/JsonPsiUtil", "stripQuotes"));
        }
        return string4;
    }

    public static boolean isEscapedChar(@NotNull String text2, int position) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/json/psi/JsonPsiUtil", "isEscapedChar"));
        }
        int count = 0;
        for (int i2 = position - 1; i2 >= 0 && text2.charAt(i2) == '\\'; --i2) {
            ++count;
        }
        return count % 2 != 0;
    }

    @NotNull
    public static PsiElement addProperty(@NotNull JsonObject object, @NotNull JsonProperty property, boolean first) {
        JsonProperty lastProperty;
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/json/psi/JsonPsiUtil", "addProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/json/psi/JsonPsiUtil", "addProperty"));
        }
        List<JsonProperty> propertyList = object.getPropertyList();
        if (!first && (lastProperty = (JsonProperty)ContainerUtil.getLastItem(propertyList)) != null) {
            PsiElement addedProperty = object.addAfter(property, lastProperty);
            object.addBefore(new JsonElementGenerator(object.getProject()).createComma(), addedProperty);
            PsiElement psiElement = addedProperty;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/JsonPsiUtil", "addProperty"));
            }
            return psiElement;
        }
        PsiElement leftBrace = object.getFirstChild();
        assert (JsonPsiUtil.hasElementType(leftBrace, JsonElementTypes.L_CURLY));
        PsiElement addedProperty = object.addAfter(property, leftBrace);
        if (!propertyList.isEmpty()) {
            object.addAfter(new JsonElementGenerator(object.getProject()).createComma(), addedProperty);
        }
        PsiElement psiElement = addedProperty;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/JsonPsiUtil", "addProperty"));
        }
        return psiElement;
    }

    @NotNull
    public static Set<String> getOtherSiblingPropertyNames(@Nullable JsonProperty property) {
        if (property == null) {
            Set<String> set2 = Collections.emptySet();
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/JsonPsiUtil", "getOtherSiblingPropertyNames"));
            }
            return set2;
        }
        JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)property.getParent(), JsonObject.class);
        if (object == null) {
            Set<String> set3 = Collections.emptySet();
            if (set3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/JsonPsiUtil", "getOtherSiblingPropertyNames"));
            }
            return set3;
        }
        HashSet result2 = ContainerUtil.newHashSet();
        for (JsonProperty jsonProperty : object.getPropertyList()) {
            if (jsonProperty == property) continue;
            result2.add(jsonProperty.getName());
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/JsonPsiUtil", "getOtherSiblingPropertyNames"));
        }
        return hashSet;
    }
}

