/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi.impl;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiLanguageInjectionHost;
import org.jetbrains.annotations.NotNull;

public abstract class JSStringLiteralEscaper<T extends PsiLanguageInjectionHost>
extends LiteralTextEscaper<T> {
    private int[] outSourceOffsets;

    public JSStringLiteralEscaper(T host) {
        super(host);
    }

    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        if (rangeInsideHost == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInsideHost", "com/intellij/json/psi/impl/JSStringLiteralEscaper", "decode"));
        }
        if (outChars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outChars", "com/intellij/json/psi/impl/JSStringLiteralEscaper", "decode"));
        }
        String subText = rangeInsideHost.substring(this.myHost.getText());
        Ref sourceOffsetsRef = new Ref();
        boolean result2 = JSStringLiteralEscaper.parseStringCharacters(subText, outChars, (Ref<int[]>)sourceOffsetsRef, this.isRegExpLiteral(), !this.isOneLine());
        this.outSourceOffsets = (int[])sourceOffsetsRef.get();
        return result2;
    }

    protected abstract boolean isRegExpLiteral();

    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        int result2;
        if (rangeInsideHost == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInsideHost", "com/intellij/json/psi/impl/JSStringLiteralEscaper", "getOffsetInHost"));
        }
        int n2 = result2 = offsetInDecoded < this.outSourceOffsets.length ? this.outSourceOffsets[offsetInDecoded] : -1;
        if (result2 == -1) {
            return -1;
        }
        return (result2 <= rangeInsideHost.getLength() ? result2 : rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
    }

    public boolean isOneLine() {
        return true;
    }

    public static boolean parseStringCharacters(String chars, StringBuilder outChars, Ref<int[]> sourceOffsetsRef, boolean regExp, boolean escapeBacktick) {
        int[] sourceOffsets = new int[chars.length() + 1];
        sourceOffsetsRef.set((Object)sourceOffsets);
        if (chars.indexOf(92) < 0) {
            outChars.append(chars);
            for (int i2 = 0; i2 < sourceOffsets.length; ++i2) {
                sourceOffsets[i2] = i2;
            }
            return true;
        }
        int index = 0;
        int outOffset = outChars.length();
        while (index < chars.length()) {
            char c2 = chars.charAt(index++);
            sourceOffsets[outChars.length() - outOffset] = index - 1;
            sourceOffsets[outChars.length() + 1 - outOffset] = index;
            if (c2 != '\\') {
                outChars.append(c2);
                continue;
            }
            if (index == chars.length()) {
                return false;
            }
            c2 = chars.charAt(index++);
            if (escapeBacktick && c2 == '`') {
                outChars.append(c2);
            } else if (regExp) {
                if (c2 != '/') {
                    outChars.append('\\');
                }
                outChars.append(c2);
            } else {
                switch (c2) {
                    case 'b': {
                        outChars.append('\b');
                        break;
                    }
                    case 't': {
                        outChars.append('\t');
                        break;
                    }
                    case 'n': {
                        outChars.append('\n');
                        break;
                    }
                    case 'f': {
                        outChars.append('\f');
                        break;
                    }
                    case 'r': {
                        outChars.append('\r');
                        break;
                    }
                    case '\"': {
                        outChars.append('\"');
                        break;
                    }
                    case '/': {
                        outChars.append('/');
                        break;
                    }
                    case '\n': {
                        outChars.append('\n');
                        break;
                    }
                    case '\'': {
                        outChars.append('\'');
                        break;
                    }
                    case '\\': {
                        outChars.append('\\');
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char startC = c2;
                        int v2 = c2 - 48;
                        if (index < chars.length()) {
                            if ('0' <= (c2 = chars.charAt(index++)) && c2 <= '7') {
                                v2 <<= 3;
                                v2 += c2 - 48;
                                if (startC <= '3' && index < chars.length()) {
                                    if ('0' <= (c2 = chars.charAt(index++)) && c2 <= '7') {
                                        v2 <<= 3;
                                        v2 += c2 - 48;
                                    }
                                }
                            } else {
                                --index;
                            }
                        }
                        outChars.append((char)v2);
                        break;
                    }
                    case 'x': {
                        int v3;
                        if (index + 2 <= chars.length()) {
                            try {
                                v3 = Integer.parseInt(chars.substring(index, index + 2), 16);
                                outChars.append((char)v3);
                                index += 2;
                                break;
                            }
                            catch (Exception e2) {
                                return false;
                            }
                        }
                        return false;
                    }
                    case 'u': {
                        int v3;
                        if (index + 4 <= chars.length()) {
                            try {
                                v3 = Integer.parseInt(chars.substring(index, index + 4), 16);
                                if (v3 == 10 || v3 == 13) {
                                    return false;
                                }
                                c2 = chars.charAt(index);
                                if (c2 == '+' || c2 == '-') {
                                    return false;
                                }
                                outChars.append((char)v3);
                                index += 4;
                                break;
                            }
                            catch (Exception e3) {
                                return false;
                            }
                        }
                        return false;
                    }
                    default: {
                        outChars.append(c2);
                    }
                }
            }
            sourceOffsets[outChars.length() - outOffset] = --index;
        }
        return true;
    }
}

