/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi.impl;

import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonPropertyNameReference
implements PsiReference {
    private final JsonProperty myProperty;

    public JsonPropertyNameReference(@NotNull JsonProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/json/psi/impl/JsonPropertyNameReference", "<init>"));
        }
        this.myProperty = property;
    }

    public PsiElement getElement() {
        return this.myProperty;
    }

    public TextRange getRangeInElement() {
        JsonValue nameElement = this.myProperty.getNameElement();
        return ElementManipulators.getValueTextRange((PsiElement)nameElement);
    }

    @Nullable
    public PsiElement resolve() {
        return this.myProperty;
    }

    @NotNull
    public String getCanonicalText() {
        String string2 = this.myProperty.getName();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/impl/JsonPropertyNameReference", "getCanonicalText"));
        }
        return string2;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this.myProperty.setName(newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/json/psi/impl/JsonPropertyNameReference", "bindToElement"));
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof JsonProperty)) {
            return false;
        }
        JsonProperty otherProperty = (JsonProperty)element;
        PsiElement selfResolve = this.resolve();
        return otherProperty.getName().equals(this.getCanonicalText()) && selfResolve != otherProperty;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/impl/JsonPropertyNameReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return true;
    }
}

