/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.customFolding;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.Language;
import com.intellij.lang.customFolding.CustomFoldingRegionsPopup;
import com.intellij.lang.folding.CompositeFoldingBuilder;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoCustomRegionAction
extends AnAction
implements DumbAware,
PopupAction {
    public void actionPerformed(AnActionEvent e2) {
        Project project2 = e2.getProject();
        Editor editor = (Editor)e2.getData(CommonDataKeys.EDITOR);
        if (Boolean.TRUE.equals(e2.getData(PlatformDataKeys.IS_MODAL_CONTEXT))) {
            return;
        }
        if (project2 != null && editor != null) {
            if (DumbService.getInstance((Project)project2).isDumb()) {
                DumbService.getInstance((Project)project2).showDumbModeNotification(IdeBundle.message((String)"goto.custom.region.message.dumb.mode", (Object[])new Object[0]));
                return;
            }
            CommandProcessor processor2 = CommandProcessor.getInstance();
            processor2.executeCommand(project2, () -> {
                Collection<FoldingDescriptor> foldingDescriptors = GotoCustomRegionAction.getCustomFoldingDescriptors(editor, project2);
                if (foldingDescriptors.size() > 0) {
                    CustomFoldingRegionsPopup regionsPopup = new CustomFoldingRegionsPopup(foldingDescriptors, editor, project2);
                    regionsPopup.show();
                } else {
                    GotoCustomRegionAction.notifyCustomRegionsUnavailable(editor, project2);
                }
            }, IdeBundle.message((String)"goto.custom.region.command", (Object[])new Object[0]), null);
        }
    }

    public void update(AnActionEvent e2) {
        Presentation presentation = e2.getPresentation();
        presentation.setText(IdeBundle.message((String)"goto.custom.region.menu.item", (Object[])new Object[0]));
        Editor editor = (Editor)e2.getData(CommonDataKeys.EDITOR);
        Project project2 = e2.getProject();
        boolean isAvailable = editor != null && project2 != null;
        presentation.setEnabled(isAvailable);
        presentation.setVisible(isAvailable);
    }

    @NotNull
    private static Collection<FoldingDescriptor> getCustomFoldingDescriptors(@NotNull Editor editor, @NotNull Project project2) {
        PsiFile file2;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/customFolding/GotoCustomRegionAction", "getCustomFoldingDescriptors"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/customFolding/GotoCustomRegionAction", "getCustomFoldingDescriptors"));
        }
        HashSet foldingDescriptors = new HashSet();
        Document document = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        PsiFile psiFile = file2 = documentManager != null ? documentManager.getPsiFile(document) : null;
        if (file2 != null) {
            FileViewProvider viewProvider = file2.getViewProvider();
            for (Language language : viewProvider.getLanguages()) {
                PsiFile psi = viewProvider.getPsi(language);
                FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language);
                if (psi == null) continue;
                for (FoldingDescriptor descriptor2 : LanguageFolding.buildFoldingDescriptors((FoldingBuilder)foldingBuilder, (PsiElement)psi, (Document)document, (boolean)false)) {
                    CustomFoldingBuilder customFoldingBuilder = GotoCustomRegionAction.getCustomFoldingBuilder(foldingBuilder, descriptor2);
                    if (customFoldingBuilder == null || !customFoldingBuilder.isCustomRegionStart(descriptor2.getElement())) continue;
                    foldingDescriptors.add(descriptor2);
                }
            }
        }
        HashSet hashSet = foldingDescriptors;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/customFolding/GotoCustomRegionAction", "getCustomFoldingDescriptors"));
        }
        return hashSet;
    }

    @Nullable
    private static CustomFoldingBuilder getCustomFoldingBuilder(FoldingBuilder builder, FoldingDescriptor descriptor2) {
        if (builder instanceof CustomFoldingBuilder) {
            return (CustomFoldingBuilder)builder;
        }
        FoldingBuilder originalBuilder = (FoldingBuilder)descriptor2.getElement().getUserData(CompositeFoldingBuilder.FOLDING_BUILDER);
        if (originalBuilder instanceof CustomFoldingBuilder) {
            return (CustomFoldingBuilder)originalBuilder;
        }
        return null;
    }

    private static void notifyCustomRegionsUnavailable(@NotNull Editor editor, @NotNull Project project2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/customFolding/GotoCustomRegionAction", "notifyCustomRegionsUnavailable"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/customFolding/GotoCustomRegionAction", "notifyCustomRegionsUnavailable"));
        }
        JBPopupFactory popupFactory = JBPopupFactory.getInstance();
        Balloon balloon = popupFactory.createHtmlTextBalloonBuilder(IdeBundle.message((String)"goto.custom.region.message.unavailable", (Object[])new Object[0]), MessageType.INFO, null).setFadeoutTime(2000L).setHideOnClickOutside(true).setHideOnKeyOutside(true).createBalloon();
        Disposer.register((Disposable)project2, (Disposable)balloon);
        balloon.show(popupFactory.guessBestPopupLocation(editor), Balloon.Position.below);
    }
}

