/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.lang.LangBundle;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeDecl;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;

public class XmlFindUsagesProvider
implements FindUsagesProvider {
    public boolean canFindUsagesFor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/xml/XmlFindUsagesProvider", "canFindUsagesFor"));
        }
        return element instanceof XmlElementDecl || element instanceof XmlAttributeDecl || element instanceof XmlEntityDecl || element instanceof XmlTag || element instanceof XmlAttributeValue || element instanceof PsiFile || element instanceof XmlComment;
    }

    @NotNull
    public String getType(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/xml/XmlFindUsagesProvider", "getType"));
        }
        if (element instanceof XmlTag) {
            PsiMetaData metaData = ((XmlTag)element).getMetaData();
            if (metaData != null && metaData.getDeclaration() instanceof XmlTag) {
                String string2 = ((XmlTag)metaData.getDeclaration()).getName();
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getType"));
                }
                return string2;
            }
            String string3 = LangBundle.message("xml.terms.xml.tag", new Object[0]);
            if (string3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getType"));
            }
            return string3;
        }
        if (element instanceof XmlElementDecl) {
            String string4 = LangBundle.message("xml.terms.tag", new Object[0]);
            if (string4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getType"));
            }
            return string4;
        }
        if (element instanceof XmlAttributeDecl) {
            String string5 = LangBundle.message("xml.terms.attribute", new Object[0]);
            if (string5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getType"));
            }
            return string5;
        }
        if (element instanceof XmlAttributeValue) {
            String string6 = LangBundle.message("xml.terms.attribute.value", new Object[0]);
            if (string6 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getType"));
            }
            return string6;
        }
        if (element instanceof XmlEntityDecl) {
            String string7 = LangBundle.message("xml.terms.entity", new Object[0]);
            if (string7 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getType"));
            }
            return string7;
        }
        if (element instanceof XmlAttribute) {
            String string8 = LangBundle.message("xml.terms.attribute", new Object[0]);
            if (string8 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getType"));
            }
            return string8;
        }
        if (element instanceof XmlComment) {
            String string9 = LangBundle.message("xml.terms.variable", new Object[0]);
            if (string9 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getType"));
            }
            return string9;
        }
        throw new IllegalArgumentException("Cannot get type for " + element);
    }

    public String getHelpId(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/xml/XmlFindUsagesProvider", "getHelpId"));
        }
        return "reference.dialogs.findUsages.other";
    }

    @NotNull
    public String getDescriptiveName(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/xml/XmlFindUsagesProvider", "getDescriptiveName"));
        }
        if (element instanceof XmlTag) {
            String string2 = ((XmlTag)element).getName();
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getDescriptiveName"));
            }
            return string2;
        }
        if (element instanceof XmlAttributeValue) {
            String string3 = ((XmlAttributeValue)element).getValue();
            if (string3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getDescriptiveName"));
            }
            return string3;
        }
        if (element instanceof PsiNamedElement) {
            String string4 = ((PsiNamedElement)element).getName();
            if (string4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getDescriptiveName"));
            }
            return string4;
        }
        String string5 = element.getText();
        if (string5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getDescriptiveName"));
        }
        return string5;
    }

    @NotNull
    public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/xml/XmlFindUsagesProvider", "getNodeText"));
        }
        if (element instanceof XmlTag) {
            XmlTag xmlTag = (XmlTag)element;
            PsiMetaData metaData = xmlTag.getMetaData();
            String name = metaData != null ? DescriptiveNameUtil.getMetaDataName((PsiMetaData)metaData) : xmlTag.getName();
            String presentableName = metaData == null ? "<" + name + ">" : name;
            String string2 = presentableName + " of file " + xmlTag.getContainingFile().getName();
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getNodeText"));
            }
            return string2;
        }
        if (element instanceof XmlAttributeValue) {
            String string3 = ((XmlAttributeValue)element).getValue();
            if (string3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getNodeText"));
            }
            return string3;
        }
        if (element instanceof PsiNamedElement) {
            String string4 = ((PsiNamedElement)element).getName();
            if (string4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getNodeText"));
            }
            return string4;
        }
        String string5 = element.getText();
        if (string5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlFindUsagesProvider", "getNodeText"));
        }
        return string5;
    }

    public WordsScanner getWordsScanner() {
        return null;
    }
}

