/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.codeInsight.template.HtmlContextType;
import com.intellij.codeInsight.template.XmlContextType;
import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class XmlSurroundDescriptor
implements SurroundDescriptor {
    @NotNull
    public PsiElement[] getElementsToSurround(PsiFile file2, int startOffset, int endOffset) {
        Pair<XmlTagChild, XmlTagChild> childrenInRange = XmlUtil.findTagChildrenInRange(file2, startOffset, endOffset);
        if (childrenInRange == null) {
            PsiElement elementAt = file2.findElementAt(startOffset);
            if (elementAt instanceof XmlToken && ((XmlToken)elementAt).getTokenType() == XmlTokenType.XML_DATA_CHARACTERS) {
                PsiElement[] psiElementArray = new PsiElement[]{elementAt};
                if (psiElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlSurroundDescriptor", "getElementsToSurround"));
                }
                return psiElementArray;
            }
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlSurroundDescriptor", "getElementsToSurround"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        PsiElement first = (PsiElement)childrenInRange.getFirst();
        PsiElement last = (PsiElement)childrenInRange.getSecond();
        while (true) {
            result2.add(first);
            if (first == last) break;
            first = first.getNextSibling();
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result2);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlSurroundDescriptor", "getElementsToSurround"));
        }
        return psiElementArray;
    }

    @NotNull
    public Surrounder[] getSurrounders() {
        Surrounder[] surrounderArray = new Surrounder[]{};
        if (surrounderArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/xml/XmlSurroundDescriptor", "getSurrounders"));
        }
        return surrounderArray;
    }

    public boolean isExclusive() {
        return false;
    }

    protected boolean isEnabled(TemplateImpl template) {
        TemplateContext context2 = template.getTemplateContext();
        return context2.isEnabled(new XmlContextType()) || context2.isEnabled(new HtmlContextType());
    }
}

