/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.lang.ASTFactory;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.TreePatcher;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.CharTable;

public class XmlTemplateTreePatcher
implements TreePatcher {
    @Override
    public void insert(CompositeElement parent, TreeElement anchorBefore, OuterLanguageElement toInsert) {
        if (anchorBefore != null) {
            if (anchorBefore.getElementType() == XmlTokenType.XML_START_TAG_START) {
                anchorBefore = anchorBefore.getTreeParent();
            }
            anchorBefore.rawInsertBeforeMe((TreeElement)toInsert);
        } else {
            parent.rawAddChildren((TreeElement)toInsert);
        }
    }

    @Override
    public LeafElement split(LeafElement leaf, int offset, CharTable table2) {
        CharSequence chars = leaf.getChars();
        LeafElement leftPart = ASTFactory.leaf(leaf.getElementType(), table2.intern(chars, 0, offset));
        LeafElement rightPart = ASTFactory.leaf(leaf.getElementType(), table2.intern(chars, offset, chars.length()));
        leaf.rawInsertAfterMe(leftPart);
        leftPart.rawInsertAfterMe(rightPart);
        leaf.rawRemove();
        return leftPart;
    }
}

