/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.licensecommon.client.impl;

import com.intellij.licensecommon.client.LicenseClientApplication;
import com.intellij.licensecommon.client.StartUpFailedException;
import com.intellij.licensecommon.license.LicenseBroadcastData;
import com.intellij.licensecommon.log.Log;
import com.intellij.licensecommon.log.Logger;
import com.intellij.licensecommon.message.Message;
import com.intellij.licensecommon.message.MessageClient;
import com.intellij.licensecommon.message.MessageFactory;
import com.intellij.licensecommon.net.Address;
import com.intellij.licensecommon.net.Network;
import com.intellij.licensecommon.net.NetworkTarget;
import com.intellij.openapi.util.Pair;
import com.intellij.util.concurrency.Semaphore;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientImpl<M extends Message>
implements NetworkTarget<M>,
MessageClient {
    private static final Logger LOG = Log.FACTORY.getInstance("#com.intellij.licensecommon.client.impl.ClientImpl");
    private final Network<M> myNetwork;
    private final MessageFactory<M> myMessageFactory;
    private final ScheduledExecutorService myScheduler;
    private final LicenseClientApplication myApplication;
    private final AtomicReference<Pair<LicenseBroadcastData, Future>> myCurrentBroadcastData = new AtomicReference<Object>(null);
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long BROADCAST_PERIOD = 600000L;
    private static final long INITIAL_BROADCAST_PERIOD = 100L;

    public ClientImpl(LicenseClientApplication application, Network<M> network, MessageFactory<M> messageFactory, ScheduledExecutorService scheduler) {
        this.myApplication = application;
        this.myNetwork = network;
        this.myMessageFactory = messageFactory;
        this.myScheduler = scheduler;
    }

    private void ensureNetworkStarted() throws StartUpFailedException {
        try {
            if (!this.myNetwork.isStarted()) {
                this.myNetwork.startWith(this);
            }
        }
        catch (Throwable t2) {
            this.myNetwork.shutDown();
            throw new StartUpFailedException(t2);
        }
    }

    public void broadcastLicenseData(@Nullable LicenseBroadcastData license) {
        if (license != null) {
            this.scheduleBroadcasts(license);
        } else {
            this.cancelBroadcastTask();
            this.myNetwork.shutDown();
        }
    }

    private void scheduleBroadcasts(@NotNull LicenseBroadcastData broadcastData) {
        if (broadcastData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "broadcastData", "com/intellij/licensecommon/client/impl/ClientImpl", "scheduleBroadcasts"));
        }
        BroadcastTask broadcastTask = new BroadcastTask(broadcastData);
        ScheduledFuture<?> scheduledFuture = this.myScheduler.scheduleWithFixedDelay(broadcastTask, 100L, 600000L, TimeUnit.MILLISECONDS);
        Pair<LicenseBroadcastData, Future> previous = this.myCurrentBroadcastData.getAndSet((Pair<LicenseBroadcastData, Future>)Pair.create((Object)broadcastData, scheduledFuture));
        broadcastTask.enable();
        if (previous != null) {
            ((Future)previous.second).cancel(false);
        }
    }

    public void cancelBroadcastTask() {
        Pair task2 = this.myCurrentBroadcastData.getAndSet(null);
        if (task2 != null) {
            ((Future)task2.second).cancel(false);
        }
    }

    @Override
    @Nullable
    public LicenseBroadcastData getBroadcastData() {
        Pair<LicenseBroadcastData, Future> pair = this.myCurrentBroadcastData.get();
        return pair != null ? (LicenseBroadcastData)pair.getFirst() : null;
    }

    @Override
    public void duplicateLicenseDetected(Address from, LicenseBroadcastData conflictingData) {
        this.myApplication.duplicateLicenseDetected(from, conflictingData);
    }

    @Override
    public void receivedData(M message2, Address from) throws Exception {
        message2.receivedAt(this, from);
    }

    @Override
    public void receivedFatalNetworkFailure(Throwable failure) {
        LOG.info(failure.getMessage());
    }

    @Override
    public void dataDeliveryFailure(Throwable failure) {
        LOG.info(failure.getMessage());
    }

    private class BroadcastTask
    implements Runnable {
        private final LicenseBroadcastData myBroadcastData;
        private final Semaphore myEnabledSemaphore = new Semaphore();

        public BroadcastTask(LicenseBroadcastData broadcastData) {
            this.myBroadcastData = broadcastData;
            this.myEnabledSemaphore.down();
        }

        public void enable() {
            this.myEnabledSemaphore.up();
        }

        @Override
        public void run() {
            block6: {
                try {
                    ClientImpl.this.ensureNetworkStarted();
                    Object msg = ClientImpl.this.myMessageFactory.createBroadcastMessage(this.myBroadcastData);
                    if (msg == null) break block6;
                    try {
                        this.myEnabledSemaphore.waitFor();
                        Pair currentData = (Pair)ClientImpl.this.myCurrentBroadcastData.get();
                        if (currentData != null && this.myBroadcastData.equals(currentData.first)) {
                            ClientImpl.this.myNetwork.broadcast(msg);
                        }
                    }
                    catch (Throwable t2) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(t2);
                        }
                    }
                }
                catch (Throwable t3) {
                    if (!LOG.isDebugEnabled()) break block6;
                    LOG.debug(t3);
                }
            }
        }
    }
}

