/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.licensecommon.license;

import com.intellij.licensecommon.license.AbstractLicenseData;
import com.intellij.licensecommon.util.InvalidLicenseKeyException;
import com.intellij.licensecommon.util.LicenseInfo;
import java.util.Date;

public abstract class LegacyKeyBasedLicenseData
extends AbstractLicenseData {
    private static final long HACKED_LICENSE_TIMESTAMP = 1207994548224L;
    private static final long HACKED_LICENSE_TIMESTAMP2 = 1242108854272L;
    private static final long HACKED_LICENSE_TIMESTAMP3 = 1271008854016L;
    private final String myKey;
    private final String myUserName;
    protected LicenseInfo myInfo = null;

    public LegacyKeyBasedLicenseData(String key, String userName) {
        this.myKey = key;
        this.myUserName = userName;
    }

    @Override
    public String getKey() {
        return this.myKey;
    }

    @Override
    public String getUserName() {
        return this.myUserName;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof LegacyKeyBasedLicenseData)) {
            return false;
        }
        LegacyKeyBasedLicenseData abstractLicenseData = (LegacyKeyBasedLicenseData)o2;
        if (this.myKey != null ? !this.myKey.equals(abstractLicenseData.myKey) : abstractLicenseData.myKey != null) {
            return false;
        }
        return !(this.myUserName != null ? !this.myUserName.equals(abstractLicenseData.myUserName) : abstractLicenseData.myUserName != null);
    }

    public int hashCode() {
        int result2 = this.myKey != null ? this.myKey.hashCode() : 0;
        result2 = 29 * result2 + (this.myUserName != null ? this.myUserName.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return this.getUserName() + ":" + this.getKey();
    }

    @Override
    public boolean isExpired(Date currentDate) {
        if (currentDate == null) {
            return false;
        }
        Date expirationDate = this.getExpirationDate();
        if (expirationDate == null) {
            return false;
        }
        return currentDate.after(expirationDate);
    }

    @Override
    public boolean isValid() {
        this.decode();
        return this.isDecoded();
    }

    protected void decode() {
        if (this.isDecoded()) {
            return;
        }
        try {
            this.myInfo = this.decodeInternal();
        }
        catch (InvalidLicenseKeyException e2) {
            this.myInfo = this.getNullObjectLicense();
        }
    }

    protected abstract LicenseInfo decodeInternal() throws InvalidLicenseKeyException;

    protected LicenseInfo getNullObjectLicense() {
        return LicenseInfo.NULL_OBJECT;
    }

    private boolean isDecoded() {
        return this.myInfo != null && this.myInfo != this.getNullObjectLicense();
    }

    @Override
    public Date getExpirationDate() {
        this.decode();
        return this.myInfo.expirationDate;
    }

    @Override
    public boolean isNonCommercial() {
        this.decode();
        return this.myInfo.licenseType == 1;
    }

    public boolean isSite() {
        this.decode();
        return this.myInfo.licenseType == 2;
    }

    @Override
    public boolean isOpenSource() {
        this.decode();
        return this.myInfo.licenseType == 3;
    }

    @Override
    public boolean isYearAcademic() {
        this.decode();
        return this.myInfo.licenseType == 5;
    }

    @Override
    public boolean shouldDetectDuplicates() {
        return !this.isSite() && !this.isOpenSource() && !this.isYearAcademic();
    }

    @Override
    public boolean isPersonal() {
        this.decode();
        return this.myInfo.licenseType == 4;
    }

    @Override
    public Date getGenerationDate() {
        this.decode();
        return this.myInfo.generationDate;
    }

    @Override
    public boolean isHacked() {
        Date date = this.getGenerationDate();
        if (date == null) {
            return false;
        }
        long time = date.getTime();
        return time == 1207994548224L || time == 1242108854272L || time == 1271008854016L;
    }

    @Override
    public int getMajorVersion() {
        this.decode();
        return this.myInfo.majorVersion;
    }

    public int getProductId() {
        this.decode();
        return this.myInfo.productId;
    }
}

