/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.licensecommon.license;

import com.intellij.licensecommon.license.LegacyKeyBasedLicenseData;
import com.intellij.licensecommon.license.LicenseInfoDecoder;
import com.intellij.licensecommon.license.MaintenanceDueAware;
import com.intellij.licensecommon.util.InvalidLicenseKeyException;
import com.intellij.licensecommon.util.SubscriptionLicenseDecoder;
import com.intellij.licensecommon.util.SubscriptionLicenseInfo;
import java.util.Date;
import java.util.regex.Pattern;

public class SubscriptionLicenseDataImpl
extends LegacyKeyBasedLicenseData
implements MaintenanceDueAware {
    private static final Pattern ourHeaderPattern = Pattern.compile("=+\\s+LICENSE (BEGIN|END)\\s+=+");
    private final LicenseInfoDecoder<SubscriptionLicenseInfo> myDecoder;

    public SubscriptionLicenseDataImpl(String key, String userName) {
        super(SubscriptionLicenseDataImpl.stripHeaders(key), userName);
        this.myDecoder = new LicenseInfoDecoder<SubscriptionLicenseInfo>(){

            @Override
            public SubscriptionLicenseInfo decode(String key, String userName) throws InvalidLicenseKeyException {
                return SubscriptionLicenseDecoder.decode(key, userName);
            }
        };
    }

    public SubscriptionLicenseDataImpl(String key, String userName, LicenseInfoDecoder<SubscriptionLicenseInfo> decoder) {
        super(SubscriptionLicenseDataImpl.stripHeaders(key), userName);
        this.myDecoder = decoder;
    }

    @Override
    protected SubscriptionLicenseInfo decodeInternal() throws InvalidLicenseKeyException {
        return this.myDecoder.decode(this.getKey(), this.getUserName());
    }

    @Override
    protected SubscriptionLicenseInfo getNullObjectLicense() {
        return SubscriptionLicenseInfo.NULL_OBJECT;
    }

    @Override
    public Date getMaintenanceDueDate() {
        this.decode();
        return ((SubscriptionLicenseInfo)this.myInfo).maintenanceDueDate;
    }

    private static String stripHeaders(String key) {
        return key == null || key.isEmpty() ? key : ourHeaderPattern.matcher(key).replaceAll("").trim();
    }
}

