/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.licensecommon.message.impl;

import com.intellij.licensecommon.license.LicenseBroadcastData;
import com.intellij.licensecommon.message.Message;
import com.intellij.licensecommon.message.MessageClient;
import com.intellij.licensecommon.net.Address;
import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.NotNull;

public class ResharperMessage
implements Message {
    @NotNull
    private final LicenseBroadcastData myBroadcastData;

    public ResharperMessage(@NotNull LicenseBroadcastData broadcastData) {
        if (broadcastData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "broadcastData", "com/intellij/licensecommon/message/impl/ResharperMessage", "<init>"));
        }
        this.myBroadcastData = broadcastData;
    }

    @NotNull
    public LicenseBroadcastData getBroadcastData() {
        LicenseBroadcastData licenseBroadcastData = this.myBroadcastData;
        if (licenseBroadcastData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/licensecommon/message/impl/ResharperMessage", "getBroadcastData"));
        }
        return licenseBroadcastData;
    }

    @Override
    public void receivedAt(MessageClient client, Address from) throws Exception {
        if (this.myBroadcastData.getCode() != 0) {
            return;
        }
        LicenseBroadcastData clientLicense = client.getBroadcastData();
        if (clientLicense != null) {
            boolean shouldNotifyCollision;
            boolean bl = shouldNotifyCollision = !Comparing.equal((String)this.myBroadcastData.getUserLogin(), (String)clientLicense.getUserLogin(), (boolean)false) && Comparing.equal((String)this.myBroadcastData.getLicenseKeyId(), (String)clientLicense.getLicenseKeyId());
            if (shouldNotifyCollision) {
                client.duplicateLicenseDetected(from, this.myBroadcastData);
            }
        }
    }
}

