/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.licensecommon.net;

import com.intellij.licensecommon.net.Address;
import java.util.Arrays;

public class Packet {
    private final HashableByteArray bytes;
    private final Address address;

    public Packet(byte[] bytes, Address address) {
        this.bytes = new HashableByteArray(bytes);
        this.address = address;
    }

    public Address getAddress() {
        return this.address;
    }

    public byte[] getBytes() {
        return this.bytes.getBytes();
    }

    public String toString() {
        return "Packet{" + this.address + ":" + this.bytes + "}";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof Packet)) {
            return false;
        }
        Packet packet = (Packet)o2;
        if (this.address != null ? !this.address.equals(packet.address) : packet.address != null) {
            return false;
        }
        return !(this.bytes != null ? !this.bytes.equals(packet.bytes) : packet.bytes != null);
    }

    public int hashCode() {
        int result2 = this.bytes != null ? this.bytes.hashCode() : 0;
        result2 = 29 * result2 + (this.address != null ? this.address.hashCode() : 0);
        return result2;
    }

    private static class HashableByteArray {
        private final byte[] bytes;

        private HashableByteArray(byte[] bytes) {
            this.bytes = bytes;
        }

        private byte[] getBytes() {
            return this.bytes;
        }

        public String toString() {
            return new String(this.bytes);
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof HashableByteArray)) {
                return false;
            }
            HashableByteArray hashableByteArray = (HashableByteArray)o2;
            return Arrays.equals(this.bytes, hashableByteArray.bytes);
        }

        public int hashCode() {
            return new String(this.bytes).hashCode();
        }
    }
}

