/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.licensecommon.net.impl;

import com.intellij.licensecommon.net.Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class AddressImpl
implements Address {
    private final InetSocketAddress myAddress;

    public AddressImpl(String host, int port) {
        this(new InetSocketAddress(host, port));
    }

    public AddressImpl(InetSocketAddress address) {
        this.myAddress = address;
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return this.myAddress;
    }

    public String toString() {
        return this.myAddress.toString();
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof AddressImpl)) {
            return false;
        }
        AddressImpl other = (AddressImpl)o2;
        return !(this.myAddress == null ? other.myAddress != null : !this.myAddress.equals(other.myAddress));
    }

    @Override
    public int hashCode() {
        return this.myAddress == null ? 0 : this.myAddress.hashCode();
    }

    @Override
    public String getDisplay() {
        InetAddress inetAddress = this.getSocketAddress().getAddress();
        return inetAddress.getHostName() + " (" + inetAddress.getHostAddress() + ")";
    }

    @Override
    public boolean isAnyLocalAddress() {
        InetAddress thisAddress = this.getSocketAddress().getAddress();
        if (thisAddress != null && thisAddress.isLoopbackAddress()) {
            return true;
        }
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                Enumeration<InetAddress> localAddresses = ni.getInetAddresses();
                while (localAddresses.hasMoreElements()) {
                    InetAddress localAddress = localAddresses.nextElement();
                    if (!localAddress.equals(thisAddress)) continue;
                    return true;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return false;
    }
}

